<?php
/**
 * @package Expert Themes
 */
$archive_readmore_text = dailyfit()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'dailyfit'));
$archive_author = dailyfit()->get_theme_opt( 'archive_author', true );
$archive_date = dailyfit()->get_theme_opt( 'archive_date', true );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('exp---post exp-item--archive exp-item--listing'); ?>>
    <?php if (has_post_thumbnail()) { 
        $img_url = get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>
        <div class="exp-item--image bg-image" style="background-image: url(<?php echo esc_url($img_url); ?>);">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>"></a>
        </div>
    <?php } ?>
    <div class="exp-item--holder">
        <h2 class="exp-item--title">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                <?php the_title(); ?>
            </a>
        </h2>
        <div class="exp-post--meta">
            <?php if($archive_date) : ?>
                <div class="exp-item--date exp-flex"><i class="fa-regular fa-calendar exp-mr-6"></i><?php echo get_the_date(); ?></div>
            <?php endif; ?>
            <?php if($archive_author) : ?>
                <div class="exp-item--author exp-flex"><i class="fa-regular fa-user exp-mr-6"></i><?php echo esc_html__('by', 'dailyfit'); ?>&nbsp;<?php the_author_posts_link(); ?></div>
            <?php endif; ?>
        </div>
        <div class="exp-item--excerpt">
            <?php
                dailyfit()->blog->get_excerpt();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
        <div class="exp-item--more">
            <a href="<?php echo esc_url( get_permalink()); ?>">
                <i class="fa fa-angle-right"></i>
                <span><?php echo dailyfit_html($archive_readmore_text); ?></span>
            </a>
        </div>
    </div>
</article>