<?php
/**
 * @package Expert Themes
 */
$archive_category = dailyfit()->get_theme_opt( 'archive_category', true );
$archive_author = dailyfit()->get_theme_opt( 'archive_author', true );
$archive_date = dailyfit()->get_theme_opt( 'archive_date', true );
$blog_layout = dailyfit()->get_page_opt('blog_layout', 'standard');
if(isset($_GET['blog_layout'])) {
    $blog_layout = $_GET['blog_layout'];
} ?>
<article id="post-<?php the_ID(); ?>" <?php post_class('exp---post exp-item--archive exp-item--'.$blog_layout); ?>>
    <?php if (has_post_thumbnail()) { 
        echo '<div class="exp-item--image">'; ?>
            <a href="<?php echo esc_url( get_permalink()); ?>"><?php the_post_thumbnail('dailyfit-medium'); ?></a>
            <?php if($archive_category) : ?>
                <div class="exp-post--category"><?php the_terms( get_the_ID(), 'category', '', ', ', '' ); ?></div>
            <?php endif; ?>
        <?php echo '</div>';
    } ?>
    <div class="exp-item--holder">
        <h2 class="exp-item--title">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                <?php the_title(); ?>
            </a>
        </h2>
        <div class="exp-item--excerpt">
            <?php
                dailyfit()->blog->get_excerpt();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
        <div class="exp-post--meta exp-flex">
            <?php if($archive_date) : ?>
                <div class="exp-item--date exp-flex"><i class="flaticon-check-1 exp-mr-8"></i><?php echo get_the_date(); ?></div>
            <?php endif; ?>
            <?php if($archive_author) : ?>
                <div class="exp-item--author exp-flex"><i class="flaticon-user-1 exp-mr-8"></i><?php echo esc_html__('by', 'dailyfit'); ?>&nbsp;<?php the_author_posts_link(); ?></div>
            <?php endif; ?>
        </div>
    </div>
</article>