<?php
/**
 * @package Expert Themes
 */
get_header();
$dailyfit_sidebar = dailyfit()->get_sidebar_args(['type' => 'page', 'content_col'=> '8']);
if(class_exists('\Elementor\Plugin') && !$dailyfit_sidebar['sidebar_class']){
    $id = get_the_ID();
    if ( is_singular() && \Elementor\Plugin::$instance->documents->get( $id )->is_built_with_elementor() ) {
        $classes = 'elementor-container';
    } else {
        $classes = 'auto-container';
    }
} else {
    $classes = 'auto-container';
}
?>
<div class="<?php echo esc_attr($classes); ?>">
    <div class="row <?php echo esc_attr($dailyfit_sidebar['wrap_class']) ?>">
        <div id="exp-content-area" class="<?php echo esc_attr($dailyfit_sidebar['content_class']) ?>">
            <main id="exp-content-main">
                <?php while ( have_posts() ) {
                    the_post();
                    get_template_part( 'template-parts/content/content', 'page' );
                    if ( comments_open() || get_comments_number() ) {
                        comments_template();
                    }
                } ?>
            </main>
        </div>
        <?php if ($dailyfit_sidebar['sidebar_class']) : ?>
            <div id="exp-sidebar-area" class="<?php echo esc_attr($dailyfit_sidebar['sidebar_class']) ?>">
                <div class="exp-sidebar-sticky sidebar">
                    <?php dynamic_sidebar( 'sidebar-page' ); ?>
                </div>
            </div>
        <?php endif; ?>

    </div>
</div>
<?php get_footer();