<?php
/**
 * Helper functions for the theme
 *
 * @package Expert Themes
 */
  

function dailyfit_html($html){
    return $html;
}

if (! function_exists('dailyfit_set')) {
    function dailyfit_set($var, $key, $def = '')
    {
        //if( ! $var ) return false;

        if (is_object($var) && isset($var->$key)) {
            return $var->$key;
        } elseif (is_array($var) && isset($var[ $key ])) {
            return $var[ $key ];
        } elseif ($def) {
            return $def;
        } else {
            return false;
        }
    }
}


if( ! function_exists('dailyfit_go_to_top') ) {
    function dailyfit_go_to_top(){
        $back_to_top_icon = dailyfit()->get_theme_opt( 'back_top_icon', false );
        $go_to_top = '';
        if( $back_to_top_icon ) {
            $go_to_top = '<a class="exp-scroll-top" href="#"><i class="'. $back_to_top_icon .'"></i><svg class="exp-scroll-progress-circle" width="100%" height="100%" viewBox="-1 -1 102 102"><path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"/></svg></a>';
        } else {
            $go_to_top = '<a class="exp-scroll-top" href="#"><i class="fa fa-arrow-up"></i><svg class="exp-scroll-progress-circle" width="100%" height="100%" viewBox="-1 -1 102 102"><path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"/></svg></a>';
        }
        return $go_to_top; 
    }
}

/**
 * Google Fonts
*/
function dailyfit_fonts_url() {
    $fonts_url = '';
    $fonts     = array();
    $subsets   = 'latin,latin-ext';

    if ( 'off' !== _x( 'on', 'Archivo font: on or off', 'dailyfit' ) ) {
        $fonts[] = 'Archivo:ital,wght@0,100..900;1,100..900&display=swap';
    }

    if ( 'off' !== _x( 'on', 'Raleway font: on or off', 'dailyfit' ) ) {
        $fonts[] = 'Raleway:ital,wght@0,100..900;1,100..900&display=swap';
    }

    if ( $fonts ) {
        $fonts_url = add_query_arg( array(
            'family' => implode( '&family=', $fonts ),
            'subset' => urlencode( $subsets ),
        ), '//fonts.googleapis.com/css2' );
    }
    return $fonts_url;
}

/*
 * Get page ID by Slug
*/
function dailyfit_get_id_by_slug($slug, $post_type){
    $content = get_page_by_path($slug, OBJECT, $post_type);
    $id = $content->ID;
    return $id;
}

/**
 * Show content by slug
 **/
function dailyfit_content_by_slug($slug, $post_type){
    $content = dailyfit_get_content_by_slug($slug, $post_type);

    $id = dailyfit_get_id_by_slug($slug, $post_type);
    echo apply_filters('the_content',  $content);
}

/**
 * Get content by slug
 **/
function dailyfit_get_content_by_slug($slug, $post_type){
    $content = get_posts(
        array(
            'name'      => $slug,
            'post_type' => $post_type
        )
    );
    if(!empty($content))
        return $content[0]->post_content;
    else
        return;
}

 
/**
 * Custom Comment List
 */
function dailyfit_comment_list( $comment, $args, $depth ) {
	if ( 'div' === $args['style'] ) {
        $tag       = 'div';
        $add_below = 'comment';
    } else {
        $tag       = 'li';
        $add_below = 'div-comment';
    }
	?>
    <<?php echo ''.$tag ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
    <?php if ( 'div' != $args['style'] ) : ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment-body">
		<?php endif; ?>
		    <div class="comment-inner">
		        <?php if ($args['avatar_size'] != 0) echo get_avatar($comment, 90); ?>
		        <div class="comment-content">
		            <h4 class="comment-title">
		            	<?php printf( '%s', get_comment_author_link() ); ?>
		            </h4>
		            <div class="comment-meta">
		            	<span class="comment-date">
	                        <?php echo get_comment_date().' - '.get_comment_time(); ?>
	                    </span>
		            </div>
		            <div class="comment-text"><?php comment_text(); ?></div>
		            <div class="comment-reply">
						<?php comment_reply_link( array_merge( $args, array(
							'add_below' => $add_below,
							'depth'     => $depth,
							'max_depth' => $args['max_depth']
						) ) ); ?>
		            </div>
		        </div>
		    </div>
		<?php if ( 'div' != $args['style'] ) : ?>
        </div>
	<?php endif;
}

/**
 * Paginate Links
 */
function dailyfit_ajax_paginate_links($link){
    $parts = parse_url($link);
    if( !isset($parts['query']) ) return $link;
    parse_str($parts['query'], $query);
    if(isset($query['page']) && !empty($query['page'])){
        return '#' . $query['page'];
    }
    else{
        return '#1';
    }
}


/**
 * RGB Color
 */
function dailyfit_hex_rgb($color) {
 
    $default = '0,0,0';
 
    //Return default if no color provided
    if(empty($color))
        return $default; 
 
    //Sanitize $color if "#" is provided 
    if ($color[0] == '#' ) {
        $color = substr( $color, 1 );
    }

    //Check if color has 6 or 3 characters and get values
    if (strlen($color) == 6) {
        $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
    } elseif ( strlen( $color ) == 3 ) {
        $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
    } else {
        return $default;
    }

    //Convert hexadec to rgb
    $rgb =  array_map('hexdec', $hex);

    $output = implode(",",$rgb);

    //Return rgb(a) color string
    return $output;
}


/**
 * Image Size Crop
 */
if(!function_exists('dailyfit_get_image_by_size')){
    function dailyfit_get_image_by_size( $params = array() ) {
        $params = array_merge( array(
            'post_id' => null,
            'attach_id' => null,
            'thumb_size' => 'thumbnail',
            'class' => '',
        ), $params );

        if ( ! $params['thumb_size'] ) {
            $params['thumb_size'] = 'thumbnail';
        }

        if ( ! $params['attach_id'] && ! $params['post_id'] ) {
            return false;
        }

        $post_id = $params['post_id'];

        $attach_id = $post_id ? get_post_thumbnail_id( $post_id ) : $params['attach_id'];
        $attach_id = apply_filters( 'exp_object_id', $attach_id );
        $thumb_size = $params['thumb_size'];
        $thumb_class = ( isset( $params['class'] ) && '' !== $params['class'] ) ? $params['class'] . ' ' : '';

        global $_wp_additional_image_sizes;
        $thumbnail = '';

        $sizes = array(
            'thumbnail',
            'thumb',
            'medium',
            'medium_large',
            'large',
            'full',
        );
        if ( is_string( $thumb_size ) && ( ( ! empty( $_wp_additional_image_sizes[ $thumb_size ] ) && is_array( $_wp_additional_image_sizes[ $thumb_size ] ) ) || in_array( $thumb_size, $sizes, true ) ) ) {
            $attributes = array( 'class' => $thumb_class . 'attachment-' . $thumb_size );
            $thumbnail = wp_get_attachment_image( $attach_id, $thumb_size, false, $attributes );
            $thumbnail_url = wp_get_attachment_image_url($attach_id, $thumb_size, false);
        } elseif ( $attach_id ) {
            if ( is_string( $thumb_size ) ) {
                preg_match_all( '/\d+/', $thumb_size, $thumb_matches );
                if ( isset( $thumb_matches[0] ) ) {
                    $thumb_size = array();
                    $count = count( $thumb_matches[0] );
                    if ( $count > 1 ) {
                        $thumb_size[] = $thumb_matches[0][0]; // width
                        $thumb_size[] = $thumb_matches[0][1]; // height
                    } elseif ( 1 === $count ) {
                        $thumb_size[] = $thumb_matches[0][0]; // width
                        $thumb_size[] = $thumb_matches[0][0]; // height
                    } else {
                        $thumb_size = false;
                    }
                }
            }
            if ( is_array( $thumb_size ) ) {
                // Resize image to custom size
                $p_img = exp_resize( $attach_id, null, $thumb_size[0], $thumb_size[1], true );
                $alt = trim( wp_strip_all_tags( get_post_meta( $attach_id, '_wp_attachment_image_alt', true ) ) );
                $attachment = get_post( $attach_id );
                if ( ! empty( $attachment ) ) {
                    $title = trim( wp_strip_all_tags( $attachment->post_title ) );

                    if ( empty( $alt ) ) {
                        $alt = trim( wp_strip_all_tags( $attachment->post_excerpt ) ); // If not, Use the Caption
                    }
                    if ( empty( $alt ) ) {
                        $alt = $title;
                    }
                    if ( $p_img ) {

                        $attributes = exp_stringify_attributes( array(
                            'class' => $thumb_class,
                            'src' => $p_img['url'],
                            'width' => $p_img['width'],
                            'height' => $p_img['height'],
                            'alt' => $alt,
                            'title' => $title,
                        ) );

                        $thumbnail = '<img ' . $attributes . ' />';
                    }
                }
            }
            $thumbnail_url = $p_img['url'];
        }

        $p_img_large = wp_get_attachment_image_src( $attach_id, 'large' );

        return apply_filters( 'exp_el_getimagesize', array(
            'thumbnail' => $thumbnail,
            'url' => $thumbnail_url,
            'p_img_large' => $p_img_large,
        ), $attach_id, $params );

    }
}

/**
 * Search Form
 */
function dailyfit_header_mobile_search_form() { 
    $search_mobile = dailyfit()->get_theme_opt( 'search_mobile', false );
    if($search_mobile) : ?>
    <div class="exp-header-mobile-search exp-hide-xl">
        <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
            <input type="text" placeholder="<?php esc_attr_e('Search...', 'dailyfit'); ?>" name="s" class="search-field" />
            <button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
        </form>
    </div>
<?php endif; }

/**
 * Year Shortcode [exp_year]
 */
if(function_exists( 'exp_register_shortcode' )) {
    function dailyfit_year_shortcode() {
        ob_start(); ?>
            <span><?php the_date('Y'); ?></span>
        <?php $output = ob_get_clean();
        return $output;
    }
    exp_register_shortcode('exp_year', 'dailyfit_year_shortcode');
}

/* Highlight Shortcode  */
if(function_exists( 'exp_register_shortcode' )) {
    function dailyfit_text_highlight_shortcode( $atts = array() ) {
        extract(shortcode_atts(array(
         'text' => '',
        ), $atts));

        ob_start();
        if(!empty($text)) : 
            $arr_str = explode(',', $text);
            ?>
            <span class="exp-title--highlight">
                <?php foreach ($arr_str as $index => $value) {
                    $item_count = '';
                    if($index == 0) {
                        $item_count = 'active';
                    }
                    $arr_str[$index] = '<span class="exp-item--text '.$item_count.'">' . $value . '</span>';
                }
                $str = implode(' ', $arr_str);
                echo wp_kses_post($str); ?>
            </span>
        <?php  endif;
        $output = ob_get_clean();

        return $output;
    }
    exp_register_shortcode('highlight', 'dailyfit_text_highlight_shortcode');
}

if(function_exists( 'exp_register_shortcode' )) {
    function dailyfit_text_highlight_shortcode_editor( $atts = array() ) {
        extract(shortcode_atts(array(
         'text' => '',
        ), $atts));

        ob_start();
        if(!empty($text)) : ?>
            <span class="exp-text--highlight">
                <?php echo esc_attr($text); ?>
            </span>
        <?php  endif;
        $output = ob_get_clean();

        return $output;
    }
    exp_register_shortcode('exp_highlight', 'dailyfit_text_highlight_shortcode_editor');
}

/* Typewriter Shortcode  */
if(function_exists( 'exp_register_shortcode' )) {
    function dailyfit_text_typewriter_shortcode( $atts = array() ) {
        extract(shortcode_atts(array(
         'text' => '',
        ), $atts));

        ob_start();
        if(!empty($text)) : 
            $arr_str = explode(',', $text);
            ?>
            <span class="exp-title--typewriter">
                <?php foreach ($arr_str as $index => $value) {
                    $item_count = '';
                    if($index == 0) {
                        $item_count = 'is-active';
                    }
                    $arr_str[$index] = '<span class="exp-item--text '.$item_count.'">' . $value . '</span>';
                }
                $str = implode(' ', $arr_str);
                echo wp_kses_post($str); ?>
            </span>
        <?php  endif;
        $output = ob_get_clean();

        return $output;
    }
    exp_register_shortcode('typewriter', 'dailyfit_text_typewriter_shortcode');
}

/* Button Shortcode  */
if(function_exists( 'exp_register_shortcode' )) {
    function dailyfit_btn_shortcode( $atts = array() ) {
        extract(shortcode_atts(array(
         'text' => '',
         'style' => 'btn-slider1',
         'icon_class' => '',
         'link' => '',
         'text_color' => '',
        ), $atts));

        ob_start();
        if(!empty($text)) : ?>
            <?php if(!empty($link)) : ?><a class="sc-button-wrap" href="<?php echo esc_url($link); ?>"><?php endif; ?>
                <span class="btn <?php echo esc_attr($style); ?> <?php if($style == 'btn-slider1') { echo 'btn-nina'; } ?> <?php if($style == 'btn-slider4') { echo 'btn-nanuk'; } ?>" <?php if(!empty($text_color)) { ?>style="color: <?php echo esc_attr($text_color); ?>"<?php } ?>>
                    <?php if($style == 'btn-slider1' || $style == 'btn-slider4') { ?>
                        <span class="exp--btn-text" data-text="<?php echo esc_attr($text); ?>">
                            <?php $chars = str_split($text);
                            foreach ($chars as $value) {
                                if($value == ' ') {
                                    echo '<span class="spacer">&nbsp;</span>';
                                } else {
                                    echo '<span>'.esc_attr($value).'</span>';
                                }
                            } ?>
                        </span>
                    <?php } else {
                        echo '<span>'.esc_attr($text).'</span>';
                    } ?>
                    <?php if(!empty($icon_class)) : ?>
                        <i class="<?php echo esc_attr($icon_class); ?>"></i>
                    <?php endif; ?>
                    <?php if($style == 'exp-btn-effect14') { ?>
                        <span class="exp-btn-divider exp-btn-divider1"></span>
                        <span class="exp-btn-divider exp-btn-divider2"></span>
                    <?php } ?>
                </span>
            <?php if(!empty($link)) : ?></a><?php endif; ?>
        <?php  endif;
        $output = ob_get_clean();

        return $output;
    }
    exp_register_shortcode('exp_button', 'dailyfit_btn_shortcode');
}

/* Gallery Shortcode  */
if(function_exists( 'exp_register_shortcode' )) {
    function dailyfit_gallery_shortcode( $atts = array() ) {
        extract(shortcode_atts(array(
         'link' => '#',
         'images_id' => '',
         'cols' => '2',
         'img_size' => 'full',
         'btn_video' => 'no',
         'masonry' => '',
        ), $atts));

        ob_start();
        ?>
        <div class="exp-gallery gallery-<?php echo esc_attr($cols); ?>-columns <?php if(!empty($masonry)) { echo 'masonry-'.esc_attr($masonry); } ?>">
        <?php
        $exp_images = explode( ',', $images_id );
        foreach ($exp_images as $key => $img_id) :
            $img = exp_get_image_by_size( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            $thumbnail_url = $img['url'];
            ?>
            <div class="exp--item">
                <div class="exp--item-inner <?php if($key == 1 && !empty($link) && $btn_video == 'yes' ) { echo 'video-active'; } ?>">
                    <a href="<?php echo esc_url($thumbnail_url); ?>"><?php echo dailyfit_html($thumbnail); ?></a>
                    <?php if($key == 1 && $btn_video == 'yes') : ?>
                        <a href="<?php echo esc_url($link); ?>" class="btn-video"><i class="fa fa-play"></i></a>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        endforeach;
        ?>
        </div>
        <?php
        $output = ob_get_clean();

        return $output;
    }
    exp_register_shortcode('exp_gallery', 'dailyfit_gallery_shortcode');
}

/* Addd shortcode Video button */
if(function_exists( 'exp_register_shortcode' )) {
    function dailyfit_video_button_shortcode( $atts = array() ) {
        extract(shortcode_atts(array(
         'link' => '',
         'text' => '',
         'class' => 'style1',
        ), $atts));

        ob_start();
        ?>
        <a href="<?php echo esc_url($link); ?>" class="exp-button-video1 btn-video exp-video-popup <?php echo esc_attr($class); ?>">
            <span>
                <i class="fa fa-play"></i>
            </span>
            <?php if(!empty($text)) : ?>
                <span class="slider-video-title"><?php echo esc_html($text); ?></span>
            <?php endif; ?>
        </a>
        <?php
        $output = ob_get_clean();

        return $output;
    }
    exp_register_shortcode('exp_video_button', 'dailyfit_video_button_shortcode');
}

/**
 * Custom Widget Categories - Count
 */
add_filter('wp_list_categories', 'dailyfit_wg_category_count');
function dailyfit_wg_category_count($output) {
    $dir = is_rtl() ? 'exp-left' : 'exp-right';
    $output = str_replace("\t", '', $output);
    $output = str_replace(")\n</li>", ')</li>', $output);
    $output = str_replace('</a> (', '<span class="exp-count '.$dir.'">', $output);
    $output = str_replace(")</li>", "</span></a></li>", $output);
    $output = str_replace("\n<ul", "</span></a>\n<ul", $output);
    return $output;
}


/**
 * Custom Widget Archive - Count
 */
add_filter('get_archives_link', 'dailyfit_wg_archive_count');
function dailyfit_wg_archive_count($links) {
    $dir = is_rtl() ? 'exp-left' : 'exp-right';
    $links = str_replace('</a>&nbsp;(', ' <span class="exp-count '.$dir.'">', $links);
    $links = str_replace(')', '</span></a>', $links);
    return $links;
}

/**
 * Custom Widget Product Categories 
 */
add_filter('wp_list_categories', 'dailyfit_wc_cat_count_span');
function dailyfit_wc_cat_count_span($links) {
    $dir = is_rtl() ? 'exp-left' : 'exp-right';
    $links = str_replace('</a> <span class="count">(', ' <span class="exp-count '.$dir.'">', $links);
    $links = str_replace(')</span>', '</span></a>', $links);
    return $links;
}

/**
 * Get mega menu builder ID
 */
function dailyfit_get_mega_menu_builder_id(){
    $mn_id = [];
    $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
    if ( is_array( $menus ) && ! empty( $menus ) ) {
        foreach ( $menus as $menu ) {
            if ( is_object( $menu )){
                $menu_obj = get_term( $menu->term_id, 'nav_menu' );
                $menu = wp_get_nav_menu_object( $menu_obj ) ;
                $menu_items = wp_get_nav_menu_items( $menu->term_id, array( 'update_post_term_cache' => false ) );
                foreach ($menu_items as $menu_item) {
                    if( !empty($menu_item->exp_megaprofile)){
                        $mn_id[] = (int)$menu_item->exp_megaprofile;
                    }
                }  
            }
        }
    }
    return $mn_id;
}

/**
 * Get page popup builder ID
 */
function dailyfit_get_page_popup_builder_id(){
    $pp_id = [];
    $page_popup = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
    if ( is_array( $page_popup ) && ! empty( $page_popup ) ) {
        foreach ( $page_popup as $page ) {
            if ( is_object( $page )){
                $page_obj = get_term( $page->term_id, 'nav_menu' );
                $page = wp_get_nav_menu_object( $page_obj ) ;
                $page_items = wp_get_nav_menu_items( $page->term_id, array( 'update_post_term_cache' => false ) );
                foreach ($page_items as $page_item) {
                    if( !empty($page_item->exp_page_popup)){
                        $pp_id[] = (int)$page_item->exp_page_popup;
                    }
                }  
            }
        }
    }
    return $pp_id;
}

/* Mouse Move Animation */
function dailyfit_mouse_move_animation() { 
    $mouse_move_animation = dailyfit()->get_theme_opt('show_mouse_cursor');
    $mouse_cursor_style = dailyfit()->get_theme_opt('mouse_cursor_style');
    if($mouse_move_animation == 'show') :
        wp_enqueue_script( 'dailyfit-cursor', get_template_directory_uri() . '/assets/admin/js/cursor.js', array( 'jquery' ), '1.0.0', true ); ?>  
        <?php if($mouse_cursor_style == 'one' ):
            wp_enqueue_script( 'dailyfit-mouse-cursor', get_template_directory_uri() . '/assets/admin/js/mouse-cursor.js', array( 'jquery' ), '1.0.0', true );
        ?>
        
        
        <div class="mouse-follower">
            <span class="cursor-outline"></span>
            <span class="cursor-dot"></span>
        </div>
        
        
        <?php else : ?>
        
        <div class="exp-cursor exp-js-cursor">
            <div class="exp-cursor-wrapper">
                <div class="exp-cursor--follower exp-js-follower"></div>
                <div class="exp-cursor--label exp-js-label"></div>
                <div class="exp-cursor--drap exp-js-drap"></div>
                <div class="exp-cursor--icon exp-js-icon"></div>
            </div>
        </div>
        
    <?php  endif; endif;
}


function dailyfit_logo($logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography, $logo_title, $logo_color)
{
    if ($logo_type === 'text') {
        $logo       = $logo_text ? $logo_text : '<span>' . esc_html__('DAILYFIT', 'dailyfit') . '</span>';
        $logo_style = $logo_typography;
        $logo_the_style  = (dailyfit_set($logo_style, 'font-size')) ? 'font-size:' . dailyfit_set($logo_style, 'font-size') . ';' : '';
        $logo_the_style  .= (dailyfit_set($logo_style, 'font-family')) ? "font-family:'" . dailyfit_set($logo_style, 'font-family') . "';" : '';
        $logo_the_style  .= (dailyfit_set($logo_style, 'font-weight')) ? 'font-weight:' . dailyfit_set($logo_style, 'font-weight') . ';' : '';
        $logo_the_style  .= (dailyfit_set($logo_style, 'line-height')) ? 'line-height:' . dailyfit_set($logo_style, 'line-height') . ';' : '';
        $logo_the_style  .= (dailyfit_set($logo_style, 'color')) ? 'color:' . dailyfit_set($logo_style, 'color') . ';' : '';
        $logo_the_style  .= (dailyfit_set($logo_style, 'letter-spacing')) ? 'letter-spacing:' . dailyfit_set($logo_style, 'letter-spacing') . ';' : '';
        $logo_output       = '<a style="' . $logo_the_style . '" href="' . home_url('/') . '" title="' . $logo_title . '">' . wp_kses($logo, true) . '</a>';
    } else {
        $logo_the_style      = '';
        $logo_image_style = '';
        $logo_image_style .= dailyfit_set($logo_dimension, 'width') ? ' width:' . dailyfit_set($logo_dimension, 'width') . ';' : '';
        $logo_image_style .= dailyfit_set($logo_dimension, 'height') ? ' height:' . (dailyfit_set($logo_dimension, 'height')) . ';' : '';
        if (dailyfit_set($image_logo, 'url')) {
            $logo_output = '<a href="' . home_url('/') . '" title="' . $logo_title . '"><img src="' . esc_url(dailyfit_set($image_logo, 'url')) . '" alt="'.esc_attr__('logo', 'dailyfit').'" style="' . $logo_image_style . '" /></a>';
        } else {
            
			if($logo_color == 'light'){
                $logo_output = '<a href="' . esc_url(home_url('/')) . '" title="' . $logo_title . '"><img src="' . get_template_directory_uri() . '/assets/images/logo.svg' . '" alt="'.esc_attr__('logo', 'dailyfit').'" style="' . $logo_image_style . '" /></a>';
            } else{
                $logo_output = '<a href="' . esc_url(home_url('/')) . '" title="' . $logo_title . '"><img src="' . get_template_directory_uri() . '/assets/images/dark-logo.svg' . '" alt="'.esc_attr__('logo', 'dailyfit').'" style="' . $logo_image_style . '" /></a>';
            }
        }
    }

    return $logo_output;
}




/**
 * Start - User custom fields.
 */
add_action( 'show_user_profile', 'dailyfit_user_fields' );
add_action( 'edit_user_profile', 'dailyfit_user_fields' );
function dailyfit_user_fields($user){

    $user_position = get_user_meta($user->ID, 'user_position', true);

    ?>
    <h3><?php esc_html_e('Theme Custom', 'dailyfit'); ?></h3>
    <table class="form-table">
        <tr>
            <th><label for="user_position"><?php esc_html_e('Position', 'dailyfit'); ?></label></th>
            <td>
                <input id="user_position" name="user_position" type="text" value="<?php echo esc_attr(isset($user_position) ? $user_position : ''); ?>" />
            </td>
        </tr>
    </table>
    <?php
}

add_action( 'personal_options_update', 'dailyfit_save_user_custom_fields' );
add_action( 'edit_user_profile_update', 'dailyfit_save_user_custom_fields' );
function dailyfit_save_user_custom_fields( $user_id )
{
    if ( !current_user_can( 'edit_user', $user_id ) )
        return false;

    if(isset($_POST['user_position']))
        update_user_meta( $user_id, 'user_position', $_POST['user_position'] );
}

function dailyfit_get_user_theme() {

    $user_position = get_user_meta(get_the_author_meta( 'ID' ), 'user_position', true);
    if(!empty($user_position)) { ?>
        <div class="exp-user--position">
            <?php echo esc_attr($user_position); ?>
        </div>
    <?php }
}
/**
 * End - User custom fields.
 */


/**
 * Start - Cookie Policy
 */
function dailyfit_cookie_policy() {
    $cookie_policy = dailyfit()->get_theme_opt('cookie_policy', 'hide');
    $cookie_policy_description = dailyfit()->get_theme_opt('cookie_policy_description');
    $cookie_policy_btntext = dailyfit()->get_theme_opt('cookie_policy_btntext');
    $cookie_policy_link = get_permalink(dailyfit()->get_theme_opt('cookie_policy_link')); 
    wp_enqueue_script('exp-cookie'); ?>
    <?php if($cookie_policy == 'show' && !empty($cookie_policy_description)) : ?>
        <div class="exp-cookie-policy">
            <div class="exp-item--icon exp-mr-8"><img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/cookie.png'); ?>" alt="<?php echo esc_attr($cookie_policy_btntext); ?>" /></div>
            <div class="exp-item--description">
                <?php echo esc_attr($cookie_policy_description); ?>
                <a class="exp-item--link" href="<?php echo esc_url( $cookie_policy_link ); ?>" target="_blank"><?php echo esc_html($cookie_policy_btntext); ?></a>
            </div>
            <div class="exp-item--close exp-close"></div>
        </div>
    <?php endif; ?>
<?php }   
/**
 * End - Cookie Policy
 */

/**
 * Start - Subscribe Popup
 */
function dailyfit_subscribe_popup() {
    $subscribe = dailyfit()->get_theme_opt('subscribe', 'hide');
    $subscribe_layout = dailyfit()->get_theme_opt('subscribe_layout');
    $popup_effect = dailyfit()->get_theme_opt('popup_effect', 'fade');
    $args = [
        'subscribe_layout' => $subscribe_layout
    ];
    wp_enqueue_script('exp-cookie'); ?>
    <?php if($subscribe == 'show' && isset($args['subscribe_layout']) && $args['subscribe_layout'] > 0) : ?>
        <div class="exp-popup exp-subscribe-popup exp-effect-<?php echo esc_attr($popup_effect); ?>">
            <div class="exp-popup--content">
                <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $args['subscribe_layout']); ?>
            </div>
        </div>
    <?php endif; ?>
<?php }   
/**
 * End - Subscribe Popup
 */

/**
 * Start - Page Popup
 */
function dailyfit_page_popup() {
    $post_list = array();
    $args = array(
        'post_type' => 'exp-template',
        'posts_per_page' => '-1',
        'orderby' => 'date',
        'order' => 'ASC',
        'meta_query' => array(
            array(
                'key'       => 'template_type',
                'value'     => 'page',
                'compare'   => '='
            )
        )
    );
    $posts = get_posts($args); ?>
    <div id="exp-page-popup" class="">
        <div class="exp-popup-overlay"></div>
        <div class="exp-page-popup-content">
            <?php foreach($posts as $post){ ?>
                <div id="exp-page-popup-<?php echo esc_attr($post->ID); ?>" class="exp-page-item">
                    <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display($post->ID); ?>
                </div>
            <?php } ?>
        </div>
    </div>
<?php }   
/**
 * End - Page Popup
 */
 
 
 
/**
 * Start - Page Loader
 */
function dailyfit_display_loader() {
    $options = dailyfit()->get_theme_opt();
    if($options->get('loader_switch') == 'image' || $options->get('loader_switch') == 'text' || $options->get('loader_switch') == 'prebuild'){
        if($options->get('loader_switch') == 'image') { ?>
            <div id="dailyfit-loading">
                    <div id="dailyfit-loading-center">
                      
                        <img src="<?php echo esc_url($background_loader); ?>" alt="<?php esc_attr_e('loading','dailyfit'); ?>">
                        
                    </div>
                </div>
        <?php } 
        else if($options->get('loader_switch') == 'text'){
        if($options->get('loader_text')){
                $tag = $options->get('loader_tag');
            ?>
 
                <div id="dailyfit-loading">
                    <div id="dailyfit-loading-center">
                      
                        <<?php echo esc_html($tag); ?> class="dailyfit-loader-text"><?php echo esc_html($options->get('loader_text')) ?></<?php echo esc_html($tag); ?>>
                        
                    </div>
                </div>
    <?php }
    }

    else if($options->get('loader_switch') == 'prebuild') {
        $loader_style = $options->get('loading_type');
    ?>
    <div id="ct-loadding" class="ct-loader <?php echo esc_attr($loader_style); ?>">
    <?php
        switch($loader_style){
            case 's1':  ?>
                <div class="ct-spinner2"></div>
                <?php break;
            case 's2': ?>
                <div class="ct-spinner3">
                  <div class="double-bounce1"></div>
                  <div class="double-bounce2"></div>
                </div>
                <?php break;
            case 's3': ?>
                <div class="ct-spinner4">
                  <div class="rect1"></div>
                  <div class="rect2"></div>
                  <div class="rect3"></div>
                  <div class="rect4"></div>
                  <div class="rect5"></div>
                </div>
                <?php break;
            case 's4': ?>
                <div class="ct-spinner5">
                  <div class="bounce1"></div>
                  <div class="bounce2"></div>
                  <div class="bounce3"></div>
                </div>
                <?php break;
            case 's5': ?>
                <div class="ct-cube-grid">
                  <div class="ct-cube ct-cube1"></div>
                  <div class="ct-cube ct-cube2"></div>
                  <div class="ct-cube ct-cube3"></div>
                  <div class="ct-cube ct-cube4"></div>
                  <div class="ct-cube ct-cube5"></div>
                  <div class="ct-cube ct-cube6"></div>
                  <div class="ct-cube ct-cube7"></div>
                  <div class="ct-cube ct-cube8"></div>
                  <div class="ct-cube ct-cube9"></div>
                </div>
                <?php break;
            case 's6': ?>
                <div class="ct-folding-cube">
                  <div class="ct-cube1 ct-cube"></div>
                  <div class="ct-cube2 ct-cube"></div>
                  <div class="ct-cube4 ct-cube"></div>
                  <div class="ct-cube3 ct-cube"></div>
                </div>
                <?php break;
            case 's7': ?>
                <div class="ct-loading-stairs">
                    <div class="loader-bar"></div>
                    <div class="loader-bar"></div>
                    <div class="loader-bar"></div>
                    <div class="loader-bar"></div>
                    <div class="loader-bar"></div>
                    <div class="loader-ball"></div>
                </div>
                <?php break;

            case 's8': ?>
                <div class="ct-dual-ring">
                </div>
                <?php break;

            case 's9': ?>
                <div class="ct-dot-square">
                </div>
                <?php break;

            case 's10': ?>
                <div class="loading-spinner">
                </div>
                <?php break;

            case 's11': ?>
                <div class="loading-ring">
                </div>
                <?php break;

            case 's12': ?>
                <div class="loading-infinity">
                    <div>
                        <span></span>
                    </div>
                    <div>
                        <span></span>
                    </div>
                    <div>
                        <span></span>
                    </div>
                </div>
                <?php break;

            default: ?>
                <div class="loading-spin">
                    <div class="spinner">
                        <div class="right-side"><div class="bar"></div></div>
                        <div class="left-side"><div class="bar"></div></div>
                    </div>
                    <div class="spinner color-2">
                        <div class="right-side"><div class="bar"></div></div>
                        <div class="left-side"><div class="bar"></div></div>
                    </div>
                </div>
                <?php break;
        }

        ?>
    </div>
        <?php
    }





    } else { ?>
        <div class="dailyfit-loading display-none"></div>
    <?php }
}
/**
 * End - Page Loader
 */