<?php
/**
 * Filters hook for the theme
 *
 * @package Expert Themes
 */

/* Custom Classs - Body */
function dailyfit_body_classes( $classes ) {   

	$classes[] = '';
    if (class_exists('ReduxFramework')) {
        $classes[] = ' exp-redux-page';

	    $footer_fixed = dailyfit()->get_theme_opt('footer_fixed');
	    $p_footer_fixed = dailyfit()->get_page_opt('p_footer_fixed');

	    if($p_footer_fixed != false && $p_footer_fixed != 'inherit') {
	    	$footer_fixed = $p_footer_fixed;
	    }

	    if(isset($footer_fixed) && $footer_fixed == 'on') {
	        $classes[] = ' exp-footer-fixed';
	    }

	    $exp_body_typography = dailyfit()->get_theme_opt('exp_body_typography');
	    if($exp_body_typography != 'google-font') {
	        $classes[] = ' body-'.$exp_body_typography.' ';
	    }

	    $exp_heading_typography = dailyfit()->get_theme_opt('exp_heading_typography');
	    if($exp_heading_typography != 'google-font') {
	        $classes[] = ' heading-'.$exp_heading_typography.' ';
	    }

	    $theme_default = dailyfit()->get_theme_opt('theme_default');
	    if(isset($theme_default['font-family']) && $theme_default['font-family'] == false && $exp_body_typography == 'google-font') {
	        $classes[] = ' exp-font-default';
	    }

	    $header_layout = dailyfit()->get_opt('header_layout');
	    if(isset($header_layout) && $header_layout) {
		    $post_header = get_post($header_layout);
		    $header_type = get_post_meta( $post_header->ID, 'header_type', true );
		    if(isset($header_type)) {
		    	$classes[] = ' bd-'.$header_type.'';
		    }
		}

		$shop_layout = dailyfit()->get_theme_opt('shop_layout', 'grid');
		if(isset($_GET['shop-layout'])) {
	        $shop_layout = $_GET['shop-layout'];
	    }
		$classes[] = ' woocommerce-layout-'.$shop_layout;

		$body_custom_class = dailyfit()->get_page_opt('body_custom_class');
		if(!empty($body_custom_class)) {
			$classes[] = $body_custom_class;
		}
    }
    return $classes;
}
add_filter( 'body_class', 'dailyfit_body_classes' );

/* Post Type Support */
function dailyfit_add_cpt_support() {
    $cpt_support = get_option( 'elementor_cpt_support' );
    
    if( ! $cpt_support ) {
        $cpt_support = [ 'page', 'post', 'portfolio', 'service', 'team', 'event', 'footer', 'exp-template' ];
        update_option( 'elementor_cpt_support', $cpt_support );
    }
    
    else if( ! in_array( 'portfolio', $cpt_support ) ) {
        $cpt_support[] = 'portfolio';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    else if( ! in_array( 'service', $cpt_support ) ) {
        $cpt_support[] = 'service';
        update_option( 'elementor_cpt_support', $cpt_support );
    }
    
     else if( ! in_array( 'team', $cpt_support ) ) {
        $cpt_support[] = 'team';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    else if( ! in_array( 'footer', $cpt_support ) ) {
        $cpt_support[] = 'footer';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

    else if( ! in_array( 'exp-template', $cpt_support ) ) {
        $cpt_support[] = 'exp-template';
        update_option( 'elementor_cpt_support', $cpt_support );
    }

}
add_action( 'after_switch_theme', 'dailyfit_add_cpt_support');

add_filter( 'exp_support_default_cpt', 'dailyfit_support_default_cpt' );
function dailyfit_support_default_cpt($postypes){
	return $postypes; // exp-template
}

add_filter( 'exp_extra_post_types', 'dailyfit_add_post_type' );
function dailyfit_add_post_type( $postypes ) {
	$portfolio_display = dailyfit()->get_theme_opt('portfolio_display', true);
	$portfolio_slug = dailyfit()->get_theme_opt('portfolio_slug', 'portfolio');
	$portfolio_name = dailyfit()->get_theme_opt('portfolio_name', 'Portfolio');
	$service_display = dailyfit()->get_theme_opt('service_display', true);
	$service_slug = dailyfit()->get_theme_opt('service_slug', 'service');
	$service_name = dailyfit()->get_theme_opt('service_name', 'Services');
	$team_display = dailyfit()->get_theme_opt('team_display1', true);
	$team_slug = dailyfit()->get_theme_opt('team_slug', 'team');
	$team_name = dailyfit()->get_theme_opt('team_name', 'Team');
	
	if($portfolio_display) {
		$portfolio_status = true;
	} else {
		$portfolio_status = false;
	}
	if($service_display) {
		$service_status = true;
	} else {
		$service_status = false;
	}
	if($team_display) {
		$team_status = true;
	} else {
		$team_status = false;
	}

	$postypes['portfolio'] = array(
		'status' => $portfolio_status,
		'item_name'  => $portfolio_name,
		'items_name' => $portfolio_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $portfolio_slug,
 		 	),
		),
	);

	$postypes['service'] = array(
		'status' => $service_status,
		'item_name'  => $service_name,
		'items_name' => $service_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $service_slug,
 		 	),
		),
	);
	
	$postypes['team'] = array(
		'status' => $team_status,
		'item_name'  => $team_name,
		'items_name' => $team_name,
		'args'       => array(
			'rewrite'             => array(
                'slug'       => $team_slug,
 		 	),
		),
	);
  
	return $postypes;
}

/* Custom Archive Post Type Link */
function dailyfit_custom_archive_service_link() {
    if( is_post_type_archive( 'service' ) ) {
    	$archive_service_link = dailyfit()->get_theme_opt('archive_service_link');
        wp_redirect( get_permalink($archive_service_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'dailyfit_custom_archive_service_link' );

function dailyfit_custom_archive_portfolio_link() {
    if( is_post_type_archive( 'portfolio' ) ) {
        $archive_portfolio_link = dailyfit()->get_theme_opt('archive_portfolio_link');
        wp_redirect( get_permalink($archive_portfolio_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'dailyfit_custom_archive_portfolio_link' );

function dailyfit_custom_archive_team_link() {
    if( is_post_type_archive( 'team' ) ) {
        $archive_team_link = dailyfit()->get_theme_opt('archive_team_link');
        wp_redirect( get_permalink($archive_team_link), 301 );
        exit();
    }
}
add_action( 'template_redirect', 'dailyfit_custom_archive_team_link' );

add_filter( 'exp_extra_taxonomies', 'dailyfit_add_tax' );
function dailyfit_add_tax( $taxonomies ) {

	$taxonomies['portfolio-category'] = array(
		'status'     => true,
		'post_type'  => array( 'portfolio' ),
		'taxonomy'   => 'Portfolio Categories',
		'taxonomies' => 'Portfolio Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'portfolio-category'
 		 	),
		),
		'labels'     => array()
	);

	$taxonomies['service-category'] = array(
		'status'     => true,
		'post_type'  => array( 'service' ),
		'taxonomy'   => 'Service Categories',
		'taxonomies' => 'Service Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'service-category'
 		 	),
		),
		'labels'     => array()
	);
	
	$taxonomies['team-category'] = array(
		'status'     => true,
		'post_type'  => array( 'team' ),
		'taxonomy'   => 'Team Categories',
		'taxonomies' => 'Team Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'team-category'
 		 	),
		),
		'labels'     => array()
	);
	
	return $taxonomies;
}

add_filter( 'exp_theme_builder_post_types', 'dailyfit_theme_builder_post_type' );
function dailyfit_theme_builder_post_type($postypes){
	//default are header, footer, mega-menu
	return $postypes;
}

add_filter( 'exp_theme_builder_layout_ids', 'dailyfit_theme_builder_layout_id' );
function dailyfit_theme_builder_layout_id($layout_ids){
	//default [], 
	$header_layout        = (int)dailyfit()->get_opt('header_layout');
	$header_sticky_layout = (int)dailyfit()->get_opt('header_sticky_layout');
	$footer_layout        = (int)dailyfit()->get_opt('footer_layout');
	$ptitle_layout        = (int)dailyfit()->get_opt('ptitle_layout');
	if( $header_layout > 0) 
		$layout_ids[] = $header_layout;
	if( $header_sticky_layout > 0) 
		$layout_ids[] = $header_sticky_layout;
	if( $footer_layout > 0) 
		$layout_ids[] = $footer_layout;
	if( $ptitle_layout > 0) 
		$layout_ids[] = $ptitle_layout;
	
	$mega_menu_id = dailyfit_get_mega_menu_builder_id();
	if(!empty($mega_menu_id))
		$layout_ids = array_merge($layout_ids, $mega_menu_id);

	$page_popup_id = dailyfit_get_page_popup_builder_id();
	if(!empty($page_popup_id))
		$layout_ids = array_merge($layout_ids, $page_popup_id);

	return $layout_ids;
}

add_filter( 'exp_wg_get_source_id_builder', 'dailyfit_wg_get_source_builder' );
function dailyfit_wg_get_source_builder($wg_datas){
  $wg_datas['tabs'] = ['control_name' => 'tabs', 'source_name' => 'content_template'];
  return $wg_datas;
}

/* Update primary color in Editor Builder */
add_action( 'elementor/preview/enqueue_styles', 'dailyfit_add_editor_preview_style' );
function dailyfit_add_editor_preview_style(){
    wp_add_inline_style( 'editor-preview', dailyfit_editor_preview_inline_styles() );
}
function dailyfit_editor_preview_inline_styles(){
    $theme_colors = dailyfit_configs('theme_colors');
    ob_start();
        echo '.elementor-edit-area-active{';
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
        echo '}';
    return ob_get_clean();
}
 
add_filter( 'get_the_archive_title', 'dailyfit_archive_title_remove_label' );
function dailyfit_archive_title_remove_label( $title ) {
	if ( is_category() ) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( is_author() ) {
		$title = get_the_author();
	} elseif ( is_post_type_archive() ) {
		$title = post_type_archive_title( '', false );
	} elseif ( is_tax() ) {
		$title = single_term_title( '', false );
	} elseif ( is_home() ) {
		$title = single_post_title( '', false );
	}

	return $title;
}

add_filter( 'comment_reply_link', 'dailyfit_comment_reply_text' );
function dailyfit_comment_reply_text( $link ) {
	$link = str_replace( 'Reply', ''.esc_attr__('Reply', 'dailyfit').'', $link );
	return $link;
}
add_filter( 'exp_enable_pagepopup', 'dailyfit_enable_pagepopup' );
function dailyfit_enable_pagepopup() {
	return true;
}
add_filter( 'exp_enable_megamenu', 'dailyfit_enable_megamenu' );
function dailyfit_enable_megamenu() {
	return true;
}
add_filter( 'exp_enable_onepage', 'dailyfit_enable_onepage' );
function dailyfit_enable_onepage() {
	return true;
}

add_filter( 'exp_support_awesome_pro', 'dailyfit_support_awesome_pro' );
function dailyfit_support_awesome_pro() {
	return true;
}
 
add_filter( 'redux_exp_iconpicker_field/get_icons', 'dailyfit_add_icons_to_exp_iconpicker_field' );
function dailyfit_add_icons_to_exp_iconpicker_field($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}


add_filter("exp_mega_menu/get_icons", "dailyfit_add_icons_to_megamenu");
function dailyfit_add_icons_to_megamenu($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}
 

/**
 * Move comment field to bottom
 */
add_filter( 'comment_form_fields', 'dailyfit_comment_field_to_bottom' );
function dailyfit_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}


/* ------Disable Lazy loading---- */
add_filter( 'wp_lazy_loading_enabled', '__return_false' );

/* ------ Export Settings ---- */
add_filter( 'exp_export_wp_settings', 'dailyfit_export_wp_settings' );
function dailyfit_export_wp_settings($wp_options){
  $wp_options[] = 'mc4wp_default_form_id';
  return $wp_options;
}

/* ------ Theme Info ---- */
add_filter( 'exp_server_info', 'dailyfit_add_server_info');
function dailyfit_add_server_info($infos){
  $infos = [
    'api_url' => 'https://api.expert-themes.com/',
    'docs_url' => 'https://expert-themes.com/documentation/dailyfit',
    'plugin_url' => 'https://api.expert-themes.com/plugins/',
    'demo_url' => 'https://expert-themes.com/updated/dailyfit/',
    'support_url' => 'https://expert-themes.com/support',
    'help_url' => 'https://expert-themes.com/documentation/dailyfit',
    'email_support' => 'support@expert-themes.com',
    'video_url' => '#'
  ];
  
  return $infos;
}

/* ------ Template Filter ---- */
add_filter( 'exp_template_type_support', 'dailyfit_template_type_support' );
function dailyfit_template_type_support($type) {
	$extra_type = [
	    'header'              => esc_html__('Header Desktop', 'dailyfit'),
		'header-mobile'       => esc_html__('Header Mobile', 'dailyfit'),
		'widget'              => esc_html__('Widget Sidebar', 'dailyfit'),
		'page-title'   => esc_html__('Page Title', 'dailyfit'),
		'footer'              => esc_html__('Footer', 'dailyfit'), 
		'mega-menu'           => esc_html__('Mega Menu', 'dailyfit') ,
		'page-title'          => esc_html__('Page Title', 'dailyfit'), 
		'hidden-panel'        => esc_html__('Hidden Panel', 'dailyfit'),
		'tab'          => esc_html__('Tab', 'dailyfit'), 
		'popup'               => esc_html__('Popup', 'dailyfit'),
	];
	$template_type = array_merge($type,$extra_type); 
	return $template_type;
}

/* Search Result 
function dailyfit_search_result($query) {
	if ($query->is_search) {
		$query->set('post_type', 'post');
		$query->set('post_type', 'page');
		$query->set('post_type', 'portfolio');
		$query->set('post_type', 'service');
	}
	return $query;
}
add_filter('pre_get_posts','dailyfit_search_result'); */