<?php

if (!class_exists('Dailyfit_Header')) {

    class Dailyfit_Header
    {
        public function getHeader()
        {
            $header_layout = (int)dailyfit()->get_opt('header_layout');
            $header_layout_mobile = (int)dailyfit()->get_opt('header_layout_mobile');
            $header_layout_sticky = (int)dailyfit()->get_opt('header_layout_sticky');
            
            if(is_singular('product')) {
                $header_layout = (int)dailyfit()->get_theme_opt('header_layout_product', $header_layout ); 
            }
             
            if ($header_layout <= 0 || !class_exists('Exptheme_Core') || !is_callable( 'Elementor\Plugin::instance' )) {
                get_template_part( 'template-parts/header/default');
            }
            
            else {
                $args = [
                    'header_layout' => $header_layout,
                    'header_layout_sticky' => $header_layout_sticky,
                    'header_layout_mobile' => $header_layout_mobile
                ];
                get_template_part( 'template-parts/header/elementor','', $args );
            }
             
        }
 
    }
}
