<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Accordions With Icon
 */
class Dailyfit_Mega_Menu extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'et-mega-menu';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Mega Menu', 'dailyfit' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-accordion';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_dailyfit_header' ];
	}

	protected function register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Add Menus', 'dailyfit' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'acc_icon',
			[
				'label' => __( 'Icon', 'dailyfit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa',
				],
			]
		);

		$repeater->add_control(
			'acc_text',
			[
				'label' => __( 'Text', 'dailyfit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Text', 'dailyfit' ),
				'placeholder' => __( 'Text', 'dailyfit' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'acc_label',
			[
				'label' => __( 'Label', 'dailyfit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Label', 'dailyfit' ),
				'placeholder' => __( 'Item 1', 'dailyfit' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'acc_link',
			[
				'label' => __( 'Link', 'dailyfit' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->add_control(
			'ot_accs',
			[
				'label' => __( 'Menus', 'dailyfit' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

		//Title & Icon
		$this->start_controls_section(
			'style_title_icon',
			[
				'label' => __( 'Title, Icon & Effects', 'dailyfit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		//Title
		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'dailyfit' ),
				'type' => Controls_Manager::HEADING,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ct-menu-item li a' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'title_color_hover',
			[
				'label' => __( 'Hover Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ct-menu-item li a:hover' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .ct-menu-item li a',
			]
		);

		// Icon
		$this->add_control(
			'heading_icon_title',
			[
				'label' => __( 'Icon', 'dailyfit' ),
				'type' => Controls_Manager::HEADING,
				'separator'	=> 'before'
			]
		);
		$this->add_control(
			'icon_title_spacing',
			[
				'label' => __( 'Spacing', 'dailyfit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ct-menu-item li a i' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_title_size',
			[
				'label' => __( 'Size', 'dailyfit' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 6,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ct-menu-item li a i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_title_color',
			[
				'label' => __( 'Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ct-menu-item li a i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ct-menu-item li a svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_color_hover',
			[
				'label' => __( 'Icon Hover Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ct-menu-item li a i:hover' => 'color: {{VALUE}};',
				]
			]
		);

		//Title
		$this->add_control(
			'heading_animation',
			[
				'label' => __( 'Effects', 'dailyfit' ),
				'type' => Controls_Manager::HEADING,
				'separator'	=> 'before'
			]
		);

		$this->add_control(
			'mega_ani_name',
			[
				'label'     => __( 'Animation Name', 'dailyfit' ),
				'type'      => Controls_Manager::SELECT2,
				'default'   => '',
				'label_block' => true,
				'render_type' => 'template',
				'options'   => [
					''					=> __( 'Default', 'dailyfit' ),
					'sbFadeIn'          => __( 'Fade In', 'dailyfit' ),
					'sbSlideInLeft'     => __( 'Slide In Left', 'dailyfit' ),
					'sbSlideInRight'    => __( 'Slide In Right', 'dailyfit' ),
					'sbSlideInDown'     => __( 'Slide In Down', 'dailyfit' ),
					'sbSlideInUp'       => __( 'Slide In Up', 'dailyfit' ),
					'sbZoomIn'          => __( 'Zoom In', 'dailyfit' ),
					'sbZoomOut'         => __( 'Zoom Out', 'dailyfit' ),
					'sbRotateIn'    	=> __( 'Rotate In', 'dailyfit' ),
					'sbBounceIn'   		=> __( 'Bounce In', 'dailyfit' ),
					'sbBounceInLeft' 	=> __( 'Bounce In Left', 'dailyfit' ),
					'sbBounceInRight' 	=> __( 'Bounce In Right', 'dailyfit' ),
					'sbBounceInDown' 	=> __( 'Bounce In Down', 'dailyfit' ),
					'sbBounceInUp' 		=> __( 'Bounce In Up', 'dailyfit' ),
					'sbFlipInX' 		=> __( 'Flip In X', 'dailyfit' ),
					'sbFlipInY' 		=> __( 'Flip In Y', 'dailyfit' ),
				],
			]
		);
		$this->add_control(
			'mega_ani_duration',
			[
				'label'     => __( 'Animation Duration (ms)', 'dailyfit' ),
				'type'      => Controls_Manager::NUMBER,
				'min' => 100,
				'max' => 10000,
				'step' => 50,
				'default' => 700,
				'condition' => [
					'mega_ani_name!'     => '',
				],
			]
		);

		$this->add_control(
			'mega_ani_delay',
			[
				'label'     => __( 'Animation Delay (ms)', 'dailyfit' ),
				'type'      => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 10000,
				'step' => 50,
				'default' => 300,
				'condition' => [
					'mega_ani_name!'     => '',
				],

			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<ul class="ct-menu-item" <?php echo wp_kses($this->get_render_attribute_string( 'wrapper' ), true); ?>>
		    
		    
			<?php if ( $settings['ot_accs'] ) : foreach ( $settings['ot_accs'] as $key => $accs ) :  ?>
			
			<li>
			    
			    <?php if ( ! empty( $accs['acc_link']['url'] ) ) :  ?>
			    
			        <a href="<?php echo esc_url($accs['acc_link']['url']);  ?>" <?php if( ! empty( $accs['acc_link']['is_external'] ) ): ?>target="_blank"<?php endif;  ?>>
			            <?php if($accs['acc_icon']['value']) :  ?>
			                <i class="<?php echo esc_attr($accs['acc_icon']['value']);  ?>"></i>
			            <?php endif;  ?>
			                <cite><?php echo wp_kses_post( $accs['acc_label'] );  ?></cite>
			        </a>
			    
			    <?php endif; ?>
			    
			    
			</li>
			
			
			
			<?php endforeach; endif;  ?>
			    
			    
			   
	    </ul>

	    <?php
	}

}
// After the Dailyfit_Mega_Menu class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new Dailyfit_Mega_Menu() );