<?php 
	$dashboard_page_url = admin_url( 'admin.php?page=expert' );
	if( isset( $_GET['page'] ) && 'expert' === sanitize_text_field($_GET['page']) ) {
		$dashboard_page_url = '';
	}
	$plugin_page_url = admin_url( 'admin.php?page=expert-plugins' );
	$import_demos_page_url = admin_url( 'admin.php?page=expert-import-demos' );

	$exp_server_info = apply_filters( 'exp_server_info', 
		[
			'video_url' => 'https://expert-themes.com/video-guide/',
			'demo_url' => 'https://expert-themes.com/updated/',
			'docs_url' => 'https://expert-themes.com/doucmentation/dailyfit', 
			'support_url' => 'https://expert-themes.com/support/'] 
		) ; 
?>
<nav class="exp-dsb-menubar">
	<?php 
	$favicon = dailyfit()->get_theme_opt( 'favicon' );
	$logo_url = !empty($favicon['url']) ? $favicon['url'] : get_template_directory_uri() . '/inc/admin/assets/img/logo.png'; ?>
	<div class="exp-dsb-logo">
		<div class="exp-dsb-logo-inner">
			<img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr( dailyfit()->get_name() ); ?>">
		</div>
		<div class="exp-dsb-logo-title">
			<h2><?php esc_html_e( 'Welcome to', 'dailyfit' ); ?> <?php echo esc_attr( dailyfit()->get_name() ).'!'; ?></h2>
			<span class="exp-v"><?php esc_html_e( 'Version', 'dailyfit' ); ?> <?php echo esc_html(dailyfit()->get_version()) ?></span>
		</div>
	</div>
	<div class="exp-dsb-menu">
		<ul class="exp-dsb-menu-left">
			<li class="<?php echo ( isset( $_GET['page'] ) && 'expert' === sanitize_text_field($_GET['page']) ) ? 'is-active' : ''; ?>">
				<a href="<?php echo esc_attr($dashboard_page_url); ?>">
					<span><?php echo sprintf( esc_html__( '%s Dashboard', 'dailyfit' ), dailyfit()->get_name()); ?></span>
				</a>
			</li>
			<li class="<?php echo ( isset( $_GET['page'] ) && 'expert-plugins' === sanitize_text_field($_GET['page']) ) ? 'is-active' : ''; ?>">
				<a href="<?php echo esc_url($plugin_page_url); ?>">
					<span><?php esc_html_e( 'Install Plugins', 'dailyfit' ); ?></span>
				</a>
			</li>
			<li class="<?php echo ( isset( $_GET['page'] ) && 'expert-import-demos' === sanitize_text_field($_GET['page']) ) ? 'is-active' : ''; ?>">
				<a href="<?php echo esc_url($import_demos_page_url); ?>">
					<span><?php esc_html_e( 'Import Demo', 'dailyfit' ); ?></span>
				</a>
			</li>
		</ul>
		<ul class="exp-dsb-menu-right">
			<li>
				<a href="<?php echo esc_url($exp_server_info['support_url']) ?>" target="_blank">
					<span><?php esc_html_e( 'Support system', 'dailyfit' ); ?></span>
				</a>
			</li>
			<li>
				<a href="<?php echo esc_url($exp_server_info['demo_url']) ?>" target="_blank">
					<span><?php esc_html_e( 'Live Demo', 'dailyfit' ); ?></span>
				</a>
			</li>
			 
			<li>
				<a href="<?php echo esc_url($exp_server_info['docs_url']) ?>" target="_blank">
					<i class="exp-icn-ess icon-md-help-circle"></i>
					<span><?php esc_html_e( 'Documentations', 'dailyfit' ); ?></span>
				</a>
			</li>
		</ul>
	</div>
</nav> 
