<main>

	<div class="exp-dashboard-wrap">

		<?php include_once( get_template_directory() . '/inc/admin/views/admin-tabs.php' ); ?>
		<?php 
		$installed_plugins = get_plugins();
		$plugins = TGM_Plugin_Activation::$instance->plugins;
 		 
		$plugin_requires = array();
		foreach( $plugins as $plugin ){
			$file_path = $plugin['file_path'];
			
			$this_active =  in_array( $plugin['file_path'], (array) get_option( 'active_plugins', array() ), true ) || is_plugin_active_for_network( $plugin );
 
			if( $plugin['required'] === true && !$this_active){
				$plugin_requires[] = $plugin['name'];
			}
		}  
		?>

		<header class="exp-dsb-header">
			<div class="exp-dsb-header-inner">
				<h4><?php esc_html_e( 'Import a Demo', 'dailyfit' ); ?></h4>
				<p><?php esc_html_e( 'Choose a pre-built website for starting a quick design process.', 'dailyfit' ) ?></p>
			</div>
			<div class="exp-msg exp-dsb-notice">
				<p><span><?php esc_html_e( 'Note:', 'dailyfit' ); ?></span> <?php esc_html_e( 'Make sure to activate required plugins prior to import a demo.', 'dailyfit' ) ?></p>
			</div>
		</header>

		<?php

			include( locate_template( 'inc/admin/demo-data/demo-config.php' ) );
			$i = 0;
			wp_localize_script( 'expert-admin', 'expert_demos', $demos );

		?>
		<div id="exp-demos" class="exp-demos exp-solid-wrap">

			<div class="exp-tab-nav">
				<ul>
					<li><a class="active" href="#exp-demos-elementor" data-filter="elementor">Elementor</a></li>
					<li><a href="#exp-demos-wpbakery" data-filter="wpbakery">WPBakery</a></li>
				</ul>
			</div>

			<div class="exp-tab-content">
				<div class="exp-row">
					<?php foreach( $demos as $id => $demo ): ?>

					<div class="exp-col exp-col-4 <?php echo !empty($demo['dailyfit']) ? esc_attr($demo['dailyfit']) : esc_attr('elementor'); ?>">
			
						<div class="exp-dsb-demo-item">

							<figure>
								<img src="<?php echo esc_url( $demo['screenshot'] ); ?>" alt="<?php echo esc_attr( $demo['title'] ); ?>">
								<div class="exp-dsb-overlay"></div>
								<div class="exp-btn-group">
									<a href="#" id="import-id" data-import-id="<?php echo esc_attr( $i ); ?>" data-demo-id="<?php echo esc_attr( $id ); ?>" class="exp-btn exp-popup-import">
										<span><?php esc_html_e( 'Import Demo', 'dailyfit' ); ?></span>
									</a><br/>
									<a target="_blank" href="<?php echo esc_url( $demo['preview'] ); ?>" class="exp-preview-btn">
										<span><?php esc_html_e( 'Preview Demo', 'dailyfit' ); ?></span>
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-external-link"><path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/><polyline points="15 3 21 3 21 9"/><line x1="10" y1="14" x2="21" y2="3"/></svg>
									</a>
								</div>
							</figure>
							<h3><?php echo esc_html( $demo['title'] ); ?></h3>
						</div>
					</div>

					<?php $i++; ?>
					<?php endforeach; ?>

				</div>
			</div>

		<script type="text/template" id="tmpl-demo-import-modules">
			<div id="exp-progress-popup" class="exp-imp-popup-wrap is-active">
				<div class="exp-imp-progress">
					<h6><?php esc_html_e( 'Importing...', 'dailyfit' ); ?></h6>
					<div id="exp-progress" class="importing"><?php esc_html_e( 'Working', 'dailyfit' )?> <span>.</span><span>.</span><span>.</span></div>
					<div class="exp-progressbar">
						<div class="exp-progressbar-inner" style="width: 0%">
							<span id="exp-loader" class="exp-progressbar-percentage"><?php esc_html_e( '0%', 'dailyfit' ); ?></span>
						</div>
					</div>
				</div>
			</div>
		</script>

		<script type="text/template" id="tmpl-demo-popup">
			<div id="exp-popup" class="exp-imp-popup-wrap is-active">
				<div class="exp-imp-popup-inner">
				
					<span class="exp-imp-popup-close"></span>
					 
					<div class="exp-imp-popup-content">
						<h4 style="text-align:center; margin-bottom: 30px;"><?php esc_html_e( 'Select all or a few', 'dailyfit' ); ?></h4>
						<div class="exp-row">
							<div class="exp-col exp-col-6">
								<span class="exp-imp-opt">
									<input id="exp-imp-media" type="checkbox" value="import_media" checked="">
									<label for="exp-imp-media"></label>
									<span><?php esc_html_e( 'Media Attachments', 'dailyfit' ); ?></span>
								</span>
							</div>
							<div class="exp-col exp-col-6">
								<span class="exp-imp-opt">
									<input id="exp-imp-content" type="checkbox" value="import_content" checked="">
									<label for="exp-imp-content"></label>
									<span><?php esc_html_e( 'Content', 'dailyfit' ); ?></span>
								</span>
							</div>
							<div class="exp-col exp-col-6">
								<span class="exp-imp-opt">
									<input id="exp-imp-options" type="checkbox" value="import_theme_options" checked="">
									<label for="exp-imp-options"></label>
									<span><?php esc_html_e( 'Theme Options', 'dailyfit' ) ?></span>
								</span>
							</div>
							<div class="exp-col exp-col-6">
								<span class="exp-imp-opt">
									<input id="exp-imp-widgets" type="checkbox" value="import_widgets" checked="">
									<label for="exp-imp-widgets"></label>
									<span><?php esc_html_e( 'Widgets', 'dailyfit' ); ?></span>
								</span>
							</div>
							<?php if(!empty($plugins['revslider'])): ?>
							<div class="exp-col exp-col-6">
								<span class="exp-imp-opt">
									<input id="exp-imp-revslider" type="checkbox" value="import_slider" checked="">
									<label for="exp-imp-revslider"></label>
									<span><?php esc_html_e( 'Revslider', 'dailyfit' ); ?></span>
								</span>
							</div>
 							


 							
							<div class="exp-col exp-col-6">
								<span class="exp-imp-opt">
									<input id="exp-imp-settings" type="checkbox" value="import_settings" checked="">
									<label for="exp-imp-settings"></label>
									<span><?php esc_html_e( 'Settings', 'dailyfit' ) ?></span>
								</span>
							</div>
						</div>
						<div class="exp-row" style="padding-top: 30px;">
							<div class="exp-col exp-col-12">
								<button class="exp-import-btn" data-id="0">
									<span><?php esc_html_e( 'Import Demo', 'dailyfit' ); ?></span>
								</button>
							</div>
						</div>
					</div>
				  
				</div>
			</div>
		
		</script>
			
		</div>
		<?php endif; ?>
	</div>

</main>
