(function($) {

    "use strict";
    $(document).ready(function () {
        initTabs();
        initDemo();
        initPlugin();
    });

    function initTabs(){
        $(document).on('click','.exp-tab-nav > ul > li > a',function(){
            var data_filter = $(this).attr('data-filter');
            $(this).closest('ul').find('a').removeClass('active');
            $(this).addClass('active');
            $(this).closest('.exp-demos').find('.exp-col:not(.'+data_filter+')').css('display','none');
            $(this).closest('.exp-demos').find('.exp-col.'+data_filter).css('display','flex');
        });
    }

    function initDemo(){
        $('.exp-demos').on('click', '.exp-popup-import', function() {
            if ($('.exp-error-message').length) {
                return;
            }
            var id = $(this).data('demo-id'),
            demo = expert_demos[id];
            //var demo_id = $(this).attr('data-import-id');
            $.ajax({
                url: ajaxurl,
                type: 'GET',
                data: {
                    action: 'expert_prepare_demo_package',
                    demo: id
                },
                beforeSend: function() {
                    $('.exp-demo-loader').addClass('is-active');
                }
            }).done(function(resp) { 
                var jsonresp = JSON.parse(resp);
                if (jsonresp.stat === 1) {
                    $('.exp-demo-loader').removeClass('is-active');
                    $(document.body).append($('#tmpl-demo-popup').html());
                    initPopUp(id);
                } else {
                    $('.exp-demo-loader').removeClass('is-active');
                    var $content = 'Your server connection';
                    if( ( jsonresp.stat === 0 ) && ( jsonresp.message != null ) ) {   
                        $content = jsonresp.message;
                    }
                    $('.exp-demo-error-confirm').find('.message').html($content);
                    $('.exp-demo-error-confirm').addClass('is-active'); 
                }
            });

            return false;
        });
        $(document).on('click','.exp-demo-error-confirm .btn',function(){
            $(this).closest('.exp-demo-error-confirm').removeClass('is-active');
        })
    }
 
    function initPopUp(demo) {
        var popup = $('#exp-popup');
        $('#exp-popup').on('click', '.exp-imp-popup-close', function() {
            popup.remove();
        });

        // Import Now
        $('#exp-popup').on('click', '.exp-import-btn', function() {
           
            var options = [];
            $(this).closest('.exp-imp-popup-wrap').find(' .exp-imp-opt :checked').each(function() {
                options.push($(this).val());
            });

            var crop_img = 'yes';
            var crop_img_checked = $(this).closest('.exp-imp-popup-wrap').find(' .exp-imp-opt-crop :checked').val();
            if (typeof crop_img_checked === 'undefined') {
                crop_img = 'no';
            }
             
            var importer = new expertImporter(demo, options, crop_img);
        });
    }

    var expertImporter = function(id, options, crop_img) {
        
        var $this = this;
 
        $this.id = id;
         
        $this.options = options;
        
        $this.crop_img = crop_img;

        this.init = function() {
           
            var self = this,
            message,
            start = $('#exp-popup'),
            actions = this.options.slice();
            start.hide();
            
            $(document.body).append($('#tmpl-demo-import-modules').html());
          
            var data = new FormData();
 
            data.append('selected', 2);
            data.append('selections', options);
            runImport($this.options, $this.id, $this.crop_img);
            
        };

        this.init();

    };

    function runImport(options, id, crop_img) {
        var count = 0;  
        //options = ['import_media', 'import_content', 'import_theme_options', 'import_widgets', 'import_slider', 'import_settings'];
        options[count] && ajaxRun('expert_' + options[options.length - options.length], options, id, count, crop_img, function() {
            count++;  
            options[count] && ajaxRun('expert_' + options[count], options, id, count, crop_img, function() {
                count++;  
                options[count] && ajaxRun('expert_' + options[count], options, id, count, crop_img, function() {
                    count++;
                    options[count] && ajaxRun('expert_' + options[count], options, id, count, crop_img, function() {
                        count++;
                        options[count] && ajaxRun('expert_' + options[count], options, id, count, crop_img, function() {
                            count++;
                            options[count] && ajaxRun('expert_' + options[count], options, id, count, crop_img);
                        });
                    });
                });
            })
        });
    }
    
    function ajaxRun(action, options, demo, idx, crop_img, callback) {
        
        var ajaxupdater, ajaxprogress;

        ajaxupdater = setInterval(function () {
            var width = ((idx + 1) * 100) / options.length;
            width = Math.ceil(width);
            $('#exp-loader').parent().css('width', width + '%');
            $('#exp-loader').html( width + '%');
        }, 1000);
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: action,
                demo: demo,
                content: ($('#exp-imp-all').is(':checked') ? 1 : 0),
                media: ($('#exp-imp-media').is(':checked') ? 1 : 0)
            },
            beforeSend: function(jq) {
                if(idx == 0){
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'expert_import_start',
                            demo: demo
                        }
                    })
                }
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'expert_reset_logs',
                    },
                });
                ajaxprogress = setInterval(getProgress, 1000);

            },
            success: function(d) {
                 
            },
            complete: function() {
                if (typeof callback === 'function' && !action.match('undefined')) {
                    callback();
                }
                clearInterval(ajaxupdater);
                clearInterval(ajaxprogress);
            },
        }).done(function(res) {
            console.log(res); 
            if ('expert_' + options[options.length - 1] === action) {
                clearInterval(ajaxupdater);
                clearInterval(ajaxprogress);
                
                runImportFinish(options, demo, crop_img);

                var popup = $('#exp-popup');
                $('#exp-loader').parent().css('min-width', '100%');
                $('#exp-loader').text("100%");
                setTimeout(function() {
                    $('#exp-progress-popup').hide();
                    $('#exp-progress').hide();
                    setTimeout(function() { popup.remove(); }, 10000);

                }, 800)

                if (typeof merlin_params !== 'undefined') {
                    var current_url = window.location.href;
                    current_url = current_url.replace("content", "ready");
                    window.location.href = current_url;
                }

                return false;
            }
        });
    }
    function runImportFinish(options, id, crop_img){
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'expert_import_finish',
                demo: id,
                crop_img: crop_img 
            },
            success: function(d) {
                 
            },
            complete: function() {
                if (typeof merlin_params === 'undefined') {
                    reload();
                }
            },
        })

    }
    function getProgress() {
        $.ajax({
            url: ajaxurl,
            type: 'GET',
            data: {
                action: 'expert_progress_imported',
            },
        }).done(function(resp) {
            $('#exp-progress').text(resp);
            return false;
        });
        return false;
    }
      
    function reload() {
        setTimeout(function(){ location.reload(); }, 5000);
    }

    function ExlPluginManager(){
        var complete;
        var items_completed     = 0;
        var current_item        = "";
        var $current_node;
        var current_item_hash   = "";

        function ajax_callback(response){  
            var currentSpan = $current_node.find("h3>span"); 
            var current_btn = $current_node.find(".exp-button"); 
            var new_text = current_btn.attr('data-text-active');
            var new_href = current_btn.attr('data-deactive-url');

            if(typeof response === "object" && typeof response.message !== "undefined"){
                currentSpan.html('Active');
                current_btn.find('span').html(new_text);
                $current_node.removeClass( 'installing success error' ).addClass(response.message.toLowerCase());
                current_btn.attr('href',new_href);

                // The plugin is done (installed, updated and activated).
                if(typeof response.done != "undefined" && response.done){ 
                    $current_node.removeClass('current');
                    find_next();
                }else if(typeof response.url != "undefined"){
                    // we have an ajax url action to perform.
                    if(response.hash == current_item_hash){             
                        $current_node.removeClass( 'installing success' ).addClass("error");
                        current_btn.find('span').html('Error');
                        find_next();
                    }else {
                        current_item_hash = response.hash;
                        jQuery.post(response.url, response, ajax_callback).fail(ajax_callback);
                    }
                }else{
                    // error processing this plugin
                    find_next();
                }
            }else{
                // The TGMPA returns a whole page as response, so check, if this plugin is done.
                process_current();
            }
        }

        function process_current(){ 
            if(current_item){
                $current_node.addClass("current");    
                jQuery.post(expert_admin.ajaxurl, {
                    action: "merlin_plugins",
                    wpnonce: expert_admin.wpnonce,
                    slug: current_item,
                }, ajax_callback).fail(ajax_callback);
            }
        }

        function find_next(){  
            if($current_node){ 
                if(!$current_node.hasClass("exp-dsb-plugin-active")){
                    items_completed++;
                    $current_node.addClass("exp-dsb-plugin-active");
                }
            }

            var $plus_item = $('.exp-plugin-inst');
            if( $plus_item.length > 0 ){
                $plus_item.each(function(){
                    var $item = $(this).closest('.exp-dsb-plugin');

                    if ( $item.hasClass("exp-dsb-plugin-active") ) {
                        return true;
                    }
                    
                    current_item = $item.data("slug");
                    $current_node = $item;
                    process_current();
                    return false;
                });
            }
            
            if(items_completed >= $plus_item.length){
                // finished all plugins!
                complete();
            }
        }

        return {
            init: function(){
 
                $('.exp-install-all-plugin').addClass("installing");
                $('.exp-dsb-plugin:not(.exp-dsb-plugin-active)').addClass("installing");
                complete = function(){

                    setTimeout(function(){
                        $(".exp-dashboard-wrap").addClass('js-plugin-finished');
                        $('.exp-install-all-plugin').removeClass("installing");
                    },1000);
 
                };
                find_next();
            }
        }
    }

    function initPlugin(){
        $(".exp-install-all-plugin").on( "click", function(e) {
            e.preventDefault();
            var plugins = new ExlPluginManager();
            plugins.init();
        });
    }

})(jQuery);