<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
get_template_part( 'inc/admin/libs/tgmpa/class-tgm-plugin-activation' );

add_action( 'tgmpa_register', 'dailyfit_register_required_plugins' );
function dailyfit_register_required_plugins() {
    include( locate_template( 'inc/admin/demo-data/demo-config.php' ) );
    $exp_server_info = apply_filters( 'exp_server_info', ['plugin_url' => 'https://api.expert-themes.com/plugins/'] );
    $default_path = $exp_server_info['plugin_url'];
    $images = get_template_directory_uri() . '/inc/admin/assets/img/plugins';
    $plugins = array(

        array(
            'name'               => esc_html__('Redux Framework', 'dailyfit'),
            'slug'               => 'redux-framework',
            'required'           => true,
            'logo'        => $images . '/redux.png',
            'description' => esc_html__( 'Build theme options and post, page options for WordPress Theme.', 'dailyfit' ),
        ),

        array(
            'name'               => esc_html__('Elementor', 'dailyfit'),
            'slug'               => 'elementor',
            'required'           => true,
            'logo'        => $images . '/elementor.png',
            'description' => esc_html__( 'Introducing a WordPress website builder, with no limits of design. A website builder that delivers high-end page designs and advanced capabilities', 'dailyfit' ),
        ),

        array(
            'name'               => esc_html__('DAILYFIT Plugin', 'dailyfit'),
            'slug'               => 'dailyfit-plugin',
            'source'             => 'dailyfit-plugin.zip',
            'version'                => '1.0',
            'logo'        => $images . '/expert-logo.png',
            'required'           => true,
            'description' => esc_html__( 'Main process and Powerful Elements Plugin, exclusively for Dailyfit WordPress Theme.', 'dailyfit' ),
        ),

        array(
            'name'                  => esc_html__('Revolution Slider', 'dailyfit'),
            'slug'                  => 'revslider',
            'source'             => 'revslider.zip',
            'required'              => false,
            'logo'        => $images . '/rev-slider.png',
            'description' => esc_html__( 'Revolution Slider helps beginner-and mid-level designers WOW their clients with pro-level visuals.', 'dailyfit' )
        ),
  
        array(
            'name'               => esc_html__('Contact Form 7', 'dailyfit'),
            'slug'               => 'contact-form-7',
            'required'           => true,
            'logo'        => $images . '/contact-f7.png',
            'description' => esc_html__( 'Contact Form 7 can manage multiple contact forms, you can customize the form and the mail contents flexibly with simple markup', 'dailyfit' ),
        ), 

        array(
            'name'               => esc_html__('Mailchimp', 'dailyfit'),
            'slug'               => "mailchimp-for-wp",
            'required'           => true,
            'logo'        => $images . '/mailchimp.png',
            'description' => esc_html__( 'Allowing your visitors to subscribe to your newsletter should be easy. With this plugin, it finally is.', 'dailyfit' ),
        ),
        array(
            'name'               => esc_html__('WooCommerce', 'dailyfit'),
            'slug'               => "woocommerce",
            'required'           => false,
            'logo'        => $images . '/woo.png',
            'description' => esc_html__( 'WooCommerce is the world’s most popular open-source eCommerce solution.', 'dailyfit' ),
        ),
        array(
            'name'      => esc_html__( 'Timetable and Event Schedule','dailyfit' ),
            'slug'      => ' mp-timetable',
            'required'  => true,
        ),
    );

    $config  = array(
        'default_path' => $default_path,           // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'is_automatic' => true,
    );
 

    tgmpa( $plugins, $config );

}