<?php
exp_add_custom_widget(
    array(
        'name' => 'video_box',
        'title' => esc_html__('Dailyfit Video Box', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/video_box/layout1.jpg'
                                ], 
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/video_box/layout2.jpg'
                                ], 
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Content', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        //Basket Image
						array(
                            'name' => 'video_img',
                            'label' => __( 'Choose Video Image', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
						),
						array(
							'name' => 'title',
							'label' => esc_html__('Transparent Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
						), 
						//Video Link Option	
						array(
                            'name' => 'video_option',
                            'label' => __( 'Select Video Type', 'dailyfit' ),
							'label_block' => true, 
							'type' => \Elementor\Controls_Manager::SELECT,
							'default' => 'src_url',
							'options' => array(
								'src_url'       => esc_html__( 'Source URL', 'dailyfit' ),
								'src_media'      => esc_html__( 'Source Media', 'dailyfit' ),
							),
                        ),
						//Video Link
						array(
                            'name' => 'video_link',
                            'label' => __( 'Video Source Url', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::URL,
							'label_block' => true, 
							'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
							'show_external' => true,
							'default' => [
								'url' => '',
							],
							'condition' => [
								'video_option'      => 'src_url'
							],
                        ),
						//Video Image
						array(
                            'name' => 'video_source_image',
                            'label' => __( 'Video Source Media', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
							'media_types' => ['video'],
							'condition' => [
								'video_option'      => 'src_media'
							],
                        ),
					),
                ),
                dailyfit_widget_animation_settings(),            
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);