<?php

exp_add_custom_widget(
    array(
        'name' => 'testimonial_carousel',
        'title' => esc_html__('Dailyfit Testimonial Carousel', 'dailyfit'),
        'icon' => 'eicon-testimonial',
        'categories' => array('exptheme-core'),
        'scripts' => array(
            'exp-owl-carousel',
            'exp-owl',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/testimonial_carousel/layout1.png'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/testimonial_carousel/layout2.png'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Reviews From You', 'dailyfit'),
                            'condition' => ['layout'      => ['2'] ],
                        ),
                        array(
                            'name' => 'subtitle',
                            'label' => esc_html__('Sub Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Testimonials', 'dailyfit'),
                            'condition' => ['layout'      => ['2'] ],
                        ),
                        array(
                            'name' => 'testimonial',
                            'label' => esc_html__('Testimonial', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => ['layout'      => ['1', '2'] ],
                            'controls' => array(
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Choose Image Url', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'designation',
                                    'label' => esc_html__('Designation', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Description', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                    'show_label' => false,
                                ),
                                array(
                                    'name' => 'star',
                                    'label' => esc_html__('Icon Star', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        '5' => '5 Star',
                                        '4' => '4 Star',
                                        '3' => '3 Star',
                                        '2' => '2 Star',
                                        '1' => '1 Star',
                                    ],
                                    'default' => '5',
                                ),
                            ),
                        ),
                    
                    ),
                ),
                
                
                
                array(
                    'name' => 'section_style_heading',
                    'label' => esc_html__('Heading Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => ['layout'      => ['2'] ],
                    'controls' => array(
                        array(
                            'name' => 'heading_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'heading_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .sec-title h2',
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_style_subheading',
                    'label' => esc_html__('Sub Heading Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => ['layout'      => ['2'] ],
                    'controls' => array(
                        array(
                            'name' => 'subheading_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'subheading_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .sec-title .title',
                        ),
                    ),
                ),
                
                
                array(
                    'name' => 'section_style_desc',
                    'label' => esc_html__('Text Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-text' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'desc_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_designation',
                    'label' => esc_html__('Designation Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'designation_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-designation' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'designation_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-designation',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_btitle',
                    'label' => esc_html__('Title Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'btitle_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btitle_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_style_rating',
                    'label' => esc_html__('Rating Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'rating_color',
                            'label' => esc_html__('Rating & Image Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .testimonial-block .inner-box .rating .fa' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .testimonial-block-two .inner-box .rating .fa' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .testimonials-thumbs-carousel .carousel-thumbnails .carousel-indicators li .image:before' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .testimonial-block-two .inner-box .upper-box .author-image:before' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_style_arrows',
                    'label' => esc_html__('Arrows Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => ['layout'      => ['1'] ],
                    'controls' => array(
                        array(
                            'name' => 'arrows_color',
                            'label' => esc_html__('Arrow Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .testimonial-section .testimonial-column .owl-nav .owl-next' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .testimonial-section .testimonial-column .owl-nav .owl-prev' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'arrows_hover_color',
                            'label' => esc_html__('Arrow Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .testimonial-section .testimonial-column .owl-nav .owl-prev:hover' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .testimonial-section .testimonial-column .owl-nav .owl-next:hover' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_carousel',
                    'label' => esc_html__('Carousel', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'dots',
                            'label' => esc_html__('Show Dots', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Speed', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'false'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                    ),
                ),
                
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);