<?php
exp_add_custom_widget(
    array(
        'name' => 'pricing',
        'title' => esc_html__('Dailyfit Pricing Plan', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pricing/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pricing/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'bg_img',
                            'label' => esc_html__('BG Image Url', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        //Title
						array(
                            'name' => 'plan_title',
                            'label' => esc_html__( 'Plan Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'default' => esc_html__( 'Basic Plan', 'dailyfit' ),
                        ),
                        //Text
						array(
                            'name' => 'plan_text',
                            'label' => esc_html__( 'Plan Text', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'default' => esc_html__( 'Basic Plan', 'dailyfit' ),
                        ),
                        //Duration
						array(
                            'name' => 'plan_duration',
                            'label' => esc_html__( 'Plan Duration', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__( 'Monthly', 'dailyfit' ),
                        ), 
                        //Price
						array(
                            'name' => 'plan_price',
                            'label' => esc_html__( 'Price', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__( '$99.00', 'dailyfit' ),
                        ),                        
						                        
						array(
                            'name' => 'plan_list',
                            'label' => esc_html__('Add Feature List Item', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'list_title',
                                    'label' => esc_html__('Feature List', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ list_title }}}',
                        ),
                        //Duration
						array(
                            'name' => 'btn_title',
                            'label' => esc_html__( 'Button Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__( 'Purchased', 'dailyfit' ),
                        ),
						array(
							'name' => 'link_option',
							'label'   => esc_html__( 'Select link Option', 'dailyfit' ),
							'label_block' => true,
							'type'    => \Elementor\Controls_Manager::SELECT,
							'default' => 'extranal',
							'options' => array(
								'extranal' => esc_html__( 'Extranal ', 'dailyfit'),
								'page' => esc_html__( 'Page ', 'dailyfit'),
							),
						),
						array(
							'name' => 'link',
							'label' => __( 'External Link', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::URL,
							'label_block' => true, 
							'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
							'show_external' => true,
							'default' => [
								'url' => '',
								'is_external' => true,
								'nofollow' => true,
							],
							'condition'   => [
								'link_option' => 'extranal'
							]
						),
						array(
							'name' => 'page_select',
							'label' => esc_html__('Select Page', 'dailyfit' ),
							'label_block' => true, 
							'type' => \Elementor\Controls_Manager::SELECT2,
							'default' => 'extranal',
							'options' => dailyfit_page_list(),
							'condition'   => [
								'link_option' => 'page'
							]
						),
					),
				),
				
                
                //General Style
				array(
					'name' => 'section_style_general',
					'label' => esc_html__('General Settings', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'general_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .dailyfit-price-plan' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'general_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .dailyfit-price-plan' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
					),
				),
                
                
                
                //Title Style
				array(
					'name' => 'section_style_title',
					'label' => esc_html__('Title', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'title_color',
							'label' => esc_html__('Title Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
					),
				),
				
				//Text Style
				array(
					'name' => 'section_style_text',
					'label' => esc_html__('Text', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'text_color',
							'label' => esc_html__('Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-text' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
					),
				),
                
                //Duration Text Style
				array(
					'name' => 'section_style_duration',
					'label' => esc_html__('Plan Duration', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'duration_text_color',
							'label' => esc_html__('Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-duration' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'duration_text_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-duration',
                        ),
					),
				),
                                
				//Price Style
				array(
					'name' => 'section_style_price',
					'label' => esc_html__('Price', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'price_color',
							'label' => esc_html__('Price Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-price' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .te-price sup' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'price_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-price',
                        ),
					),
				),
				
				//List Style
				array(
					'name' => 'section_style_list',
					'label' => esc_html__('Feature List', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'feature_list_color',
							'label' => esc_html__('Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .dailyfit-list li' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'feature_list_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .dailyfit-list li',
                        ),
                        array(
							'name' => 'feature_list_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .dailyfit-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'feature_list_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .dailyfit-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
					),
				),
				
				array(
                    'name' => 'tab_style_button',
                    'label' => esc_html__('Button', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'button_typography',
                            'label' => esc_html__('Button Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .btn-style-one',
                        ),
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Button Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-one' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_bg_color',
                            'label' => esc_html__('Button Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-one' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'button_padding',
                            'label' => esc_html__('Padding', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'button_margin',
                            'label' => esc_html__('Margin', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-one' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'button_border_radius',
                            'label' => esc_html__('Border Radius', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-one' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name'         => 'button_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .btn-style-one'
                        ),
                        array(
                            'name' => 'button_border_color',
                            'label' => esc_html__( 'Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .btn-one-outer:before' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .btn-one-outer:after' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style_button_hover',
                    'label' => esc_html__('Button Hover', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'button_bg_color_hover',
                            'label' => esc_html__('Button Background Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-one:before' => 'border-bottom: 55px solid {{VALUE}};',
                                '{{WRAPPER}} .btn-style-one:after' => 'border-bottom: 55px solid {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_color_hover',
                            'label' => esc_html__('Button Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-one:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_border_color_hover',
                            'label' => esc_html__( 'Border Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .btn-one-outer:after' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'button_border_type!' => '',
                            ],
                        ),
                    ),
                ),
				dailyfit_widget_animation_settings(),
			),
        ),
    ),
    dailyfit_get_class_widget_path()
);