<?php
$et_supports = ['post','portfolio','service', 'team', 'product'];
exp_add_custom_widget(
    array(
        'name' => 'post_grid',
        'title' => esc_html__('Dailyfit Post Grid', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'scripts' => [
            'imagesloaded',
            'isotope',
            'dailyfit-post-grid',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'dailyfit' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => dailyfit_get_post_type_options($et_supports),
                                'default'  => 'post'
                            )
                        ),
                        dailyfit_get_post_grid_layout($et_supports)
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'dailyfit' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'dailyfit' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'dailyfit' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        dailyfit_get_grid_term_by_post_type($et_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        dailyfit_get_grid_ids_by_post_type($et_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'dailyfit' ),
                                    'ID' => esc_html__('ID', 'dailyfit' ),
                                    'author' => esc_html__('Author', 'dailyfit' ),
                                    'title' => esc_html__('Title', 'dailyfit' ),
                                    'rand' => esc_html__('Random', 'dailyfit' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'dailyfit' ),
                                    'asc' => esc_html__('Ascending', 'dailyfit' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_grid',
                    'label' => esc_html__('Grid', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                            
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'grid_masonry',
                            'label' => esc_html__('Grid Masonry', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'col_xs_m',
                                    'label' => esc_html__('Columns XS Devices', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '1',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_sm_m',
                                    'label' => esc_html__('Columns SM Devices', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '2',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_md_m',
                                    'label' => esc_html__('Columns MD Devices', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '3',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_lg_m',
                                    'label' => esc_html__('Columns LG Devices', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '4',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_xl_m',
                                    'label' => esc_html__('Columns XL Devices', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '4',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'img_size_m',
                                    'label' => esc_html__('Image Size', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_display',
                    'label' => esc_html__('Display', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'date',
                            'label' => esc_html__('Show Date', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2','post-3']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_title',
                            'label' => esc_html__('Show Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1', 'team-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2', 'post-3']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_comments',
                            'label' => esc_html__('Show Comments', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'author',
                            'label' => esc_html__('Show Author', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_excerpt',
                            'label' => esc_html__('Show Excerpt', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-3']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 25,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-3']],
                                            ['name' => 'show_excerpt', 'operator' => 'in', 'value' => ['true']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                                            ['name' => 'show_excerpt', 'operator' => 'in', 'value' => ['true']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'show_read_btn',
                            'label' => esc_html__('Show Read More Button', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-2', 'post-3']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'btn_title',
                            'label' => esc_html__('Button Title', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'placeholder' => esc_html__( 'Enter button title', 'dailyfit' ),
                            'default' => esc_html__( 'Read More', 'dailyfit' ),
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-2', 'post-3']],
                                            ['name' => 'show_read_btn', 'operator' => 'in', 'value' => ['yes']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']],
                                            ['name' => 'show_read_btn', 'operator' => 'in', 'value' => ['yes']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'show_category',
                            'label' => esc_html__('Show Category', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'product'],
                                            ['name' => 'layout_product', 'operator' => 'in', 'value' => ['product-1']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_price',
                            'label' => esc_html__('Show Price', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'product'],
                                            ['name' => 'layout_product', 'operator' => 'in', 'value' => ['product-1']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_social',
                            'label' => esc_html__('Show Sodial Media', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_designation',
                            'label' => esc_html__('Show Designation', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1', 'team-2']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        //Pagination
    					array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'product'],
                                            ['name' => 'layout_product', 'operator' => 'in', 'value' => ['product-1']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1','team-2']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                                        ],
                                    ],
                                ],
                            ],
                            'options' => [
                                'pagination' => esc_html__('Pagination', 'dailyfit' ),
                                'loadmore' => esc_html__('Loadmore', 'dailyfit' ),
                                'false' => esc_html__('Disable', 'dailyfit' ),
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style',
                    'label' => esc_html__('Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_hover_color',
                            'label' => esc_html__('Image Hover Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box .image' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        
                        array(
                            'name' => 'category_color',
                            'label' => esc_html__('Category Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li a' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li .icon' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'category_icon_color',
                            'label' => esc_html__('Category Icon Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li .icon' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'category_typography',
                            'label' => esc_html__('Category Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li a',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                        ),
                        array(
                            'name' => 'date_title_bg_color',
                            'label' => esc_html__('Date Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2', 'post-3']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-one.update-block .inner-box .image-box .post-date' => 'background-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .news-block .inner-box .image .post-date' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'date_title_color',
                            'label' => esc_html__('Date Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2', 'post-3']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .te-date' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'date_title_typography',
                            'label' => esc_html__('Date Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => 
                                '{{WRAPPER}} .te-date',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2', 'post-3']]
                                        ]
                                    ]
                                ],
                            ],
                        ),
                        
                        //Author Style
                        array(
                            'name' => 'author_icon_box_bg_color',
                            'label' => esc_html__('Author icon box Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box .lower-content .lower-box .author-info .icon' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_icon_box_border_color',
                            'label' => esc_html__('Author icon box Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box .lower-content .lower-box .author-info .icon' => 'border: 1px solid {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_icon_hover_color',
                            'label' => esc_html__('Author icon box Hover Background  Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_icon_hover_border_color',
                            'label' => esc_html__('Author icon box Hover Border  Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon' => 'border: 1px solid {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_icon_color',
                            'label' => esc_html__('Author icon Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box .lower-content .lower-box .author-info .icon' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_icon_hover_color1',
                            'label' => esc_html__('Author icon Color On Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_icon_hover_color',
                            'label' => esc_html__('Author icon hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_title_color',
                            'label' => esc_html__('Author Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .te-author' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'author_title_typography',
                            'label' => esc_html__('Author Title Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-author',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                                        ]
                                    ]
                                ],
                            ],
                        ),
                        
						//Comments Style
                        array(
                            'name' => 'comment_title_color',
                            'label' => esc_html__('Comments Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .te-comments' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'comments_title_typography',
                            'label' => esc_html__('Comments Title Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-comments',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                                        ]
                                    ]
                                ],
                            ],
                        ),
                        
                        //Border Style
                        array(
                            'name' => 'team_border_section_style',
                            'label' => esc_html__('Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1']]
                                        ],
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .team-block-two .inner-box:before' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                        
						//Border Style
                        array(
                            'name' => 'team_border_hover_section_style',
                            'label' => esc_html__('Border Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1']]
                                        ],
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .team-block-two .inner-box:hover:before' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                        
                        //Title Style .team-block-two .inner-box:before
                        array(
                            'name' => 'title_bg_color',
                            'label' => esc_html__('Title Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                     [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .gallery-block .inner-box .image .content' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2', 'post-3']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1','team-2']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'product'],
                                            ['name' => 'layout_product', 'operator' => 'in', 'value' => ['product-1']]
                                        ]
                                    ]
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .gallery-block .inner-box .image .overlay-box .content h3 a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .gallery-block .inner-box .image .content h5 a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_hover_color',
                            'label' => esc_html__('Title Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                     [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-3']]
                                        ]
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .gallery-block .inner-box .image .overlay-box .content h3 a:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .services-block-two .inner-box:hover h3 a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .te-title:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2', 'post-3']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1','team-2']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'product'],
                                            ['name' => 'layout_product', 'operator' => 'in', 'value' => ['product-1']]
                                        ]
                                    ]
                                ],
                            ],
                        ),
                        //Text Srtyle
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__('Description Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-text' => 'color: {{VALUE}};',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'product'],
                                            ['name' => 'layout_product', 'operator' => 'in', 'value' => ['product-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-3']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'desc_hover_color',
                            'label' => esc_html__('Description Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                     [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']]
                                        ]
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .services-block-two .inner-box:hover .text' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc_typography',
                            'label' => esc_html__('Description Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-3']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__( 'Icon Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                     [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']]
                                        ]
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .te-icons i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .te-icons span' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .te-icons svg' => 'fill: {{VALUE}};',
                                '{{WRAPPER}} .te-icons svg g' => 'fill: {{VALUE}};',
                            ],
                        ),
                        
                        array(
                            'name' => 'icon_hover_color',
                            'label' => esc_html__( 'Icon Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                     [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']]
                                        ]
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .services-block-two .inner-box:hover .icon-box' => 'color: {{VALUE}};',
                            ],
                        ),
                        
                        array(
                            'name' => 'icon_font_size',
                            'label' => __( 'icon Font Size', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                     [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']]
                                        ]
                                    ],
                                ],
                            ],
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .te-icons i' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .te-icons span' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .te-icons svg' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .te-icons img' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        
                
                        
                        //Button Srtyle
                        array(
                            'name' => 'post_btn_icon_color',
                            'label' => esc_html__('Button Icon Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .news-block-one.update-block .inner-box .lower-content .link-btn a:before' => 'background: {{VALUE}} !important;',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-2']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'post_btn_color1',
                            'label' => esc_html__('Button Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-post-btn' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .news-block-one.update-block .inner-box .lower-content .link-btn a' => 'color: {{VALUE}} !important;',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-2']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        
                        array(
                            'name' => 'portfolio_border_color',
                            'label' => esc_html__('Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .gallery-block .inner-box .image .content .content-inner:before' => 'background-color: {{VALUE}} !important;',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        
                        array(
                            'name' => 'portfolio_button_bg_color',
                            'label' => esc_html__('Button Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .gallery-block .inner-box .image .content .icon' => 'background-color: {{VALUE}} !important;',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        
                        array(
                            'name' => 'portfolio_buton_icon_color',
                            'label' => esc_html__('Button Icon Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .gallery-block .inner-box .image .content .icon' => 'color: {{VALUE}} !important;',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        
                        array(
                            'name' => 'button_typography',
                            'label' => esc_html__('Button Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                            'selector' => '{{WRAPPER}} .btn-style-two',
                        ),
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Button Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_bg_color',
                            'label' => esc_html__('Button Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'button_padding',
                            'label' => esc_html__('Padding', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'button_margin',
                            'label' => esc_html__('Margin', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'button_border_radius',
                            'label' => esc_html__('Border Radius', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name'         => 'button_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                            'selector'     => '{{WRAPPER}} .btn-style-two'
                        ),
                        array(
                            'name' => 'button_border_color',
                            'label' => esc_html__( 'Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .btn-two-outer:before' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .btn-two-outer:after' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),

    

                            array(
                                'name' => 'button_bg_color_hover',
                                'label' => esc_html__('Button Background Color Hover', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                                'selectors' => [
                                    '{{WRAPPER}} .btn-style-two:before' => 'border-bottom: 55px solid {{VALUE}};',
                                    '{{WRAPPER}} .btn-style-two:after' => 'border-bottom: 55px solid {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_color_hover',
                                'label' => esc_html__('Button Color Hover', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                                'selectors' => [
                                    '{{WRAPPER}} .btn-style-two:hover' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_border_color_hover',
                                'label' => esc_html__( 'Border Color Hover', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-3']]
                                        ]
                                    ],
                                ],
                            ],
                                'default' => '',
                                'selectors' => [
                                    '{{WRAPPER}} .btn-two-outer:after' => 'border-color: {{VALUE}} !important;',
                                ],
                                'condition' => [
                                    'button_border_type!' => '',
                                ],
                            ),
                        
                        
                        
                        //Designation Srtyle
                        array(
                            'name' => 'designation_color',
                            'label' => esc_html__('Designation Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-designation' => 'color: {{VALUE}} !important;',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1','team-2']]
                                        ],
                                    ],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'designation_typography',
                            'label' => esc_html__('Designation Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-designation',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'team'],
                                            ['name' => 'layout_team', 'operator' => 'in', 'value' => ['team-1','team-2']]
                                        ],
                                    ],
                                ],
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);