<?php
exp_add_custom_widget(
    array(
        'name' => 'newsletter',
        'title' => esc_html__('Dailyfit NewsLetter', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/mailchimp/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                
				array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'mailchimp_form_code',
							'label' => __( 'MailChimp Form Code', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'dynamic' => [
								'active' => true,
							],
							'default' => __( '', 'dailyfit' ),
							'placeholder' => __( 'Enter your MailChimp Form Code', 'dailyfit' ),
						),
					),
                ),
                
                
				
				
				//Text Style
				array(
					'name' => 'section_style_text',
					'label' => esc_html__('Text', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'form_width',
							'label' => __( 'Width', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 200,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .h-search-form-field' => 'width: {{SIZE}}{{UNIT}};',
							],
						),
						array(
							'name' =>  'bg_form_color',
							'label' => __( 'Background Color', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .h-search-form-inner, {{WRAPPER}} .h-search-form-field:after' => 'background: {{VALUE}};',
							],
						),
						array(
							'name' =>  'form_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .h-search-form-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						),
						array(
							'name' => 'input_title',
							'label' => __( 'Input', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::HEADING,
							'separator' => 'before',
						),
						array(
							'name' =>  'text_form_color',
							'label' => __( 'Color', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .h-search-form-inner input, {{WRAPPER}} .h-search-form-inner ::placeholder' => 'color: {{VALUE}};',
							],
						),
						array(
							'name' => 'border_input_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .h-search-form-inner input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						),
						array(
							'name' => 'border_input_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       =>  \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .h-search-form-inner input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'border_input_border_type',
							'label' => __( 'Border Type', 'dailyfit' ),
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .h-search-form-inner input' => 'border-style: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'border_input_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .h-search-form-inner input' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'border_input_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'border_input_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' =>  \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .h-search-form-inner input' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'border_input_border_type!' => '',
							],
						),
						
					),
				),
				
			),
        ),
    ),
    dailyfit_get_class_widget_path()
);