<?php
//Register Counter Widget
 exp_add_custom_widget(
    array(
        'name' => 'marquee_text',
        'title' => esc_html__('Dailyfit Marquee Text', 'dailyfit'),
        'icon' => 'eicon-counter-circle',
        'categories' => array('exptheme-core'),
        'scripts' => array(
            'exp-counter',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/marquee/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/marquee/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/marquee/layout3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/marquee/layout4.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
						array(
                            'name' => 'slide',
                            'label' => esc_html__('Slide Item', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
							'condition' => [ 'layout' => ['1', '4'] ],
                            'controls' => array(
								array(
									'name' => 'title',
									'label' => esc_html__( 'Title', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
									'default' => esc_html__( 'Smart', 'dailyfit' ),
								),
								array(
                                    'name' => 'link_option',
                                    'label'   => esc_html__( 'Select link Option', 'dailyfit' ),
                                    'label_block' => true,
                                    'type'    => \Elementor\Controls_Manager::SELECT,
                                    'default' => 'extranal',
                                    'options' => array(
                                        'extranal' => esc_html__( 'Extranal ', 'dailyfit'),
                                        'page' => esc_html__( 'Page ', 'dailyfit'),
                                    ),
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => __( 'External Link', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true, 
                                    'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
                                    'show_external' => true,
                                    'default' => [
                                        'url' => '',
                                        'is_external' => true,
                                        'nofollow' => true,
                                    ],
                                    'condition'   => [
                                        'link_option' => 'extranal'
                                    ]
                                ),
                                array(
                                    'name' => 'page_select',
                                    'label' => esc_html__('Select Page', 'dailyfit' ),
                                    'label_block' => true, 
                                    'type' => \Elementor\Controls_Manager::SELECT2,
                                    'default' => 'extranal',
                                    'options' => dailyfit_page_list(),
                                    'condition'   => [
                                        'link_option' => 'page'
                                    ]
                                ),								
							),
						),
                        
                        array(
                            'name' => 'slide_v2',
                            'label' => esc_html__('Slide Item', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
							'condition' => [ 'layout' => ['2'] ],
                            'controls' => array(
								array(
									'name' => 'title',
									'label' => esc_html__( 'Title', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
									'default' => esc_html__( 'Smart', 'dailyfit' ),
								),
                                array(
									'name' => 'text',
									'label' => esc_html__( 'Text', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
									'default' => esc_html__( 'Smart', 'dailyfit' ),
								),
								array(
                                    'name' => 'link_option',
                                    'label'   => esc_html__( 'Select link Option', 'dailyfit' ),
                                    'label_block' => true,
                                    'type'    => \Elementor\Controls_Manager::SELECT,
                                    'default' => 'extranal',
                                    'options' => array(
                                        'extranal' => esc_html__( 'Extranal ', 'dailyfit'),
                                        'page' => esc_html__( 'Page ', 'dailyfit'),
                                    ),
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => __( 'External Link', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true, 
                                    'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
                                    'show_external' => true,
                                    'default' => [
                                        'url' => '',
                                        'is_external' => true,
                                        'nofollow' => true,
                                    ],
                                    'condition'   => [
                                        'link_option' => 'extranal'
                                    ]
                                ),
                                array(
                                    'name' => 'page_select',
                                    'label' => esc_html__('Select Page', 'dailyfit' ),
                                    'label_block' => true, 
                                    'type' => \Elementor\Controls_Manager::SELECT2,
                                    'default' => 'extranal',
                                    'options' => dailyfit_page_list(),
                                    'condition'   => [
                                        'link_option' => 'page'
                                    ]
                                ),								
							),
						),
                        
                        array(
                            'name' => 'slide_v3',
                            'label' => esc_html__('Slide Item', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
							'condition' => [ 'layout' => ['3'] ],
                            'controls' => array(
								array(
									'name' => 'title',
									'label' => esc_html__( 'Title', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
									'default' => esc_html__( 'Smart', 'dailyfit' ),
								),                                								
							),
						),
					),
				),
                
                array(
                    'name' => 'general_section',
                    'label' => esc_html__('General Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'general_bg_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .dailyfit-section' => 'background-color: {{VALUE}};',
                            ],
                        ),                        
                        
                    ),
                ),
                
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .te-title:hover a' => 'color: {{VALUE}};',
                            ],
                        ),                        
                    ),
                ),
                
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);