( function( $ ) {
    
    var exp_swiper_handler = function( $scope, $ ) {
 
        var breakpoints = elementorFrontend.config.breakpoints,
            carousel = $scope.find(".exp-swiper-container");
        if(carousel.length == 0){
            return false;
        }

        /* Arrow Custom */
        $('.exp-swiper-arrow-custom').parents('.exp-swiper-sliders').addClass('exp--hide-arrow');
        $('.exp-navigation-carousel').parents('.elementor-section').addClass('exp--hide-arrow');
        setTimeout(function() {
            $('.exp-swiper-arrow-custom.exp-swiper-arrow-next').on('click', function () {
                $(this).parents('.exp-swiper-sliders').find('.exp-swiper-arrow-main.exp-swiper-arrow-next').trigger('click');
            });
            $('.exp-swiper-arrow-custom.exp-swiper-arrow-prev').on('click', function () {
                $(this).parents('.exp-swiper-sliders').find('.exp-swiper-arrow-main.exp-swiper-arrow-prev').trigger('click');
            });
        }, 300);

        setTimeout(function() {
            $('.exp-navigation-carousel .exp-navigation-arrow-prev').on('click', function () {
                $(this).parents('.elementor-section').find('.exp-swiper-arrow.exp-swiper-arrow-prev').trigger('click');
            });
            $('.exp-navigation-carousel .exp-navigation-arrow-next').on('click', function () {
                $(this).parents('.elementor-section').find('.exp-swiper-arrow.exp-swiper-arrow-next').trigger('click');
            });
        }, 300);

        /* Main Slider */
        var data = carousel.data(), 
            settings = data.settings, 
            carousel_settings = {
                direction: settings['slide_direction'],
                effect: settings['slide_mode'],
                wrapperClass : 'exp-swiper-wrapper',
                slideClass: 'exp-swiper-slide',
                slidesPerView: settings['slides_to_show'],
                slidesPerGroup: settings['slides_to_scroll'],
                slidesPerColumn: settings['slide_percolumn'],
                spaceBetween: 0,
                navigation: {
                    nextEl: $scope.find(".exp-swiper-arrow-next"),
                    prevEl: $scope.find(".exp-swiper-arrow-prev"),
                },
                pagination : {
                    el: $scope.find(".exp-swiper-dots"),
                    clickable : true,
                    modifierClass: 'exp-swiper-pagination-',
                    bulletClass : 'exp-swiper-pagination-bullet',
                    renderCustom: function (swiper, element, current, total) {
                        return current + ' of ' + total;
                    },
                    type: settings['pagination_type'],
                },
                speed: settings['speed'],
                watchSlidesProgress: true,
                watchSlidesVisibility: true,
                breakpoints: {
                    0 : {
                        slidesPerView: settings['slides_to_show_xs'],
                        slidesPerGroup: settings['slides_to_scroll'],
                    },
                    576 : {
                        slidesPerView: settings['slides_to_show_sm'],
                        slidesPerGroup: settings['slides_to_scroll'],
                    },
                    768 : {
                        slidesPerView: settings['slides_to_show_md'],
                        slidesPerGroup: settings['slides_to_scroll'],
                    },
                    1025 : {
                        slidesPerView: settings['slides_to_show_lg'],
                        slidesPerGroup: settings['slides_to_scroll'],
                    },
                    1200 : {
                        slidesPerView: settings['slides_to_show'],
                        slidesPerGroup: settings['slides_to_scroll'],
                    },
                    1600 : {
                        slidesPerView: settings['slides_to_show_xxl'],
                        slidesPerGroup: settings['slides_to_scroll'],
                    }
                }
            }; 
            // center
            if(settings['center'] === 'true'){
                carousel_settings['centeredSlides'] = true;
            }
            // effect
            if(settings['slide_mode'] === 'fade'){
                carousel_settings['fadeEffect'] = {
                    crossFade: true
                };
            }
            // loop
            if(settings['loop'] === 'true'){
                carousel_settings['loop'] = true;
            }
            // auto play
            if(settings['autoplay'] === 'true'){
                carousel_settings['autoplay'] = {
                    delay : settings['delay'],
                    disableOnInteraction : settings['pause_on_interaction']
                };
            } else {
                carousel_settings['autoplay'] = false;
            }
            
        carousel.each(function(index, element) {

            var carousel_thumb = $scope.find(".exp-swiper-thumbs");
            var center = $scope.find(".exp-swiper-thumbs").data("center");
            var loop = $scope.find(".exp-swiper-thumbs").data("loop");
            var thumbxs = $scope.find(".exp-swiper-thumbs").data("thumbxs");
            var thumbsm = $scope.find(".exp-swiper-thumbs").data("thumbsm");
            var thumbmd = $scope.find(".exp-swiper-thumbs").data("thumbmd");
            var thumblg = $scope.find(".exp-swiper-thumbs").data("thumblg");
            if (carousel_thumb.length > 0) {
                var galleryThumbs = new Swiper(carousel_thumb, {
                    spaceBetween: 0,
                    slidesPerView: 3,
                    freeMode: true,
                    watchSlidesProgress: true,
                    centeredSlides: center,
                    loop: loop,
                    breakpoints: {
                        0 : {
                            slidesPerView: typeof thumbxs !== 'undefined' ? thumbxs : 1,
                        },
                        576 : {
                            slidesPerView: typeof thumbsm !== 'undefined' ? thumbsm : 2,
                        },
                        768 : {
                            slidesPerView: typeof thumbmd !== 'undefined' ? thumbmd : 3,
                        },
                        1025 : {
                            slidesPerView: typeof thumblg !== 'undefined' ? thumblg : 3,
                        },
                    }
                });
                carousel_settings['thumbs'] = { swiper: galleryThumbs };
            }
           
            var swiper = new Swiper(carousel, carousel_settings);
             
            if(settings['autoplay'] === 'true' && settings['pause_on_hover'] === 'true'){
                $(this).on({
                  mouseenter: function mouseenter() {
                    this.swiper.autoplay.stop();
                  },
                  mouseleave: function mouseleave() {
                    this.swiper.autoplay.start();
                  }
                });
            }

            $scope.find(".swiper-filter-wrap .filter-item").on("click", function(){
                var target = $(this).attr('data-filter-target');
                var parent = $(this).closest('.exp-swiper-sliders');
                $(this).siblings().removeClass("active");
                $(this).addClass("active");

                if(target == "all"){
                    parent.find("[data-filter]").removeClass("non-swiper-slide").addClass("swiper-slide-filter");
                    swiper.destroy();
                    swiper = new Swiper(carousel, carousel_settings);
                } else {
                     
                    parent.find(".swiper-slide-filter").not("[data-filter^='"+target+"'], [data-filter*=' "+target+"']").addClass("non-swiper-slide").removeClass("swiper-slide-filter");
                    parent.find("[data-filter^='"+target+"'], [data-filter*=' "+target+"']").removeClass("non-swiper-slide").addClass("swiper-slide-filter");
                    swiper.destroy();
                    swiper = new Swiper(carousel, carousel_settings);
                }
            });

            $('.swiper-filter-wrap').parents('.exp-swiper-sliders').addClass('swiper-filter-active');

        });

    };

    // Make sure you run this code under Elementor.
    $( window ).on( 'elementor/frontend/init', function() {
        // Swipers
        elementorFrontend.hooks.addAction( 'frontend/element_ready/post_carousel.default', exp_swiper_handler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/clients.default', exp_swiper_handler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/banner_carousel.default', exp_swiper_handler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel.default', exp_swiper_handler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/team_carousel.default', exp_swiper_handler );
    } );
} )( jQuery );