<?php

exp_add_custom_widget(
    array(
        'name' => 'gym_table',
        'title' => esc_html__('Dailyfit Gym Table', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/gym_table/layout-1.png'
                                ],
                            ],
                        ),
                    ),
                ),
                
                
                array(
                    'name' => 'tab_display',
                    'label' => esc_html__('Display', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'views',
                            'label' => esc_html__('Tabs Style', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'dropdown_list' => 'Dropdown List',
                                'tabs' => 'Tabs',
                            ],
                            'default' => 'tabs',
                        ),
                        array(
                            'name' => 'show_time',
                            'label' => esc_html__('Show Time', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'show_responsive',
                            'label' => esc_html__('Show Responsive', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_colro_scheme',
                    'label' => esc_html__('Color Scheme', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'main_bg_color',
                            'label' => esc_html__('Select Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .mptt-shortcode-wrapper .mptt-navigation-tabs li a'        => 'background-color: {{VALUE}};',
                                '{{WRAPPER}} .mptt-shortcode-hours'                                     => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'main_border_color',
                            'label' => esc_html__('Select Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .mptt-shortcode-wrapper .mptt-navigation-tabs li a'        => 'border-left: 3px solid {{VALUE}};',
                                '{{WRAPPER}} .mptt-shortcode-wrapper .mptt-navigation-tabs li.active a' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .mptt-shortcode-wrapper .mptt-navigation-tabs li:hover a'  => 'border-color: {{VALUE}}',
                                '{{WRAPPER}} .mptt-shortcode-wrapper .mptt-navigation-tabs li a:before' => 'border-left: 8px solid {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);