<?php
//Register Counter Widget
 exp_add_custom_widget(
    array(
        'name' => 'funfacts',
        'title' => esc_html__('Dailyfit Funfacts', 'dailyfit'),
        'icon' => 'eicon-counter-circle',
        'categories' => array('exptheme-core'),
        'scripts' => array(
            'dailyfit-funfacts',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/counter/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/counter/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
						//Funfacts V1
						array(
                            'name' => 'funfact',
                            'label' => esc_html__('Funfact', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
							'condition' => [ 'layout' => ['1'] ],
                            'controls' => array(
								array(
									'name' => 'exp_animate_delay',
									'label' => esc_html__( 'Post Delay Time', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
									'default' => esc_html__( '100', 'dailyfit' ),
								),
								array(
        							'name' => 'icon_type',
        							'label' => esc_html__('Icon Type', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::SELECT,
        							'options' => [
        								'icon' => 'Icon',
        								'image' => 'Image',
        							],
        							'default' => 'icon',
        						),
        						array(
        							'name' => 'exp_icon',
        							'label' => esc_html__('Icon', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::ICONS,
        							'fa4compatibility' => 'icon',
        							'condition' => [
        								'icon_type' => 'icon',
        							],
        						),
        						array(
        							'name' => 'icon_image',
        							'label' => esc_html__( 'Icon Image', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::MEDIA,
        							'description' => esc_html__('Select image icon.', 'dailyfit'),
        							'condition' => [
        								'icon_type' => 'image',
        							],
        						),
								array(
									'name' => 'start_number',
									'label' => esc_html__('Start Number', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::NUMBER,
									'default' => 0,
								),
								array(
									'name' => 'ending_number',
									'label' => esc_html__('Ending Number', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::NUMBER,
									'default' => 14,
								),
								array(
									'name' => 'title',
									'label' => esc_html__('Title', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::TEXTAREA,
									'label_block' => true,
								),
							),
						),
						
						//Funfacts V2
						array(
                            'name' => 'funfact_v2',
                            'label' => esc_html__('Funfact', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
							'condition' => [ 'layout' => ['2'] ],
                            'controls' => array(
								array(
									'name' => 'exp_animate_delay',
									'label' => esc_html__( 'Post Delay Time', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
									'default' => esc_html__( '1500', 'dailyfit' ),
								),
								array(
        							'name' => 'icon_type',
        							'label' => esc_html__('Icon Type', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::SELECT,
        							'options' => [
        								'icon' => 'Icon',
        								'image' => 'Image',
        							],
        							'default' => 'icon',
        						),
        						array(
        							'name' => 'exp_icon',
        							'label' => esc_html__('Icon', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::ICONS,
        							'fa4compatibility' => 'icon',
        							'condition' => [
        								'icon_type' => 'icon',
        							],
        						),
        						array(
        							'name' => 'icon_image',
        							'label' => esc_html__( 'Icon Image', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::MEDIA,
        							'description' => esc_html__('Select image icon.', 'dailyfit'),
        							'condition' => [
        								'icon_type' => 'image',
        							],
        						),
								array(
									'name' => 'start_number',
									'label' => esc_html__('Start Number', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::NUMBER,
									'default' => 0,
								),
								array(
									'name' => 'ending_number',
									'label' => esc_html__('Ending Number', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::NUMBER,
									'default' => 120,
								),
								array(
									'name' => 'title',
									'label' => esc_html__('Title', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::TEXTAREA,
									'label_block' => true,
								),
							),
						),
						
					),
				),
                
                array(
                    'name' => 'general_section',
                    'label' => esc_html__('General', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'main_bg_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .counter-section-two .color-layer' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'main_space_bottom',
                            'label'      => esc_html__( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
                            'selectors' => [
                                '{{WRAPPER}} .counter-section-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'main_space_paddings',
                            'label'      => esc_html__( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
                            'selectors' => [
                                '{{WRAPPER}} .counter-section-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'after',
                        ),
                    ),
                ),
                
                //Icon Style
				array(
                    'name' => 'section_style',
                    'label' => esc_html__('Icon Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'condition' => [ 'layout' => ['1','2'] ],
                    'controls' => array(
                        array(
                            'name' => 'icon_bg_color',
							'label' => esc_html__( 'Icon BG Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'background-color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_color',
							'label' => esc_html__( 'Icon Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-icons i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .te-icons svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .te-icons svg g' => 'fill: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_hover_color',
							'label' => esc_html__( 'Icon Hover Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .fact-counter-two .column .inner:hover .te-icons i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .fact-counter-two .column .inner:hover .te-icons svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .fact-counter-two .column .inner:hover .te-icons svg g' => 'fill: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_font_size',
							'label' => __( 'icon Font Size', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .te-icons i' => 'font-size: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .te-icons svg' => 'width: {{SIZE}}{{UNIT}};'
							],
						),
						array(
							'name' => 'icon_border_type',
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-style: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'icon_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'icon_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'icon_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'icon_border_type!' => '',
							],
						),
						array(
							'name' => 'icon_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
						),
					),
                ),
                
				array(
                    'name' => 'section_number',
                    'label' => esc_html__('Number', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'number_bg_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-number' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'number_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-number' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'number_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-number',
                        ),
                    ),
                ),
                
				array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                    ),
                ),
                
                
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);