<?php
exp_add_custom_widget(
    array(
        'name' => 'float_image',
        'title' => esc_html__('Dailyfit Float Image', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/float_image/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/float_image/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/float_image/layout3.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        //Award Image V2
						array(
                            'name' => 'award_img',
                            'label' => __( 'Choose Award Image', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
							'condition'   => [
								'layout' => ['3']
							]
                        ),
                        
						//Feature Image V1
						array(
                            'name' => 'feature_img',
                            'label' => __( 'Choose Image', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        
						//Feature Image V2
						array(
                            'name' => 'feature_img_v2',
                            'label' => __( 'Choose Image V2', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
							'condition'   => [
								'layout' => ['1','2']
							]
                        ),
                        //Feature Image V3
						array(
                            'name' => 'feature_img_v3',
                            'label' => __( 'Choose Image V3', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
							'condition'   => [
								'layout' => ['1','2']
							]
                        ),
						//Feature Image V4
						array(
                            'name' => 'feature_img_v4',
                            'label' => __( 'Choose Image V4', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
							'condition'   => [
								'layout' => ['2']
							]
                        ),
					),
                ),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);