<?php
exp_add_custom_widget(
    array(
        'name' => 'et_search_form',
        'title' => esc_html__('Dailyfit Search Form', 'dailyfit' ),
        'icon' => 'eicon-site-search',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'wg_title',
                            'label' => esc_html__('Widget Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'placefolder',
                            'label' => esc_html__('Placefolder', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'button_bg_color',
							'label' => esc_html__( 'Button BG Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-search-form1 .search-submit' => 'background-color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'button_hover_color',
							'label' => esc_html__( 'Button Hover Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-search-form1 .search-submit:hover' => 'background-color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'form_border_color',
                            'label' => esc_html__( 'Form Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .exp-search-form1 .search-field' => 'border: 1px solid {{VALUE}};',
                            ],
                        ),
						array(
                            'name' => 'icon_color',
							'label' => esc_html__( 'Icon Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-search-form1 .search-submit i' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_hover_color',
							'label' => esc_html__( 'Icon Hover Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-search-form1 .search-submit:hover i' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_font_size',
							'label' => __( 'icon Font Size', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .exp-search-form1 .search-submit i' => 'font-size: {{SIZE}}{{UNIT}};',
							],
						),
					),
                ),
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);