<?php
//Register Counter Widget
 exp_add_custom_widget(
    array(
        'name' => 'download_brochures',
        'title' => esc_html__('Dailyfit Download Brochures', 'dailyfit'),
        'icon' => 'eicon-counter-circle',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/download_brochures/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
						array(
                            'name' => 'download',
                            'label' => esc_html__('Download Items', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
							'condition' => [ 'layout' => ['1'] ],
                            'controls' => array(								
								array(
									'name' => 'icon_type',
									'label' => esc_html__('Icon Type', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::SELECT,
									'options' => [
										'icon' => 'Icon',
										'image' => 'Image',
									],
									'default' => 'icon',
								),
								array(
									'name' => 'exp_icon',
									'label' => esc_html__('Icon', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::ICONS,
									'fa4compatibility' => 'icon',
									'condition' => [
										'icon_type' => 'icon',
									],
								),
								array(
									'name' => 'icon_image',
									'label' => esc_html__( 'Icon Image', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::MEDIA,
									'description' => esc_html__('Select image icon.', 'dailyfit'),
									'condition' => [
										'icon_type' => 'image',
									],
								),
								array(
									'name' => 'title',
									'label' => esc_html__('Title', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
								),
								array(
									'name' => 'link',
									'label' => esc_html__('Link', 'dailyfit'),
									'type' => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
								),
							),
						),                        
					),
				),
                
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                    ),
                ),
                
                //Icon Style
				array(
                    'name' => 'section_style',
                    'label' => esc_html__('Icon Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [ 'layout' => ['1'] ],
                    'controls' => array(
                        array(
                            'name' => 'icon_bg_color',
							'label' => esc_html__( 'Icon BG Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'background-color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_color',
							'label' => esc_html__( 'Icon Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-icons i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .te-icons span' => 'color: {{VALUE}};',
								'{{WRAPPER}} .te-icons svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .te-icons svg g' => 'fill: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_font_size',
							'label' => __( 'icon Font Size', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .te-icons i' => 'font-size: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .te-icons span' => 'font-size: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .te-icons svg' => 'width: {{SIZE}}{{UNIT}};'
							],
						),
						array(
							'name' => 'icon_border_type',
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-style: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'icon_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'icon_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'icon_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'icon_border_type!' => '',
							],
						),
						array(
							'name' => 'icon_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
						),
					),
                ),
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);