<?php
if(class_exists('WPCF7')) {
    $cf7 = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');

    $contact_forms = array();
    if ($cf7) {
        foreach ($cf7 as $cform) {
            $contact_forms[$cform->ID] = $cform->post_title;
        }
    } else {
        $contact_forms[esc_html__('No contact forms found', 'dailyfit')] = 0;
    }

    exp_add_custom_widget(
        array(
            'name' => 'contact_form',
            'title' => esc_html__('Dailyfit Contact Form', 'dailyfit'),
            'icon' => 'eicon-form-horizontal',
            'categories' => array('exptheme-core'),
            'params' => array(
                'sections' => array(
                    array(
                        'name' => 'tab_layout',
                        'label' => esc_html__('Layout', 'dailyfit' ),
                        'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                        'controls' => array(
                            array(
                                'name' => 'layout',
                                'label' => esc_html__('Templates', 'dailyfit' ),
                                'type' => 'layoutcontrol',
                                'default' => '1',
                                'options' => [
                                    '1' => [
                                        'label' => esc_html__('Layout 1', 'dailyfit' ),
                                        'image' => get_template_directory_uri() . '/elements/widgets/img-layout/contact/layout1.jpg'
                                    ],
                                    '2' => [
                                        'label' => esc_html__('Layout 2', 'dailyfit' ),
                                        'image' => get_template_directory_uri() . '/elements/widgets/img-layout/contact/layout2.jpg'
                                    ],
                                ],
                            ),
                        ),
                    ),
                    
                    array(
                        'name' => 'tab_content',
                        'label' => esc_html__('Content', 'dailyfit'),
                        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                        'controls' => array(
                            array(
                                'name' => 'form_id',
                                'label' => esc_html__('Select Form', 'dailyfit'),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => $contact_forms,
                            ),
                        ),
                    ),
                    array(
                        'name' => 'tab_style_input',
                        'label' => esc_html__('Input', 'dailyfit'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'input_typography',
                                'label' => esc_html__('Typography', 'dailyfit' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .exp-contact-form .exp-select-higthlight, {{WRAPPER}} .exp-select .exp-select-options li',
                            ),
                            array(
                                'name' => 'input_color',
                                'label' => esc_html__('Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .exp-contact-form .exp-select-higthlight, {{WRAPPER}} .exp-select .exp-select-options li' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'input_bg_color',
                                'label' => esc_html__('Background Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .exp-contact-form .exp-select-higthlight' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'input_padding',
                                'label' => esc_html__('Padding Input', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):not(.wpcf7-textarea), {{WRAPPER}} .exp-contact-form .exp-select-higthlight' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name' => 'input_border_radius',
                                'label' => esc_html__('Border Radius', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .exp-contact-form .exp-select-higthlight' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name'         => 'input_box_shadow',
                                'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                                'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                                'control_type' => 'group',
                                'selector'     => '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .exp-contact-form .exp-select-higthlight'
                            ),
                            array(
                                'name' => 'border_type',
                                'label' => esc_html__( 'Border Type', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    '' => esc_html__( 'None', 'dailyfit' ),
                                    'solid' => esc_html__( 'Solid', 'dailyfit' ),
                                    'double' => esc_html__( 'Double', 'dailyfit' ),
                                    'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
                                    'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
                                    'groove' => esc_html__( 'Groove', 'dailyfit' ),
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):not(.wpcf7-acceptance), {{WRAPPER}} .exp-contact-form .exp-select-higthlight' => 'border-style: {{VALUE}} !important;',
                                ],
                            ),
                            array(
                                'name' => 'border_width',
                                'label' => esc_html__( 'Border Width', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .exp-contact-form .exp-select-higthlight' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                                ],
                                'condition' => [
                                    'border_type!' => '',
                                ],
                                'responsive' => true,
                            ),
                            array(
                                'name' => 'border_color',
                                'label' => esc_html__( 'Border Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'default' => '',
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .exp-contact-form .exp-select-higthlight' => 'border-color: {{VALUE}} !important;',
                                ],
                                'condition' => [
                                    'border_type!' => '',
                                ],
                            ),
                            array(
                                'name' => 'input_height',
                                'label' => esc_html__('Input Height', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 300,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):not(.wpcf7-textarea), {{WRAPPER}} .exp-contact-form .exp-select-higthlight' => 'height: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'textarea_height',
                                'label' => esc_html__('Textarea Height', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control.wpcf7-textarea' => 'height: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'textarea_padding',
                                'label' => esc_html__('Padding Textarea', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control.wpcf7-textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name' => 'textarea_border_type',
                                'label' => esc_html__( 'Textarea Border Type', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    '' => esc_html__( 'None', 'dailyfit' ),
                                    'solid' => esc_html__( 'Solid', 'dailyfit' ),
                                    'double' => esc_html__( 'Double', 'dailyfit' ),
                                    'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
                                    'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
                                    'groove' => esc_html__( 'Groove', 'dailyfit' ),
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control.wpcf7-textarea' => 'border-style: {{VALUE}} !important;',
                                ],
                            ),
                            array(
                                'name' => 'textarea_border_width',
                                'label' => esc_html__( 'Textarea Border Width', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control.wpcf7-textarea' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                                ],
                                'condition' => [
                                    'textarea_border_type!' => '',
                                ],
                                'responsive' => true,
                            ),
                             array(
                                'name' => 'textarea_border_color',
                                'label' => esc_html__('Textarea Border Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control.wpcf7-textarea' => 'border-color: {{VALUE}};',
                                ],
                                'condition' => [
                                    'textarea_border_type!' => '',
                                ],
                                'responsive' => true,
                            ),
                            array(
                                'name' => 'textarea_typography',
                                'label' => esc_html__('Textarea Typography', 'dailyfit' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .exp-contact-form .wpcf7-form-control.wpcf7-textarea',
                            ),
                            array(
                                'name' => 'textarea_color',
                                'label' => esc_html__('Textarea Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control.wpcf7-textarea' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'input_spacer_bottom',
                                'label' => esc_html__('Spacer Bottom', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control-wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                        ),
                    ),
                    array(
                        'name' => 'tab_style_input_hover',
                        'label' => esc_html__('Input Hover', 'dailyfit'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'input_color_hover',
                                'label' => esc_html__('Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):hover, {{WRAPPER}} .exp-contact-form .exp-select-options li, {{WRAPPER}} .exp-contact-form .exp-select-higthlight:hover, {{WRAPPER}} .exp-contact-form .exp-select-higthlight.active' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'input_bg_color_hover',
                                'label' => esc_html__('Background Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):hover' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name'         => 'input_box_shadow_hover',
                                'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                                'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                                'control_type' => 'group',
                                'selector'     => '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):hover'
                            ),
                            array(
                                'name' => 'border_type_hover',
                                'label' => esc_html__( 'Border Type', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    '' => esc_html__( 'None', 'dailyfit' ),
                                    'solid' => esc_html__( 'Solid', 'dailyfit' ),
                                    'double' => esc_html__( 'Double', 'dailyfit' ),
                                    'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
                                    'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
                                    'groove' => esc_html__( 'Groove', 'dailyfit' ),
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):hover, {{WRAPPER}} .exp-contact-form .exp-select-higthlight:hover' => 'border-style: {{VALUE}} !important;',
                                ],
                            ),
                            array(
                                'name' => 'border_width_hover',
                                'label' => esc_html__( 'Border Width', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):hover, {{WRAPPER}} .exp-contact-form .exp-select-higthlight:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                                ],
                                'condition' => [
                                    'border_type_hover!' => '',
                                ],
                                'responsive' => true,
                            ),
                            array(
                                'name' => 'border_color_hover',
                                'label' => esc_html__( 'Border Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'default' => '',
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-form-control:not(.wpcf7-submit):hover, {{WRAPPER}} .exp-contact-form .exp-select-higthlight:hover' => 'border-color: {{VALUE}} !important;',
                                ],
                                'condition' => [
                                    'border_type_hover!' => '',
                                ],
                            ),
                        ),
                    ),
                    array(
                        'name' => 'tab_style_button',
                        'label' => esc_html__('Button', 'dailyfit'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'btn_style',
                                'label' => esc_html__( 'Style', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'button-style1' => 'Style 1',
                                    'button-style2' => 'Style 2',
                                ],
                                'default' => 'button-style1',
                            ),
                            array(
                                'name' => 'button_typography',
                                'label' => esc_html__('Button Typography', 'dailyfit' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .exp-contact-form .wpcf7-submit, {{WRAPPER}} .exp-contact-form button',
                            ),
                            array(
                                'name' => 'button_color',
                                'label' => esc_html__('Button Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit' => 'color: {{VALUE}};',
                                    '{{WRAPPER}} .exp-contact-form button .txt' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_color_hover',
                                'label' => esc_html__('Button Color Hover', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit:hover, {{WRAPPER}} .exp-contact-form .wpcf7-submit:focus' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_bg_color',
                                'label' => esc_html__('Button Background Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit' => 'background: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_bg_color_hover',
                                'label' => esc_html__('Button Background Color Hover', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit:hover, {{WRAPPER}} .exp-contact-form .wpcf7-submit:focus' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_padding',
                                'label' => esc_html__('Padding', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit, {{WRAPPER}} .exp-contact-form button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name' => 'button_margin',
                                'label' => esc_html__('Margin', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit, {{WRAPPER}} .exp-contact-form button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name' => 'button_border_radius',
                                'label' => esc_html__('Border Radius', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit, {{WRAPPER}} .exp-contact-form button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name'         => 'button_box_shadow',
                                'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                                'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                                'control_type' => 'group',
                                'selector'     => '{{WRAPPER}} .exp-contact-form .wpcf7-submit, {{WRAPPER}} .exp-contact-form button'
                            ),
                            array(
                                'name' => 'button_border_type',
                                'label' => esc_html__( 'Border Type', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    '' => esc_html__( 'None', 'dailyfit' ),
                                    'solid' => esc_html__( 'Solid', 'dailyfit' ),
                                    'double' => esc_html__( 'Double', 'dailyfit' ),
                                    'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
                                    'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
                                    'groove' => esc_html__( 'Groove', 'dailyfit' ),
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit' => 'border-style: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_border_width',
                                'label' => esc_html__( 'Border Width', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'condition' => [
                                    'button_border_type!' => '',
                                ],
                                'responsive' => true,
                            ),
                            array(
                                'name' => 'button_border_color',
                                'label' => esc_html__( 'Border Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'default' => '',
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit' => 'border-color: {{VALUE}};',
                                ],
                                'condition' => [
                                    'button_border_type!' => '',
                                ],
                            ),
                            array(
                                'name' => 'btn_width',
                                'label' => esc_html__( 'Width', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'btn-w-auto' => 'Auto',
                                    'btn-w-full' => '100%',
                                ],
                                'default' => 'btn-w-auto',
                            ),
                            array(
                                'name' => 'btn_spacer_top',
                                'label' => esc_html__('Spacer Top', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .wpcf7-submit' => 'margin-top: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                        ),
                    ),
                    array(
                        'name' => 'tab_box',
                        'label' => esc_html__('Box', 'dailyfit'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'box_style',
                                'label' => esc_html__( 'Style', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'box-style-none' => 'None',
                                    'box-style-white' => 'Box White',
                                ],
                                'default' => 'box-style-none',
                            ),
                            array(
                                'name' => 'title',
                                'label' => esc_html__('Title', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'box_title_typography',
                                'label' => esc_html__('Title Typography', 'dailyfit' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .exp-contact-form .exp-contact-meta h5',
                            ),
                            array(
                                'name' => 'box_title_color',
                                'label' => esc_html__('Title Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .exp-contact-meta h5' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'box_title_spacer_bottom',
                                'label' => esc_html__('Title Spacer Bottom', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .exp-contact-meta h5' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'desc',
                                'label' => esc_html__('Description', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::TEXTAREA,
                                'rows' => 10,
                                'show_label' => false,
                            ),
                            array(
                                'name' => 'box_desc_typography',
                                'label' => esc_html__('Description Typography', 'dailyfit' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .exp-contact-form .exp-contact-meta p',
                            ),
                            array(
                                'name' => 'box_desc_color',
                                'label' => esc_html__('Description Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .exp-contact-meta p' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'box_border_radius',
                                'label' => esc_html__('Border Radius', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name'         => 'box_box_shadow',
                                'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                                'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                                'control_type' => 'group',
                                'selector'     => '{{WRAPPER}} .exp-contact-form'
                            ),
                            array(
                                'name' => 'box_padding',
                                'label' => esc_html__('Padding', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                        ),
                    ),
                    dailyfit_widget_animation_settings(),
                    array(
                        'name' => 'extra',
                        'label' => esc_html__('Extra', 'dailyfit'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'label_color',
                                'label' => esc_html__('Label Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .exp--item > label' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'label_typography',
                                'label' => esc_html__('Label Typography', 'dailyfit' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .exp-contact-form .exp--item > label',
                            ),
                            array(
                                'name' => 'label_spacer_bottom',
                                'label' => esc_html__('Label Spacer Bottom', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .exp--item > label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'icon_color',
                                'label' => esc_html__('Icon Color', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .exp--form-icon' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'icon_space',
                                'label' => esc_html__('Icon Spacer', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .exp-contact-form .exp--form-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name' => 'notification_form',
                                'label' => esc_html__( 'Notification Form', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'notice-style1' => 'Style 1',
                                    'notice-style2' => 'Style 2 (Fixed Bottom)',
                                ],
                                'default' => 'notice-style1',
                            ),
                        ),
                    ),
                ),
            ),
        ),
        dailyfit_get_class_widget_path()
    );
}