<?php
exp_add_custom_widget(
    array(
        'name' => 'button',
        'title' => esc_html__('Dailyfit Button', 'dailyfit' ),
        'icon' => 'eicon-button',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/button/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'align',
                            'label' => esc_html__('Alignment', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left'    => [
                                    'title' => esc_html__('Left', 'dailyfit' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'dailyfit' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'dailyfit' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                            ],
                            'prefix_class' => 'elementor-align-',
                            'default' => '',
                            'selectors'         => [
                                '{{WRAPPER}} .exp-button' => 'text-align: {{VALUE}}',
                            ],
                        ),
                        array(
                            'name' => 'btn_title',
                            'label' => esc_html__('Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Click Here', 'dailyfit'),
                        ),
                        array(
                            'name' => 'link_option',
                            'label'   => esc_html__( 'Select link Option', 'dailyfit' ),
                            'label_block' => true,
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'extranal',
                            'options' => array(
                                'extranal' => esc_html__( 'Extranal ', 'dailyfit'),
                                'page' => esc_html__( 'Page ', 'dailyfit'),
                            ),
                        ),
                        array(
                            'name' => 'link',
                            'label' => __( 'External Link', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true, 
                            'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
                            'show_external' => true,
                            'default' => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                            'condition'   => [
                                'link_option' => 'extranal'
                            ]
                        ),
                        array(
                            'name' => 'page_select',
                            'label' => esc_html__('Select Page', 'dailyfit' ),
                            'label_block' => true, 
                            'type' => \Elementor\Controls_Manager::SELECT2,
                            'default' => 'extranal',
                            'options' => dailyfit_page_list(),
                            'condition'   => [
                                'link_option' => 'page'
                            ]
                        ),
                                                
                    ),
                ),

                array(
                    'name' => 'tab_style_button',
                    'label' => esc_html__('Button', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'button_typography',
                            'label' => esc_html__('Button Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .btn-style-two',
                        ),
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Button Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_bg_color',
                            'label' => esc_html__('Button Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'button_padding',
                            'label' => esc_html__('Padding', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'button_margin',
                            'label' => esc_html__('Margin', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'button_border_radius',
                            'label' => esc_html__('Border Radius', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name'         => 'button_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .btn-style-two'
                        ),
                        array(
                            'name' => 'button_border_color',
                            'label' => esc_html__( 'Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .btn-two-outer:before' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .btn-two-outer:after' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style_button_hover',
                    'label' => esc_html__('Button Hover', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'button_bg_color_hover',
                            'label' => esc_html__('Button Background Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two:before' => 'border-bottom: 55px solid {{VALUE}};',
                                '{{WRAPPER}} .btn-style-two:after' => 'border-bottom: 55px solid {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_color_hover',
                            'label' => esc_html__('Button Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_border_color_hover',
                            'label' => esc_html__( 'Border Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .btn-two-outer:after' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'button_border_type!' => '',
                            ],
                        ),
                    ),
                ),

                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);