<?php
$et_supports = ['post'];
exp_add_custom_widget(
    array(
        'name' => 'blog_widget',
        'title' => esc_html__('Dailyfit Blog Widget', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'dailyfit' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => dailyfit_get_post_type_options($et_supports),
                                'default'  => 'post'
                            )
                        ),
                        dailyfit_get_post_widget_layout($et_supports)
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'dailyfit' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'dailyfit' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'dailyfit' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        dailyfit_get_grid_term_by_post_type($et_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        dailyfit_get_grid_ids_by_post_type($et_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'dailyfit' ),
                                    'ID' => esc_html__('ID', 'dailyfit' ),
                                    'author' => esc_html__('Author', 'dailyfit' ),
                                    'title' => esc_html__('Title', 'dailyfit' ),
                                    'rand' => esc_html__('Random', 'dailyfit' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'dailyfit' ),
                                    'asc' => esc_html__('Ascending', 'dailyfit' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'dailyfit' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        )
            	
					),
				),
                array(
                    'name' => 'tab_display',
                    'label' => esc_html__('Display', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 15,
                        ),
                        array(
                            'name' => 'date',
                            'label' => esc_html__('Show Date', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'author',
                            'label' => esc_html__('Show Author', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                    ),
                ),
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);