<?php

$html_id = exp_get_element_id($settings);

$title = $settings['title'];
$sub_title = $settings[ 'subtitle' ];
$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed');
$infinite = $widget->get_setting('infinite');

$changed_atts = array(
	'infinite'       => $infinite,
	'autoplay'       => $autoplay,
	'autoplaySpeed'  => $autoplay_speed,
	'dots' 			 => $dots,
	'nav' 		     => $arrows
);

$slider_atts = 'data-slider';

$widget->add_render_attribute( 'carousel', $slider_atts , wp_json_encode( $changed_atts ) );

if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    
 

<section class="testimonials-thumbs-carousel">
    <div class="auto-container">
        
        <!-- Carousel Wrapper -->
        <div id="carousel-thumb" class="carousel slide carousel-thumbnails" data-ride="carousel">
            <div class="row clearfix">
            
                <div class="carousel-column col-lg-6 col-md-12 col-sm-12">
                    <!-- Sec Title -->
                    <div class="sec-title">
                        <?php  if( $sub_title ):  ?>
                            <div class="title"><?php echo wp_kses_post($sub_title); ?></div>
                        <?php endif; ?>
                        <?php  if( $title ):  ?>
                            <h2><?php echo wp_kses_post($title); ?></h2>
                        <?php endif; ?>
                    </div>
                    <!-- Slides -->
                    <div class="carousel-inner" role="listbox">
                    	<?php 
                        	$count = 1;
                        	foreach ($settings['testimonial'] as $key => $value):
                                $desc = isset($value['desc']) ? $value['desc'] : '';
                                $title = isset($value['title']) ? $value['title'] : '';
                                $designation = isset($value['designation']) ? $value['designation'] : '';
                        ?>
                        <div class="carousel-item <?php if($count == 1) echo 'active'; ?>">
                            <div class="testimonial-block">
                                <div class="inner-box">
                                    <div class="title te-designation"><?php echo exp_print_html($designation); ?></div>
                                    <h4 class="te-title"><?php echo exp_print_html($title); ?></h4>
                                    <div class="rating">
                                        <?php
    										$ratting = wp_kses($value['star'], true ); 
                                            for ($x = 1; $x <= 5; $x++) {
                                                if($x <= $ratting) echo '<span class="fa fa-star"></span>'; else echo '<span class="fa fa-star-o"></span>'; 
                                            }
										?>
                                    </div>
                                    <div class="quote-icon flaticon-right-quote"></div>
                                    <div class="text .sec-title te-text"><?php echo exp_print_html($desc); ?></div>
                                </div>
                            </div>
                        </div>
                        <?php $count++; endforeach; ?>
                    </div>
                    <!-- Slides -->
                    
                    <!-- Controls -->
                    <a class="carousel-control-prev" href="#carousel-thumb" role="button" data-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="sr-only"><?php esc_html_e('Previous', 'dailyfit'); ?></span>
                    </a>
                    <a class="carousel-control-next" href="#carousel-thumb" role="button" data-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="sr-only"><?php esc_html_e('Next', 'dailyfit'); ?></span>
                    </a>
                    
                </div>
                
                <div class="pagers-column col-lg-6 col-md-12 col-sm-12">
                    <!-- Controls-->
                    <ol class="carousel-indicators">
                        <?php 
                            $count = 0; 
                            foreach ($settings['testimonial'] as $key => $value):
                                $image = isset($value['image']) ? $value['image'] : '';
                                
                               if(!empty($image['id'])) { 
                                $img = exp_get_image_by_size( array(
                                    'attach_id'  => $image['id'],
                                    'thumb_size' => '270x300',
                                    'class' => 'no-lazyload',
                                ));
                                $thumbnail = $img['thumbnail'];
                        ?>
                            <li data-target="#carousel-thumb" data-slide-to="<?php echo esc_attr($count); ?>" class="<?php if($count == 0) echo 'active'; ?>">
                                <div class="image">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
                            </li>
                            
                            <?php } ?>
                        <?php $count++; endforeach; ?>
                    </ol>
                </div>
                
            </div>
        </div>
            
    </div>
</section>

<?php endif;