<?php
	use \Elementor\Group_Control_Background;
	use \Elementor\Group_Control_Image_Size;
	$html_id = exp_get_element_id($settings);
	$layout = $settings[ 'layout' ];
		
    $page = $settings['link_option'];
    $page_select = $settings[ 'page_select' ];
    $ext_url = $settings[ 'link' ];

    if( $page == 'page' ){
        $mount_link = get_page_link( $page_select );
    }else{
        $mount_link = $ext_url['url'];
        $target = $ext_url['is_external'] ? ' target="_blank"' : '';
        $nofollow = $ext_url['nofollow'] ? ' rel="nofollow"' : '';
    }
?>
	
<!-- ==== pricing section start ==== -->
<section class="pricing-page-section p-0 m-0">
    <!-- Price Block -->
	<div class="price-block-two dailyfit-price-plan <?php echo esc_attr($settings['exp_animate']); ?>">
		<div class="inner-box" <?php if($settings['bg_img']){ ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_img']['id'])); ?>)"<?php } ?>>
			<div class="upper-box">
				<div class="title te-title"><?php echo wp_kses($settings['plan_title'], true); ?></div>
                <div class="price te-price"><?php echo wp_kses($settings['plan_price'], true); ?></div>
                <div class="month te-duration"><?php echo wp_kses($settings['plan_duration'], true); ?></div>
			</div>
			<?php if(isset($settings['plan_list']) && !empty($settings['plan_list']) && count($settings['plan_list'])): ?>
            <ul class="price-list dailyfit-list">
                <?php foreach ($settings['plan_list'] as $key => $value): ?>
                <li><?php echo exp_print_html($value['list_title'])?></li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>
			<div class="btn-box">
				<a href="<?php echo esc_url( $mount_link );?>" <?php if( $page == 'extranal' ) echo esc_attr( $target );?> <?php if( $page == 'extranal' ) echo esc_attr( $nofollow );?> class="theme-btn start-btn te-dailyfit-btn"><?php echo wp_kses($settings['btn_title'], true); ?></a>
			</div>
		</div>
	</div>
</section>
<!-- Pricing One Single End --> 