<?php
	use \Elementor\Group_Control_Background;
	use \Elementor\Group_Control_Image_Size;
	$html_id = exp_get_element_id($settings);
	$layout = $settings[ 'layout' ];
		
    $page = $settings['link_option'];
    $page_select = $settings[ 'page_select' ];
    $ext_url = $settings[ 'link' ];

    if( $page == 'page' ){
        $mount_link = get_page_link( $page_select );
    }else{
        $mount_link = $ext_url['url'];
        $target = $ext_url['is_external'] ? ' target="_blank"' : '';
        $nofollow = $ext_url['nofollow'] ? ' rel="nofollow"' : '';
    }
?>
	
<!-- ==== pricing section start ==== -->
<section class="price-section">
    <div class="pricing-block dailyfit-price-plan <?php echo esc_attr($settings['exp_animate']); ?>">
        <div class="inner-box" <?php if($settings['bg_img']){ ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_img']['id']));?>)"<?php } ?>>
            <h4 class="te-title"><?php echo wp_kses($settings['plan_title'], true); ?></h4>
            <div class="title te-text"><?php echo wp_kses($settings['plan_text'], true); ?></div>
            <div class="price te-duration"><?php echo wp_kses($settings['plan_duration'], true); ?><span class="te-price"><?php echo wp_kses($settings['plan_price'], true); ?></span></div>
            
            <?php if(isset($settings['plan_list']) && !empty($settings['plan_list']) && count($settings['plan_list'])): ?>
            <ul class="price-list dailyfit-list">
                <?php foreach ($settings['plan_list'] as $key => $value): ?>
                <li><?php echo exp_print_html($value['list_title'])?></li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>
            
            <?php if($settings['btn_title']){ ?>
            <div class="btn-one-outer"><a href="<?php echo esc_url( $mount_link );?>" <?php if( $page == 'extranal' ) echo esc_attr( $target );?> <?php if( $page == 'extranal' ) echo esc_attr( $nofollow );?> class="theme-btn btn-style-one te-dailyfit-btn"><span class="txt"><?php echo wp_kses($settings['btn_title'], true); ?></span></a></div>
            <?php } ?>
        </div>
    </div>
</section>
<!-- Pricing One Single End --> 