<?php

$html_id = exp_get_element_id($settings);
$source    = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(exp_get_posts_of_grid('team', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$exp_animate = $widget->get_setting('exp_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$img_size = $widget->get_setting('img_size');
$show_designation = $widget->get_setting('show_designation');
$show_title = $widget->get_setting('show_title');
$show_social = $widget->get_setting('show_social');
$drap = $widget->get_setting('drap');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed,
    'show_designation'              => $show_designation,
    'show_title'                    => $show_title,
    'show_social'                   => $show_social,
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'exp-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="team exp-grid p-0 m-0 team-section-three exp-swiper-sliders exp-post-carousel <?php if($arrows == true) { echo 'exp-arrows-active'; } ?>" <?php if($settings['drap']) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'dailyfit'); ?>"<?php endif; ?>>
        <div class="three-item-carousel swiper exp-carousel-inner">
            <div <?php exp_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="swiper-wrapper exp-swiper-wrapper">
                <?php
                    $image_size = !empty($img_size) ? $img_size : '320x460';
                    
                    $count = 1;
                    foreach ($posts as $key => $post):
                        $social_media = get_post_meta($post->ID, 'social_media_tabs', true);
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                            $img          = exp_get_image_by_size( array(
                                'attach_id'  => $img_id,
                                'thumb_size' => $image_size
                            ) );
                            $thumbnail    = $img['thumbnail'];
                            $thumbnail_url    = $img['url'];
                            ?>
                            
                            <div class="swiper-slide exp-swiper-slide">
                                <!--teams Block Two-->
                                <div class="team-block-three <?php echo esc_attr($exp_animate); ?>">
                                	<div class="inner-box">
                                	    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                                        <div class="image">
                    						<?php echo wp_kses_post($thumbnail); ?>
                                            <?php if ( $show_social && ! empty( $social_media ) ) : ?>
                                            <!-- Social Nav -->
                                            <ul class="social-box">
                    							<?php  
                                                for ( $i=0; $i < count( $social_media['select_social_media'] ); $i++ ) {
                                                    $social_icon = ( isset( $social_media['select_social_media'][$i] ) && !empty( $social_media['select_social_media'][$i] ) ) ? $social_media['select_social_media'][$i] : '';
                                                    $social_link = ( isset( $social_media['link_social_media'][$i] ) && !empty( $social_media['link_social_media'][$i] ) ) ? $social_media['link_social_media'][$i] : '';
                                                ?>
                                                <li><a target="_blank" href="<?php echo esc_url($social_link); ?>"><span class="fa <?php echo esc_attr($social_icon); ?>"></span></a></li>
                                                <?php }  ?>
                                            </ul>
                                            <?php endif; ?>
                                        </div>
                                        <?php endif; ?>
                                        <div class="lower-box">
                                            <?php if( $show_designation ):  ?>
                                                <div class="designation te-text"><?php echo (get_post_meta( $post->ID, 'designation', true ));  ?></div>
                                            <?php endif; ?>
                                            <?php if ( $show_title ) :  ?>
                                                <h3 class="name">
                                                    <a class="te-title" href="<?php echo esc_url( the_permalink( $post->ID ) );?>"><?php echo get_the_title($post->ID); ?></a>
                                                </h3>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        <?php endif; ?>
                	<?php endforeach; ?>
            	</div> 
            </div>
            
            <?php if($arrows !== 'false'):  ?>
        
            <div class="prev-portfolio-slide prev-slide exp-swiper-arrow exp-swiper-arrow-prev exp-swiper-arrow-dark1">
                <i class="fa fa-angle-left"></i>
            </div>
        
            <div class="next-portfolio-slide next-slide exp-swiper-arrow exp-swiper-arrow-next exp-swiper-arrow-dark1">
                <i class="fa fa-angle-right"></i>
            </div>
                
            <?php endif; ?>
            
            <?php if($pagination !== 'false'): ?>
            <div class="exp-swiper-dots owl-dots"></div>
            <?php endif; ?>
            
        </div>
    </div>
<?php endif; ?>