<?php

$html_id = exp_get_element_id($settings);
$source    = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(exp_get_posts_of_grid('service', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$exp_animate = $widget->get_setting('exp_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_excerpt = $widget->get_setting('show_excerpt');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');
$num_words = $widget->get_setting('num_words');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'swiper exp-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="exp-grid p-0 m-0 services-section-two exp-swiper-sliders exp-post-carousel <?php if($arrows == true) { echo 'exp-arrows-active'; } ?>" <?php if($settings['drap']) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'dailyfit'); ?>"<?php endif; ?>>
        <div class="inner-container margin-top">
            <div class="services-carousel exp-carousel-inner">
                
                <div <?php exp_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                    <div class="swiper-wrapper exp-swiper-wrapper">
                        
                        <?php
                            foreach ($posts as $key => $post):
                                $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
                                $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
                                $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
                                $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
                                $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
                        ?>
                            
                            <div class="swiper-slide exp-swiper-slide">
                                <!--Services Block Two-->
                                <div class="services-block-two <?php echo esc_attr($exp_animate); ?>">
                                	<div class="inner-box">
                                	    <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                                	    <div class="icon-box">
                                            <span class="icon te-author <?php echo esc_attr($service_icon_font); ?>"></span>
                                        </div>
                                	    <?php endif; ?>
                                	    
                                	    <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                                            $icon_img = exp_get_image_by_size( array(
                                                'attach_id'  => $service_icon_img['id'],
                                                'thumb_size' => 'full',
                                            ));
                                            $icon_thumbnail = $icon_img['thumbnail'];
                                            ?>
                                            <div class="icon-box te-author">
                                                <?php echo wp_kses_post($icon_thumbnail); ?>
                                            </div>
                                        <?php endif; ?>
                                	    
                                	    <h3><a class="te-title" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_the_permalink( $post->ID)); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                                	    
                                	    <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                                        <div class="te-text text"><?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?></div>
                                        <?php endif; ?>
                                	    
                                	    <?php if( $show_button == 'true' ):?>
                                        <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_the_permalink( $post->ID)); } ?>" class="read-more te-post-btn">
										    <?php echo wp_kses( $button_text, true );?>
                                        </a>
                                        <?php else:?>
                                        <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_the_permalink( $post->ID)); } ?>" class="read-more te-post-btn">
                                            <?php esc_html_e('Read More', 'dailyfit');?>
                                        </a>
                                        <?php endif;?>
                                	    
                                    </div>
                                </div>
                            </div>
                                
                    	<?php endforeach; ?>
                	</div> 
                </div>
                
                <?php if($arrows !== 'false'):  ?>
            
                <div class="prev-portfolio-slide prev-slide exp-swiper-arrow exp-swiper-arrow-prev exp-swiper-arrow-dark1">
                    <i class="fa fa-angle-left"></i>
                </div>
            
                <div class="next-portfolio-slide next-slide exp-swiper-arrow exp-swiper-arrow-next exp-swiper-arrow-dark1">
                    <i class="fa fa-angle-right"></i>
                </div>
                    
                <?php endif; ?>
                
                <?php if($pagination !== 'false'): ?>
                    <div class="exp-swiper-dots"></div>
                <?php endif; ?>
                
            </div>
        </div>    
    </div>
<?php endif; ?>