<?php

$html_id = exp_get_element_id($settings);
$source    = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(exp_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$exp_animate = $widget->get_setting('exp_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$img_size = $widget->get_setting('img_size');
$show_excerpt = $widget->get_setting('show_excerpt');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');
$num_words = $widget->get_setting('num_words');
$drap = $widget->get_setting('drap');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'exp-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="portfolio fullwidth-gallery-section featured-section exp-grid p-0 m-0 exp-swiper-sliders exp-post-carousel <?php if($arrows == true) { echo 'exp-arrows-active'; } ?>" <?php if($settings['drap']) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'dailyfit'); ?>"<?php endif; ?>>
        <div class="outer-container">
            
            <div class="inner-container">
                <div class="single-item-carousel owl-carousel swiper exp-carousel-inner">
                    <div <?php exp_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                        <div class="swiper-wrapper exp-swiper-wrapper">
                        <?php
                            $count = 1;
							$image_size = !empty($img_size) ? $img_size : '970x570';
                            foreach ($posts as $post):
                            $portfolio_excerpt = get_post_meta($post->ID, 'portfolio_excerpt', true);
                            $portfolio_external_link = get_post_meta($post->ID, 'portfolio_external_link', true);
                            $img_id       = get_post_thumbnail_id( $post->ID );
                            $post_thumbnail_url = wp_get_attachment_url($img_id);
                            $author = get_user_by('id', $post->post_author); 
                            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                                $img          = exp_get_image_by_size( array(
                                    'attach_id'  => $img_id,
                                    'thumb_size' => $image_size
                                ) );
                                $thumbnail    = $img['thumbnail'];
                                $thumbnail_url    = $img['url'];
                                ?>
                                <div class="swiper-slide exp-swiper-slide">
                                    <div class="featured-block">
                                        <div class="inner-box">                    
                                            <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                                            <!--Content Column-->
                                            <div class="image">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                                <div class="options">
                                                    <a href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_the_permalink( $post->ID )); } ?>" class="plus-icon"><span class="icon flaticon-unlink"></span></a>
                                                    <a href="<?php echo wp_kses_post($post_thumbnail_url); ?>" class="plus-icon lightbox-image" data-fancybox-group="gallery-one">
                                                        <span class="icon flaticon-increase-size-option"></span>
                                                    </a>
                                                </div>
                                                <div class="content-box">
                                                    <div class="title te-category"><?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?></div>
                                                    <h3><a class="te-title" href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_the_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                                                    <?php if($show_excerpt == 'true' && !empty($portfolio_excerpt)): ?>
                                                    <div class="te-text text"><?php echo wp_trim_words( $portfolio_excerpt, $num_words, $more = null ); ?></div>
                                                    <?php endif; ?>
                                                    <a href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_the_permalink( $post->ID )); } ?>" class="theme-btn btn-style-one te-post-btn">
                                                        <span class="txt">
                                                            <?php if( $show_button == 'true' ):?>
        													<?php echo wp_kses( $button_text, true );?>
        													<?php else:?>
                                                            <?php esc_html_e('Read More', 'dailyfit');?> 
                                                            <?php endif;?>
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                            <?php endif;?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            <?php $count++; endforeach; ?>
                        </div> 
                    </div>
                </div>
                
                <?php if($arrows !== 'false'):  ?>                    
                <div class="owl-nav">
                    <div class="prev-portfolio-slide prev-slide exp-swiper-arrow-prev owl-prev">
                        <span class="left fa fa-angle-left"></span>
                    </div>
                    <div class="next-portfolio-slide next-slide exp-swiper-arrow-next owl-next">
                        <span class="right fa fa-angle-right"></span>
                    </div>
                </div>                     
                <?php endif; ?>
                
                <?php if($pagination !== 'false'): ?>
                <div class="exp-swiper-dots owl-dots"></div>
                <?php endif; ?>
                
            </div>
    	</div>
    </div>
<?php endif; ?>