<?php
	$html_id = exp_get_element_id($settings);
?>

<div class="funfact_default-section counter-section">
    <div class="inner-container">
        <!-- Fact Counter -->
        <div class="fact-counter">
            <div class="row clearfix">
                <?php 
                    foreach ($settings['funfact'] as $key => $value):
                ?>
                <!-- Column -->
                <div class="column counter-column col-lg-3 col-md-6 col-sm-12">
                    <div class="inner <?php echo esc_attr($settings['exp_animate']); ?>" data-wow-delay="0ms" data-wow-duration="<?php echo esc_attr($value['exp_animate_delay']); ?>ms">
                        <div class="content">
                            <?php if ( $value['icon_type'] == 'icon' && !empty($value['exp_icon']['value']) ) : ?>
                    		<div class="icon-box te-icons">    
                    		    <?php \Elementor\Icons_Manager::render_icon( $value['exp_icon'], [ 'aria-hidden' => 'true', 'class' => 'icon ' ], 'i' ); ?>
                    		</div>
                    		<?php endif; ?>
                            
                            <?php if ( $value['icon_type'] == 'image' && !empty($value['icon_image']['id']) ) : ?>
                        	<div class="icon-box te-icons">
                        		<?php $img_icon  = exp_get_image_by_size( array(
                                        'attach_id'  => $value['icon_image']['id'],
                                        'thumb_size' => 'full',
                                    ) );
                                    $thumbnail_icon    = $img_icon['thumbnail'];
                                echo exp_print_html($thumbnail_icon); ?>
                    		</div>
                    		<?php endif; ?>
                            
                            <div class="count-outer count-box">
                                <span class="count-text te-number" data-speed="3500" data-stop="<?php echo exp_print_html($value['ending_number']); ?>"><?php echo exp_print_html($value['start_number']); ?></span>
                            </div>
                            
                            <?php if(!empty($value['title'])) : ?>
                            <div class="counter-title te-title"><?php echo exp_print_html($value['title']); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach;?>
            </div>
        </div>
    </div>
</div>