<?php
	$html_id = exp_get_element_id($settings);
	
	$title = $settings['title'];
	$sub_title = $settings[ 'subtitle' ];
	$show_title = $settings['show_title'];
	$show_subtitle = $settings[ 'show_subtitle' ];
	$btn_title = $settings[ 'btn_title' ];
?>


<!-- Calculate Section Two -->
<section class="calculate-section-two">
    <div class="pattern-layer" style="background-image:url(<?php echo wp_get_attachment_url($settings['bg_img']['id']);?>)"></div>
	<div class="auto-container">
		<div class="inner-container">
			
			<div class="row clearfix">
				
				<!-- Title Column -->
				<div class="title-column col-lg-4 col-md-12 col-sm-12">
					<div class="inner-column">
						<!-- Sec Title -->
						<div class="sec-title light">
						    <?php  if( $show_subtitle && $sub_title ):  ?>
    							<div class="title"><?php echo wp_kses_post($sub_title); ?></div>
    						<?php endif; ?>
    						<?php  if( $show_title && $title ):  ?>
    							<h2><?php echo wp_kses_post($title); ?></h2>
							<?php endif; ?>
						</div>
					</div>
				</div>
				
				<!-- Form Column -->
				<div class="form-column col-lg-8 col-md-12 col-sm-12">
					<div class="inner-column">
						
						<!-- Default Form -->
						<div class="default-form style-three">
							
							<!-- Default Form -->
							<div class="row clearfix">
							
							    <?php  if( $settings['show_height'] ):    ?>
    								<div class="col-lg-4 col-md-6 col-sm-12 form-group">
    									<input type="text" id="heightInFeet1" class="form-control" placeholder="<?php echo esc_html__('Height / CM', 'dailyfit'); ?>">
    								</div>
								<?php endif; ?>
								
								<?php  if( $settings['show_weight'] ):    ?>
    								<div class="col-lg-4 col-md-6 col-sm-12 form-group">
    									<input type="text" id="weight1" class="form-control" placeholder="<?php echo esc_html__('Weight / Kg', 'dailyfit'); ?>">
    								</div>
    							<?php endif; ?>
								
								<?php  if( $settings['show_age'] ):    ?>
    								<div class="form-group col-lg-4 col-md-6 col-sm-12">
    									<input type="text" id="age1" class="form-control" placeholder="<?php echo esc_html__('Age', 'dailyfit'); ?>">
    								</div>
    							<?php endif; ?>
								
								<?php  if( $settings['show_gender'] ):    ?>
    								<div class="form-group col-lg-4 col-md-6 col-sm-12">
    									<select class="custom-select-box form-control custom-select-box" id="gender1">
                                          <option value=""><?php echo esc_html__('Select Gender', 'dailyfit'); ?></option>
                                          <option value="male"><?php echo esc_html__('Male', 'dailyfit'); ?></option>
                                          <option value="female"><?php echo esc_html__('Female', 'dailyfit'); ?></option>
                                        </select>
    								</div>
    							<?php endif; ?>
								
								<?php  if( $settings['show_activity'] ):    ?>
    								<div class="form-group col-lg-4 col-md-6 col-sm-12">
                                        <select id="activity_level1" class="pf-bmi-select2 select2-hidden-accessible custom-select-box custom-select-box form-control" name="activity_level" tabindex="-1" aria-hidden="true">
                                          <option value=""><?php echo esc_html__('Select an activity factor:', 'dailyfit'); ?></option>
                                          <option value="little"><?php echo esc_html__('Little or no Exercise / desk job', 'dailyfit'); ?></option>
                                          <option value="light"><?php echo esc_html__('Light exercise / sports 1 – 3 days/ week', 'dailyfit'); ?></option>
                                          <option value="moderate"><?php echo esc_html__('Moderate Exercise, sports 3 – 5 days / week', 'dailyfit'); ?></option>
                                          <option value="heavy"><?php echo esc_html__('Heavy Exercise / sports 6 – 7 days / week', 'dailyfit'); ?></option>
                                          <option value="very_heavy"><?php echo esc_html__('Very heavy exercise/ physical job / training 2 x / day', 'dailyfit'); ?></option>
                                        </select>
    								</div>
    							<?php endif; ?>
								
								<div class="form-group col-lg-4 col-md-6 col-sm-12">
								    <div class="btn-two-outer"><a href=" javascript:void(0)" class="theme-btn btn-style-two submitButton1" id="btn-result1"><span class="txt"><?php echo wp_kses_post( $btn_title ); ?></span></a></div>
								</div>
								
							</div>
							
							<!--End Default Form -->
						</div>
						
					</div>
				</div>
				
				<div id="pt1-result">

                </div>
				
			</div>
		</div>
	</div>
</section>
<!-- End Calculate Section Two -->