<?php
$html_id = exp_get_element_id($settings);
$tax = array();
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 2);
extract(exp_get_posts_of_grid(
    'post', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids],
    ['category']
));

$img_size = $widget->get_setting('img_size');
$images_size = !empty($img_size) ? $img_size : '93x93';

$post_type = $widget->get_setting('post_type','post');
$layout = $widget->get_setting('layout_'.$post_type, 'post-1');
$show_author = $widget->get_setting('author');
$date = $widget->get_setting('date');
$num_words = $widget->get_setting('num_words');

if (is_array($posts)):
        
    ?>
    
    <div class="footer footer__widget  p-0 m-0 news-widget <?php echo esc_attr($settings['exp_animate']); ?>"  data-wow-delay="<?php echo esc_attr($settings['exp_animate_delay']); ?>ms">
        <div class="footer__widget-content recent-post p-0 m-0">
            <?php    
            foreach ($posts as $key => $post):
             $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'post_id'    => $post->ID,
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => '',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author);
            ?>
            <article class="recent-post footer__blog-single">
                <div class="inner widget-inner">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <figure class="post-thumb image">
                            <a href="<?php echo esc_url( get_the_permalink( get_the_id() ) );?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </figure>
                    <?php  endif; ?>
                    <div class="content">
                        <h5 class="post-title"><a href="<?php echo esc_url( get_the_permalink( $post->ID ) );?>"><?php echo wp_trim_words(get_the_title($post->ID), $num_words, '...'); ?></a></h5>
                        <?php if( $show_author || $date ) : ?>
                        <ul class="post-meta">
                            <?php if( $show_author ) : ?>
                                <li><i class="icon fa fa-user"></i> <?php echo esc_html($author->display_name); ?></li>
                            <?php endif;  ?>
                            <?php if( $date ) : ?>
                                <li><i class="icon fa fa-calendar"></i> <?php echo esc_html(get_the_date()); ?></li>
                            <?php endif; ?>
                        </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </article>
            <?php endforeach; ?>
        </div>
    </div>
    
<?php                     
endif;
wp_reset_postdata();
