<?php
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
$html_id = exp_get_element_id($settings);
$layout = $settings[ 'layout' ];

$exp_animate = $widget->get_setting('exp_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
$drap = $widget->get_setting('drap');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'exp-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['banner_slide']) && !empty($settings['banner_slide']) && count($settings['banner_slide'])): ?>
    
    <!-- ==== testimonial section start ==== -->
    <section class="main-slider-two exp-swiper-sliders exp-post-carousel <?php if($arrows == true) { echo 'exp-arrows-active'; } ?>" <?php if($settings['drap']) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'dailyfit'); ?>"<?php endif; ?>>
        <div class="swiper-container swiper exp-carousel-inner">                
            <div <?php exp_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="swiper-wrapper exp-swiper-wrapper">
                    <?php 
                        foreach ($settings['banner_slide'] as $key => $value):
                        $subtitle = isset($value['subtitle']) ? $value['subtitle'] : '';
                        $title = isset($value['title']) ? $value['title'] : '';
                        $btn_title = isset($value['btn_title']) ? $value['btn_title'] : '';
                        
                        $page = $value['link_option'];
                        $page_select = $value[ 'page_select' ];
                        $ext_url = $value[ 'link' ];

                        if( $page == 'page' ){
                            $mount_link = get_page_link( $page_select );
                        }else{
                            $mount_link = $ext_url['url'];
                            $target = $ext_url['is_external'] ? ' target="_blank"' : '';
                            $nofollow = $ext_url['nofollow'] ? ' rel="nofollow"' : '';
                        }
                        
                        $video_option = $value[ 'video_option' ];
                    	if( $video_option == 'src_url' ){
                    		$video = $value[ 'video_link' ][ 'url' ];
                    	}elseif( $video_option == 'src_media' ){
                    		$video = $value[ 'video_source_image' ]['url'];
                    	}else{
                    		$video = esc_html__( 'There is no Video', 'dailyfit' );
                    	}
                    ?>
                    <!--Testimonial One Single Start -->
                    <div class="swiper-slide exp-swiper-slide dailyfit-banner-section">
                        <div class="slide" <?php if($value['bg_image']){ ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($value['bg_image']['id'])); ?>)"<?php }; ?>>
                            <?php if($value['pattern_img']){ ?><div class="pattern-layer" style="background-image:url('<?php echo esc_url(wp_get_attachment_url($value['pattern_img']['id'])); ?>')"></div><?php } ?>
                            <?php if($value['dots_img']){ ?><div class="pattern-dots" style="background-image:url('<?php echo esc_url(wp_get_attachment_url($value['dots_img']['id'])); ?>')"></div><?php } ?>
                            
                            <div class="auto-container">
                                <!-- Content boxed -->
                                <div class="content-boxed">
                                    <div class="title te-subtitle"><?php echo exp_print_html($subtitle); ?></div>
                                    <h1 class="te-title"><?php echo exp_print_html($title); ?></h1>
                                    
                                    <?php if($btn_title){ ?>
                                    <div class="link-box clearfix">
                                        <div class="btn-one-outer"><a href="<?php echo esc_url( $mount_link );?>" <?php if( $page == 'extranal' ) echo esc_attr( $target );?> <?php if( $page == 'extranal' ) echo esc_attr( $nofollow );?> class="theme-btn btn-style-one yt-btn-title-v1"><span class="txt"><?php echo exp_print_html($btn_title); ?></span></a></div>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php if($video){ ?>
                                    <a href="<?php echo esc_url( $video );?>" class="lightbox-image video-box"><span class="fa fa-play"><i class="ripple"></i></span></a>
                                	<?php } ?>
                                </div>
                                
                            </div>                            
                        </div>                        
                    </div>
                    <!--Testimonial One Single End -->
                    
                    <?php endforeach; ?>
                </div>
            </div>                    
        
            <?php if($arrows !== 'false'):  ?>
            <div class="owl-nav">
                <div class="prev-blog-slide prev-slide exp-swiper-arrow exp-swiper-arrow-prev exp-swiper-arrow-dark1">
                    <i class="fa fa-angle-left"></i>
                </div>

                <div class="next-blog-slide next-slide exp-swiper-arrow exp-swiper-arrow-next exp-swiper-arrow-dark1">
                    <i class="fa fa-angle-right"></i>
                </div>
            </div>            
            <?php endif; ?>
            
            <?php if($pagination !== 'false'): ?>
            <div class="exp-swiper-dots owl-dots"></div>
            <?php endif; ?>
            
        </div>
        
        
        <?php if(isset($settings['icon_list']) && !empty($settings['icon_list']) && count($settings['icon_list'])): ?>
        <!-- Social Box -->
        <div class="social-box">
            <ul>
                <li class="share"><span class="icon fa fa-share"></span></li>
                <?php foreach ($settings['icon_list'] as $key => $value): ?>
                <li><a href="<?php echo esc_url($value['social_link']['url']); ?>" class="fa <?php echo esc_attr($value['social_icon']['value']); ?>"></a></li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php endif; ?>
    </section>
     <!-- ==== / testimonial section end ==== -->
    
<?php endif; ?>
                