;(function ($) {

    "use strict";
    
    var exp_scroll_top;
    var exp_window_height;
    var exp_window_width;
    var exp_scroll_status = '';
    var exp_last_scroll_top = 0;
    $(window).on('load', function () {
        $(".exp-loader").addClass("is-loaded");
        $('.exp-gallery-scroll').parents('body').addClass('body-overflow').addClass('body-visible-sm');
        exp_window_width = $(window).width();
        exp_window_height = $(window).height();
        urhome_header_sticky();
        urhome_default_header_sticky();
        urhome_header_mobile();
        urhome_scroll_to_top();
        urhome_footer_fixed();
    });

    $(window).on('scroll', function () {
        exp_scroll_top = $(window).scrollTop();
        exp_window_height = $(window).height();
        exp_window_width = $(window).width();
        if (exp_scroll_top < exp_last_scroll_top) {
            exp_scroll_status = 'up';
        } else {
            exp_scroll_status = 'down';
        }
        exp_last_scroll_top = exp_scroll_top;
        urhome_header_sticky();
        urhome_default_header_sticky();
        urhome_scroll_to_top();
        urhome_footer_fixed();
    });

    $(window).on('resize', function () {
        exp_window_height = $(window).height();
        exp_window_width = $(window).width();
        urhome_header_mobile();
    });

    $(document).ready(function () {


        /* Elementor Header */
        $('.exp-type-header-clip > .elementor-container').append('<div class="exp-header-shape"><span></span></div>');
        
        /* Comment Reply */
        $('.comment-reply a').append( '<i class="fa fa-angle-right"></i>' );

        /* Scroll To Top */
        $('.exp-scroll-top').click(function () {
            $('html, body').animate({scrollTop: 0}, 800);
            return false;
        });

    });

     
    /* Header Sticky */
    function urhome_header_sticky() {
        if($('#exp-header-elementor').hasClass('is-sticky')) {
            
            if (exp_scroll_top > 100) {
                $('.exp-header-elementor-sticky.exp-sticky-stb').addClass('exp-header-fixed');
                $('#exp-header-mobile').addClass('exp-header-mobile-fixed');
            } else {
                $('.exp-header-elementor-sticky.exp-sticky-stb').removeClass('exp-header-fixed');
                $('#exp-header-mobile').removeClass('exp-header-mobile-fixed');
            }
            
            if (exp_scroll_status == "up" && exp_scroll_top > 100) {
                $(".exp-header-elementor-sticky.exp-sticky-stt").addClass("exp-header-fixed");
                $('#exp-header-mobile').addClass('exp-header-mobile-fixed');
            } else {
                $(".exp-header-elementor-sticky.exp-sticky-stt").removeClass("exp-header-fixed");
                $('#exp-header-mobile').removeClass('exp-header-mobile-fixed');
            }
        }

        $('.exp-header-elementor-sticky').parents('body').addClass('exp-header-sticky');
    }
    
    
        /* Header Sticky */
        function urhome_default_header_sticky() {
            if($('#exp-header-default').hasClass('is-sticky')) {
                if (exp_scroll_top > 100) {
                    $('.exp-header-mobile.exp-sticky-stb').addClass('exp-header-mobile-fixed');
                } else {
                    $('.exp-header-mobile.exp-sticky-stb').removeClass('exp-header-mobile-fixed');
                }
            }
    
            $('.exp-header-elementor-sticky').parents('body').addClass('exp-header-sticky');
        }


    /* Header Mobile */
    function urhome_header_mobile() {
        var h_header_mobile = $('#exp-header-elementor').outerHeight();
        if(exp_window_width < 1199) {
            $('#exp-header-elementor').css('min-height', h_header_mobile + 'px');
        }
    }

    /* Scroll To Top */
    function urhome_scroll_to_top() {
        if (exp_scroll_top < exp_window_height) {
            $('.exp-scroll-top').addClass('exp-off').removeClass('exp-on');
        }
        if (exp_scroll_top > exp_window_height) {
            $('.exp-scroll-top').addClass('exp-on').removeClass('exp-off');
        }
    }

    /* Footer Fixed */
    function urhome_footer_fixed() {
        setTimeout(function(){
            var h_footer = $('.exp-footer-fixed #exp-footer-elementor').outerHeight() - 1;
            $('.exp-footer-fixed #exp-main').css('margin-bottom', h_footer + 'px');
        }, 600);
    }


})(jQuery);