<?php
	/**
	 * @package Expert Themes
	 */
	get_header(); 
	$error_bg_image = dailyfit()->get_theme_opt('error_bg_image');
?>

<!--Error Section-->
<section class="error-section">
    <div class="auto-container">
        <div class="content">
            <div class="error-title">
                <?php 
                    if( dailyfit()->get_theme_opt( '404_page_title' ) ){
                        echo wp_kses( dailyfit()->get_theme_opt( '404_page_title' ), true );
                    }else{
                        esc_html_e( '404', 'dailyfit' );
                    }
                ?>
            </div>
            <h2>
                <?php 
                    if( dailyfit()->get_theme_opt( '404_page_heading' ) ){
                        echo wp_kses( dailyfit()->get_theme_opt( '404_page_heading' ), true );
                    }else{
                        esc_html_e( 'Oops! That page cannot be found!', 'dailyfit' );
                    }
                ?>
            </h2>
            <div class="text">
                <?php 
                    if( dailyfit()->get_theme_opt( '404_page_text' ) ){
                        echo wp_kses( dailyfit()->get_theme_opt( '404_page_text' ), true );
                    }else{
                        esc_html_e( 'Sorry, but the page you are looking for does not existing', 'dailyfit' );
                    }
                ?>
            </div>
            <?php if ( dailyfit()->get_theme_opt( 'back_home_btn' ) ) : ?>
            <div class="about-one__btn-box">
                <a href="<?php echo esc_url(home_url('/')); ?>" class="theme-btn btn-style-three">
                    <span class="txt">
                        <?php 
                            if( dailyfit()->get_theme_opt( 'back_home_btn_label' ) ){
                                echo wp_kses( dailyfit()->get_theme_opt( 'back_home_btn_label' ), true );
                            }else{
                                esc_html_e( 'Back To Home Page', 'dailyfit' );
                            }
                        ?>
                    </span>
                </a>
            </div>
            <?php endif;?>
        </div>
    </div>
</section>
<!--End Error Section-->

<?php get_footer();