<?php
/**
 * Custom taxonomies register
 *
 * @package Expert Themes Team
 * @since   1.0
 */

class EXP_CTax_Register
{
    /**
     * Core singleton class
     *
     * @var self - pattern realization
     * @access private
     */
    private static $_instance;

    /**
     * Store supported taxonomies in an array
     * @var array
     * @access private
     */
    private $taxonomies = array();

    /**
     * Constructor
     *
     * @access private
     */
    function __construct()
    {
        add_action('init', array($this, 'init'), 0);
    }

    /**
     * init hook - 0
     */
    function init()
    {
        $this->taxonomies = apply_filters('exp_extra_taxonomies', array());
        if(empty($this->taxonomies)) return;
        foreach ($this->taxonomies as $key => $exp_taxonomy) {
            if ($exp_taxonomy['status'] === true) {
                $categories = array_merge(array(
                    'hierarchical'       => true,
                    'show_ui'            => true,
                    'show_in_menu'       => true,
                    'show_in_nav_menus'  => true,
                    'show_admin_column'  => true,
                    'show_in_rest'       => true,
                    'show_in_quick_edit' => true,
                    'labels'             => array_merge(array(
                        'name'              => $exp_taxonomy['taxonomies'],
                        'singular_name'     => $exp_taxonomy['taxonomy'],
                        'edit_item'         => esc_html__('Edit', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomy'],
                        'update_item'       => esc_html__('Update', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomy'],
                        'add_new_item'      => esc_html__('Add New', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomy'],
                        'new_item_name'     => esc_html__('New Type', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomy'],
                        'all_items'         => esc_html__('All', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomies'],
                        'search_items'      => esc_html__('Search', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomy'],
                        'parent_item'       => esc_html__('Parent', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomy'],
                        'parent_item_colon' => esc_html__('Parent', EXP_TEXT_DOMAIN) . ' ' . $exp_taxonomy['taxonomy'] . ':',
                    ), $exp_taxonomy['labels']),
                    'rewrite'      => array(
	                    'slug' => $key
                    )
                ), $exp_taxonomy['args']);

                register_taxonomy($key, $exp_taxonomy['post_type'], $categories);
            }
        }

    }

    /**
     * Get instance of the class
     *
     * @access public
     * @return object this
     */
    public static function get_instance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}

EXP_CTax_Register::get_instance();