<?php
/**
 * Plugin Name: Dailyfit Plugin
 * Description: Add many widgets, shortcodes and custom post types for your theme.
 * Plugin URI:  https://expert-themes.com/
 * Version:     1.0
 * Author:      Expert Themes
 * Author URI:  https://themeforest.net/user/expert-themes/
 * Update URI:  https://api.expert-themes.com/
 * Text Domain: expert-core
 */

use Elementor\Plugin;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

define('EXP_TEXT_DOMAIN', 'expert-core');
define('EXP_PATH', plugin_dir_path(__FILE__));
define('EXP_URL', plugin_dir_url(__FILE__));

class Exptheme_Core
{

    const VERSION = '1.0';

    const MINIMUM_ELEMENTOR_VERSION = '3.0.0';

    const MINIMUM_PHP_VERSION = '7.0';
    private static $_instance = null;
    public $post_metabox = null;
    public $taxonomy_meta = null;
    public $plugin_name = '';

    public function __construct()
    {
        if (!function_exists('get_plugin_data'))
            require_once(ABSPATH . 'wp-admin/includes/plugin.php');
        $plugin_data = get_plugin_data(__FILE__);
        $this->plugin_name = $plugin_data['Name'];

        $this->includes();

        add_action('admin_init', [$this, 'exp_admin_init'], 10, 1);
        add_action('init', [$this, 'exp_init']);
        add_action('admin_enqueue_scripts', array($this, 'exp_admin_enqueue_scripts'));
        add_action('wp_enqueue_scripts', array($this, 'exp_register_script'), 4);
        add_action('plugins_loaded', [$this, 'exp_handler']);
        add_action('plugins_loaded', [$this, 'exp_elementor']);

        add_action('admin_bar_menu', [$this, 'register_admin_bar_menu']);
        add_action('admin_bar_menu', [$this, 'remove_from_admin_bar'], 999);

    }

    public function includes()
    {

        require_once(__DIR__ . '/inc/functions.php');
        require_once(__DIR__ . '/inc/elementor/el-functions.php');

        if (!class_exists('EXP_CPT_Register')) {
            require_once EXP_PATH . 'inc/post-type/cpt-register.php';
        }

        if (!class_exists('EXP_CTax_Register')) {
            require_once EXP_PATH . 'inc/post-type/ctax-register.php';
        }
        if (!class_exists('EXP_MegaMenu_Register')) {
            require_once EXP_PATH . 'inc/mega-menu/class-megamenu.php';
        }

    }

    public static function instance()
    {

        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;

    }

    function exp_admin_init()
    {
        // import demo data 
        if (!class_exists('Exp_Importer')) {
            require_once EXP_PATH . 'src/core-importer/importer-handles.php';
        }
    }


    public function exp_init()
    {
        
        //update woo attribute after imported
        $woo_term_imported = get_option('exp_woo_term_imported', "null");
        if ($woo_term_imported === "not_imported" && !class_exists('EXP_Woo_Attributes_Handle')) {
            require_once EXP_PATH . 'src/core-importer/woo_attributes_handles.php';
        }
        //load_scss_lib
        $scssc_lib = apply_filters('exp_scssc_lib', 'old');
        $exp_scssc_on = apply_filters('exp_scssc_on', false);
        if ($exp_scssc_on && $scssc_lib === 'old' && !class_exists('scssc')) {
            require_once __DIR__ . '/src/scss.inc.php';
        }
        if ($exp_scssc_on && $scssc_lib === 'new' && !class_exists('\ScssPhp\ScssPhp\Compiler')) {
            require_once __DIR__ . '/src/scss/scss.inc.php';
        }

        //load_meta_redux_opt
        if (!class_exists('ReduxFramework')) {
            add_action('admin_notices', array($this, 'redux_framework_notice'));
        } else {
            if (!class_exists('EXP_Post_Metabox')) {
                require_once EXP_PATH . 'inc/meta-box/class-post-metabox.php';

                if (empty($this->post_metabox)) {
                    $this->post_metabox = new EXP_Post_Metabox();
                }
            }
            if (!class_exists('EXP_Taxonomy_Meta')) {
                require_once EXP_PATH . 'inc/meta-box/class-taxonomy-meta.php';

                if (empty($this->taxonomy_meta)) {
                    $this->taxonomy_meta = new EXP_Taxonomy_Meta();
                }
            }
        }
    }

    public function exp_admin_enqueue_scripts()
    {
        wp_enqueue_style('exp-admin-css', EXP_URL . 'assets/css/admin.css', [], '1.0.0');
    }

    public function exp_register_script()
    {
        $awesome_pro_support = apply_filters('exp_support_awesome_pro', true);
        /* Styles */
        wp_enqueue_style('exp-main-css', EXP_URL . 'assets/css/main.css', [], '1.0.0');
        if ($awesome_pro_support)
            wp_register_style('font-awesome-pro', EXP_URL . 'assets/libs/font-awesome-pro/css/all.min.css', [], '5.15.4-pro');

        wp_register_style('exp-slick-css', EXP_URL . 'assets/js/libs/slick/slick.css', [], '1.0.0');

        /* Scripts */
        wp_register_script('waypoints', EXP_URL . 'assets/js/libs/waypoints.min.js', ['jquery'], '2.0.5');
        wp_register_script('imagesloaded', EXP_URL . 'assets/js/libs/imagesloaded.pkgd.min.js', ['jquery'], '3.1.8');
        wp_register_script('isotope', EXP_URL . 'assets/js/libs/isotope.pkgd.min.js', ['jquery'], '3.0.6');
        
        if(!wp_script_is('jquery-slick')){
            wp_register_script('jquery-slick', EXP_URL . 'assets/js/libs/slick/slick.min.js', ['jquery'], '1.8.1');
        }
        
        wp_enqueue_script('exp-core-main', EXP_URL . 'assets/js/main.js', [ 'jquery', 'waypoints' ], '1.0.0', true);
        
        $swiper_version = apply_filters( 'exp-swiper-version-active', '5.3.6' );

        switch ($swiper_version) {
            case '8.4.5':
                wp_register_style('swiper', EXP_URL . 'assets/js/libs/swiper/v8/css/swiper.min.css', [], '8.4.5');
                wp_register_script('swiper', EXP_URL . 'assets/js/libs/swiper/v8/swiper.min.js', [], '8.4.5');
                break;
            case '10.1.0':
                wp_register_style('swiper', EXP_URL . 'assets/js/libs/swiper/v10/css/swiper.min.css', [], '10.1.0');
                wp_register_script('swiper', EXP_URL . 'assets/js/libs/swiper/v10/swiper.min.js', [], '10.1.0');
                break;
            default:
                wp_register_style('swiper', EXP_URL . 'assets/js/libs/swiper/css/swiper.min.css', [], '5.3.6');
                wp_register_script('swiper', EXP_URL . 'assets/js/libs/swiper/swiper.min.js', [], '5.3.6');
                break;
        }
    }

    public function exp_handler()
    {

        if (class_exists('ReduxFramework') && !class_exists('EXP_Redux_Extensions')) {
            require_once EXP_PATH . 'inc/redux-fields/redux-fields.php';
        }

    }

    public function exp_elementor()
    {

        if (!did_action('elementor/loaded')) {
            add_action('admin_notices', [$this, 'admin_notice_missing_main_plugin']);
            return;
        }

        // Check for required Elementor version
        if (!version_compare(ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=')) {
            add_action('admin_notices', [$this, 'admin_notice_minimum_elementor_version']);
            return;
        }

        // Check for required PHP version
        if (version_compare(PHP_VERSION, self::MINIMUM_PHP_VERSION, '<')) {
            add_action('admin_notices', [$this, 'admin_notice_minimum_php_version']);
            return;
        }

         if ( is_admin() && class_exists('\Elementor\Plugin')) {
            require_once EXP_PATH . 'inc/elementor/theme-builder/class-admin.php';
        }

        if (defined('ELEMENTOR_VERSION') && is_callable('Elementor\Plugin::instance')) {
            include_once EXP_PATH . 'inc/elementor/exp-elementor.php';
        }

        if (defined('ELEMENTOR_VERSION') && is_callable('Elementor\Plugin::instance')) {
            include_once EXP_PATH . 'inc/elementor/template-library/manager.php';
        }

    }

    public function register_admin_bar_menu($wp_admin_bar)
    {

        $theme = wp_get_theme();
        $wp_admin_bar->add_node([
            'id' => $theme->get("TextDomain"),
            'title' => '<span class="ab-icon dashicons-admin-home"></span>' . $theme->get("Name"),
            'href' => is_admin() ? home_url('/') : admin_url('admin.php?page=expert'),
            'meta' => array(
                'class' => 'dashicons dashicons-admin-generic',
                'title' => $theme->get("TextDomain"),
            )
        ]);

        $wp_admin_bar->add_node([
            'id' => 'expert-visit-site',
            'title' => esc_html__('Visit Site', EXP_TEXT_DOMAIN),
            'href' => home_url('/'),
            'parent' => $theme->get("TextDomain"),
            'meta' => array(
                'class' => '',
                'title' => esc_html__('Visit Site', EXP_TEXT_DOMAIN),
            )
        ]);

        $wp_admin_bar->add_node([
            'id' => 'expert-dashboard',
            'title' => esc_html__('Dashboard', EXP_TEXT_DOMAIN),
            'href' => admin_url('admin.php?page=expert'),
            'parent' => $theme->get("TextDomain"),
            'meta' => array(
                'class' => '',
                'title' => esc_html__('Dashboard', EXP_TEXT_DOMAIN),
            )
        ]);

        if (class_exists('ReduxFramework')) {
            $wp_admin_bar->add_node([
                'id' => 'theme-options',
                'title' => 'Theme Options',
                'href' => admin_url('admin.php?page=expert-theme-options'),
                'parent' => $theme->get("TextDomain"),
                'meta' => array(
                    'class' => '',
                    'title' => esc_html__('Theme Options', EXP_TEXT_DOMAIN),
                )
            ]);
        }
        $wp_admin_bar->add_node([
            'id' => 'exp-themes',
            'title' => esc_html__('Themes', EXP_TEXT_DOMAIN),
            'href' => admin_url('themes.php'),
            'parent' => $theme->get("TextDomain"),
            'meta' => array(
                'class' => '',
                'title' => esc_html__('Themes', EXP_TEXT_DOMAIN),
            )
        ]);
        $wp_admin_bar->add_node([
            'id' => 'exp-widgets',
            'title' => esc_html__('Widgets', EXP_TEXT_DOMAIN),
            'href' => admin_url('widgets.php'),
            'parent' => $theme->get("TextDomain"),
            'meta' => array(
                'class' => '',
                'title' => esc_html__('Widgets', EXP_TEXT_DOMAIN),
            )
        ]);
        $wp_admin_bar->add_node([
            'id' => 'exp-menus',
            'title' => esc_html__('Menus', EXP_TEXT_DOMAIN),
            'href' => admin_url('nav-menus.php'),
            'parent' => $theme->get("TextDomain"),
            'meta' => array(
                'class' => '',
                'title' => esc_html__('Menus', EXP_TEXT_DOMAIN),
            )
        ]);

    }

    public function remove_from_admin_bar($wp_admin_bar)
    {
        $wp_admin_bar->remove_node('site-name');
    }


    public function admin_notice_missing_main_plugin()
    {

        if (isset($_GET['activate'])) unset($_GET['activate']);

        $message = sprintf(
            esc_html__('"%1$s" requires "%2$s" to be installed and activated.', EXP_TEXT_DOMAIN),
            '<strong>' . $this->plugin_name . '</strong>',
            '<strong>' . esc_html__('Elementor Plugin', EXP_TEXT_DOMAIN) . '</strong>'
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);

    }

    public function admin_notice_minimum_elementor_version()
    {

        if (isset($_GET['activate'])) unset($_GET['activate']);

        $message = sprintf(
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', EXP_TEXT_DOMAIN),
            '<strong>' . $this->plugin_name . '</strong>',
            '<strong>' . esc_html__('Elementor Plugin', EXP_TEXT_DOMAIN) . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);

    }

    public function admin_notice_minimum_php_version()
    {

        if (isset($_GET['activate'])) unset($_GET['activate']);

        $message = sprintf(
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', EXP_TEXT_DOMAIN),
            '<strong>' . $this->plugin_name . '</strong>',
            '<strong>' . esc_html__('PHP', EXP_TEXT_DOMAIN) . '</strong>',
            self::MINIMUM_PHP_VERSION
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);

    }

    function redux_framework_notice()
    {
        $plugin_name = '<strong>' . $this->plugin_name . '</strong>';
        $redux_name = '<strong>' . esc_html__("Redux Framework", EXP_TEXT_DOMAIN) . '</strong>';

        echo '<div class="notice notice-warning is-dismissible">';
        echo '<p>';
        printf(
            esc_html__('%1$s require %2$s installed and activated. Please active %3$s plugin', EXP_TEXT_DOMAIN),
            $plugin_name,
            $redux_name,
            $redux_name
        );
        echo '</p>';
        printf('<button type="button" class="notice-dismiss"><span class="screen-reader-text">%s</span></button>', esc_html__('Dismiss this notice.', EXP_TEXT_DOMAIN));
        echo '</div>';
    }


}

function expertthemes()
{
    return Exptheme_Core::instance();
}

// Install
expertthemes();

Exptheme_Core::instance();