<?php $__env->startSection('title', $title ?? 'Ajouter un Gym'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content">
        <h2><?php echo e($title ?? 'Ajouter un nouveau Gym'); ?></h2>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.gyms.store')); ?>" method="POST" enctype="multipart/form-data" class="gym-form">
            <?php echo csrf_field(); ?>

            <div class="form-grid">
                <!-- Informations de base -->
                <div class="form-group">
                    <label for="informations">Nom du Gym *</label>
                    <input type="text" id="informations" name="informations" value="<?php echo e(old('informations')); ?>" required>
                </div>

                <div class="form-group">
                    <label for="specialite">Spécialité</label>
                    <input type="text" id="specialite" name="specialite" value="<?php echo e(old('specialite')); ?>" placeholder="Ex: Martial Arts, Fitness, CrossFit...">
                </div>

                <div class="form-group">
                    <label for="nationalite">Nationalité *</label>
                    <input type="text" id="nationalite" name="nationalite" value="<?php echo e(old('nationalite')); ?>" required>
                </div>

                <!-- Contact -->
                <div class="form-group">
                    <label for="adresse">Adresse *</label>
                    <textarea id="adresse" name="adresse" rows="2" required><?php echo e(old('adresse')); ?></textarea>
                </div>

                <div class="form-group">
                    <label for="tel">Téléphone *</label>
                    <input type="text" id="tel" name="tel" value="<?php echo e(old('tel')); ?>" required>
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" value="<?php echo e(old('email')); ?>">
                </div>

                <div class="form-group">
                    <label for="website">Site Web</label>
                    <input type="url" id="website" name="website" value="<?php echo e(old('website')); ?>" placeholder="https://...">
                </div>

                <!-- Description -->
                <div class="form-group full-width">
                    <label for="description">Description *</label>
                    <textarea id="description" name="description" rows="5" required><?php echo e(old('description')); ?></textarea>
                </div>

                <!-- Images -->
                <div class="form-group">
                    <label for="photo1">Photo 1</label>
                    <input type="file" id="photo1" name="photo1" accept="image/*">
                    <small>Format: JPG, PNG, GIF | Max: 2MB</small>
                </div>

                <div class="form-group">
                    <label for="photo2">Photo 2</label>
                    <input type="file" id="photo2" name="photo2" accept="image/*">
                    <small>Format: JPG, PNG, GIF | Max: 2MB</small>
                </div>

                <div class="form-group">
                    <label for="photo3">Photo 3</label>
                    <input type="file" id="photo3" name="photo3" accept="image/*">
                    <small>Format: JPG, PNG, GIF | Max: 2MB</small>
                </div>

                <!-- Validation -->
                <div class="form-group">
                    <label for="validate" class="checkbox-label">
                        <input type="checkbox" id="validate" name="validate" value="1" checked>
                        <span>Gym validé (visible sur le site)</span>
                    </label>
                </div>
            </div>

            <!-- Prévisualisation des images -->
            <div class="image-preview">
                <div class="preview-container" id="preview1">
                    <span>Aperçu Photo 1</span>
                </div>
                <div class="preview-container" id="preview2">
                    <span>Aperçu Photo 2</span>
                </div>
                <div class="preview-container" id="preview3">
                    <span>Aperçu Photo 3</span>
                </div>
            </div>

            <!-- Boutons -->
            <div class="form-actions">
                <button type="submit" class="btn-submit">
                    <i class="fas fa-plus"></i> Ajouter le Gym
                </button>
                <a href="<?php echo e(route('admin.gyms.index')); ?>" class="btn-cancel">
                    <i class="fas fa-times"></i> Annuler
                </a>
            </div>
        </form>
    </div>

    <style>
        .gym-form {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 16px rgba(0,0,0,0.08);
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group.full-width {
            grid-column: 1 / -1;
        }

        .form-group label {
            margin-bottom: 8px;
            font-weight: 500;
            color: #333;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: #D30402;
            box-shadow: 0 0 0 2px rgba(211,4,2,0.1);
        }

        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-group small {
            font-size: 12px;
            color: #666;
            margin-top: 4px;
        }

        .checkbox-label {
            display: flex;
            align-items: center;
            cursor: pointer;
        }

        .checkbox-label input {
            margin-right: 10px;
            width: 18px;
            height: 18px;
        }

        .image-preview {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin: 30px 0;
        }

        .preview-container {
            border: 2px dashed #ddd;
            border-radius: 8px;
            min-height: 150px;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            background: #f9f9f9;
        }

        .preview-container img {
            max-width: 100%;
            max-height: 150px;
            object-fit: cover;
        }

        .preview-container span {
            color: #999;
            font-size: 14px;
        }

        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }

        .btn-submit {
            background: #D30402;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 6px;
            font-weight: 500;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: background 0.3s;
        }

        .btn-submit:hover {
            background: #b90302;
        }

        .btn-cancel {
            background: #f0f0f0;
            color: #333;
            padding: 12px 30px;
            border-radius: 6px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: background 0.3s;
        }

        .btn-cancel:hover {
            background: #e0e0e0;
        }

        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr;
            }

            .image-preview {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <script>
        // Prévisualisation des images
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.innerHTML = `<img src="${e.target.result}" alt="Aperçu">`;
                }
                reader.readAsDataURL(input.files[0]);
            } else {
                preview.innerHTML = '<span>Aperçu ' + previewId.replace('preview', 'Photo ') + '</span>';
            }
        }

        // Écouteurs pour les inputs de fichiers
        document.getElementById('photo1').addEventListener('change', function() {
            previewImage(this, 'preview1');
        });

        document.getElementById('photo2').addEventListener('change', function() {
            previewImage(this, 'preview2');
        });

        document.getElementById('photo3').addEventListener('change', function() {
            previewImage(this, 'preview3');
        });

        // Confirmation avant soumission
        document.querySelector('.gym-form').addEventListener('submit', function(e) {
            const gymName = document.getElementById('informations').value;
            if (!gymName.trim()) {
                e.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'Nom requis',
                    text: 'Veuillez saisir le nom du gym.',
                    confirmButtonColor: '#D30402'
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kyukusu/www/app/project/resources/views/admin/register_gym/create_gym.blade.php ENDPATH**/ ?>