<!DOCTYPE html>
<html lang="en-US" class="no-js">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Member Details - Kyukushin Self Defense Global Federation</title>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#dc2626', // Rouge Kyukushin
                        secondary: '#1f2937',
                        accent: '#f59e0b'
                    }
                }
            }
        }
    </script>

    <style>
        /* Styles professionnels additionnels */
        .member-card {
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            transition: all 0.3s ease;
        }

        .member-card:hover {
            box-shadow: 0 20px 40px -10px rgba(0, 0, 0, 0.15);
        }

        .info-label {
            color: #6b7280;
            font-size: 0.875rem;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .info-value {
            color: #111827;
            font-weight: 500;
        }

        .status-badge {
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.875rem;
            font-weight: 600;
            letter-spacing: 0.025em;
        }

        .certificate-preview {
            border: 1px solid #e5e7eb;
            border-radius: 0.75rem;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .certificate-preview:hover {
            border-color: #dc2626;
            transform: translateY(-2px);
        }

        .flag-container {
            border: 2px solid #e5e7eb;
            border-radius: 0.5rem;
            overflow: hidden;
            width: 80px;
            height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .section-title {
            position: relative;
            padding-left: 1rem;
        }

        .section-title::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background-color: #dc2626;
            border-radius: 2px;
        }

        /* Animation pour les statuts */
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }

        .status-pending {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
    </style>
</head>
<body class="bg-gray-50">
<div class="min-h-screen">
    <!-- Conteneur principal -->
    <div class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <!-- En-tête avec navigation -->
        <div class="mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Member Profile</h1>
                    <p class="text-gray-600 mt-2">Detailed information about federation member</p>
                </div>
                <a href="/registred-members/"
                   class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 transition duration-150">
                    ← Back to Members
                </a>
            </div>
        </div>

        <!-- Carte principale -->
        <div class="bg-white member-card rounded-2xl overflow-hidden">
            <!-- Bande supérieure avec couleur d'accent -->
            <div class="h-2 bg-gradient-to-r from-primary to-accent"></div>

            <div class="p-8">
                <!-- En-tête du profil -->
                <div class="flex flex-col lg:flex-row gap-8 mb-12">
                    <!-- Photo et informations basiques -->
                    <div class="flex-1">
                        <div class="flex flex-col sm:flex-row items-start sm:items-center gap-6">
                            <!-- Photo de profil -->
                            <div class="relative">
                                <div class="relative">
                                    <?php if($member->photo1): ?>
                                        <img src="data:image/png;base64,<?php echo e(base64_encode($member->photo1)); ?>"
                                             alt="<?php echo e($member->prenom); ?> <?php echo e($member->nom); ?>"
                                             class="w-40 h-40 rounded-2xl object-cover border-4 border-white shadow-xl">
                                    <?php else: ?>
                                        <div class="w-40 h-40 rounded-2xl bg-gradient-to-br from-gray-200 to-gray-300 flex items-center justify-center border-4 border-white shadow-xl">
                                            <div class="text-center">
                                                <svg class="w-16 h-16 text-gray-400 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                </svg>
                                                <span class="text-gray-500 text-sm mt-2 block">No photo</span>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <!-- Badge de statut sur la photo -->
                                    <div class="absolute -bottom-3 -right-3">
                                        <?php if($member->validate): ?>
                                            <span class="status-badge bg-green-100 text-green-800 shadow">
                                                    <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                                    </svg>
                                                    Verified
                                                </span>
                                        <?php else: ?>
                                            <span class="status-badge status-pending bg-yellow-100 text-yellow-800 shadow">
                                                    <svg class="w-4 h-4 inline mr-1 animate-spin" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                                                    </svg>
                                                    Pending
                                                </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Informations principales -->
                            <div class="flex-1">
                                <div class="mb-4">
                                    <div class="flex items-start justify-between">
                                        <div>
                                            <h2 class="text-3xl font-bold text-gray-900"><?php echo e($member->prenom); ?> <?php echo e($member->nom); ?></h2>
                                            <p class="text-lg text-primary font-semibold mt-1"><?php echo e($member->role); ?></p>
                                        </div>
                                        <!-- Federation Logo -->
                                        <div class="ml-4 flex-shrink-0">
                                            <img src="https://kyukushin-self-defense-global-federation.com/wp-content/uploads/2025/06/logo-kyukushin-self-defense-global-federation.png"
                                                 alt="Kyukushin Self Defense Global Federation Logo"
                                                 class="w-48 h-auto max-w-xs object-contain"
                                                 onerror="this.style.display='none'">
                                        </div>
                                    </div>

                                    <!-- Drapeau et nationalité -->
                                    <div class="flex items-center gap-3 mt-4">
                                        <?php if($member->country_code): ?>
                                            <div class="flag-container shadow-sm">
                                                <img src="https://flagcdn.com/w80/<?php echo e(strtolower($member->country_code)); ?>.png"
                                                     alt="<?php echo e($member->nationalite); ?>"
                                                     class="w-full h-full object-cover"
                                                     onerror="this.style.display='none'">
                                            </div>
                                        <?php endif; ?>
                                        <div>
                                            <span class="text-gray-600"><?php echo e($member->nationalite ?? 'Nationality not specified'); ?></span>
                                            <?php if($member->degree): ?>
                                                <div class="flex items-center gap-2 mt-1">
                                                    <svg class="w-4 h-4 text-accent" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M10 12a2 2 0 100-4 2 2 0 000 4z" />
                                                        <path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd" />
                                                    </svg>
                                                    <span class="text-sm font-medium text-gray-700"><?php echo e($member->degree); ?></span>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- ID et niveau -->
                                <div class="grid grid-cols-2 gap-4 mt-6">
                                    <div class="bg-gray-50 rounded-lg p-3">
                                        <p class="info-label">Member ID</p>
                                        <p class="info-value text-lg font-mono"><?php echo e($member->matricule ?? 'N/A'); ?></p>
                                    </div>
                                    <?php if($member->level): ?>
                                        <div class="bg-gray-50 rounded-lg p-3">
                                            <p class="info-label">Rank/Level</p>
                                            <p class="info-value text-lg"><?php echo e($member->level); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Grille d'informations -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-12">
                    <!-- Informations de contact -->
                    <div class="bg-gray-50 rounded-xl p-6">
                        <h3 class="section-title text-xl font-bold text-gray-900 mb-6">Contact Information</h3>
                        <div class="space-y-4">
                            <div class="flex items-start">
                                <svg class="w-5 h-5 text-gray-400 mt-0.5 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd" />
                                </svg>
                                <div>
                                    <p class="info-label">Address</p>
                                    <p class="info-value"><?php echo e($member->adresse ?? 'Not specified'); ?></p>
                                </div>
                            </div>

                            <div class="flex items-start">
                                <svg class="w-5 h-5 text-gray-400 mt-0.5 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z" />
                                </svg>
                                <div>
                                    <p class="info-label">Phone</p>
                                    <a href="tel:<?php echo e($member->tel); ?>" class="info-value hover:text-primary transition duration-150">
                                        <?php echo e($member->tel ?? 'Not specified'); ?>

                                    </a>
                                </div>
                            </div>

                            <div class="flex items-start">
                                <svg class="w-5 h-5 text-gray-400 mt-0.5 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z" />
                                    <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z" />
                                </svg>
                                <div>
                                    <p class="info-label">Email</p>
                                    <a href="mailto:<?php echo e($member->email); ?>" class="info-value hover:text-primary transition duration-150 break-all">
                                        <?php echo e($member->email ?? 'Not specified'); ?>

                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Informations de la fédération -->
                    <div class="bg-gray-50 rounded-xl p-6">
                        <h3 class="section-title text-xl font-bold text-gray-900 mb-6">Federation Details</h3>
                        <div class="space-y-4">
                            <div>
                                <p class="info-label">Membership Type</p>
                                <p class="info-value capitalize"><?php echo e($member->role ?? 'Not specified'); ?></p>
                            </div>

                            <div>
                                <p class="info-label">Registration Date</p>
                                <p class="info-value"><?php echo e($member->created_at ? \Carbon\Carbon::parse($member->created_at)->format('F d, Y') : 'N/A'); ?></p>
                            </div>

                            <div>
                                <p class="info-label">Last Updated</p>
                                <p class="info-value"><?php echo e($member->updated_at ? \Carbon\Carbon::parse($member->updated_at)->format('F d, Y') : 'N/A'); ?></p>
                            </div>

                            <div>
                                <p class="info-label">Status</p>
                                <div class="mt-2">
                                    <?php if($member->validate): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                                <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                                </svg>
                                                Active & Verified
                                            </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-yellow-100 text-yellow-800">
                                                <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                                                </svg>
                                                Pending Approval
                                            </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Section certificat -->
                <div class="mb-12">
                    <div class="flex items-center justify-between mb-6">
                        <h3 class="section-title text-xl font-bold text-gray-900">Certification</h3>
                        <?php if($member->validate): ?>
                            <span class="text-sm text-green-600 font-medium">
                                    <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                    </svg>
                                    Certificate Validated
                                </span>
                        <?php endif; ?>
                    </div>

                    <?php if($member->certificat): ?>
                        <div class="bg-gradient-to-br from-gray-50 to-white border border-gray-200 rounded-xl p-6">
                            <div class="flex flex-col md:flex-row gap-6 items-center">
                                <div class="certificate-preview flex-shrink-0">
                                    <div class="w-64 h-48 bg-gradient-to-br from-primary/10 to-accent/10 flex items-center justify-center">
                                        <div class="text-center">
                                            <svg class="w-16 h-16 text-primary mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                            </svg>
                                            <p class="text-gray-600 font-medium">Member Certificate</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="flex-1">
                                    <h4 class="text-lg font-semibold text-gray-900 mb-2">Kyukushin Self Defense Global Federation</h4>
                                    <p class="text-gray-600 mb-4">Official membership certificate issued by the federation</p>

                                    <div class="flex flex-wrap gap-3">
                                        <button onclick="openCertificate('<?php echo e(asset('project/storage/app/public/' . $member->certificat)); ?>')"
                                                class="inline-flex items-center px-4 py-2 bg-primary text-white rounded-lg hover:bg-red-700 transition duration-150 shadow">
                                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z" clip-rule="evenodd" />
                                            </svg>
                                            View Certificate
                                        </button>









                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="bg-gradient-to-br from-gray-50 to-white border border-gray-200 rounded-xl p-8 text-center">
                            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                            </svg>
                            <h4 class="text-lg font-semibold text-gray-700 mb-2">No Certificate Available</h4>
                            <p class="text-gray-500">Certificate has not been uploaded or issued yet.</p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Actions -->
                <div class="border-t border-gray-200 pt-8">
                    <div class="flex flex-col sm:flex-row justify-between items-center gap-4">
                        <div class="text-sm text-gray-500">
                            Member ID: <span class="font-mono font-medium"><?php echo e($member->matricule ?? 'N/A'); ?></span>
                            • Last updated: <?php echo e($member->updated_at ? \Carbon\Carbon::parse($member->updated_at)->format('M d, Y') : 'N/A'); ?>

                        </div>

                        <div class="flex gap-3">
















                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Note de bas de page -->
        <div class="mt-8 text-center text-sm text-gray-500">
            <p>© <?php echo e(date('Y')); ?> Kyukushin Self Defense Global Federation. All rights reserved.</p>
            <p class="mt-1">This information is confidential and intended for federation use only.</p>
        </div>
    </div>
</div>

<script>
    function openCertificate(url) {
        window.open(url, '_blank', 'noopener,noreferrer');
    }

    // Animation pour le statut "pending"
    document.addEventListener('DOMContentLoaded', function() {
        const pendingBadge = document.querySelector('.status-pending');
        if (pendingBadge) {
            setInterval(() => {
                pendingBadge.classList.toggle('opacity-70');
            }, 1000);
        }
    });

    // Fonction pour ajuster la hauteur de l'iframe parent
    function sendHeight() {
        const height = document.documentElement.scrollHeight;
        window.parent.postMessage({
            type: 'resize',
            height: height
        }, '*');
    }

    // Observer les changements et envoyer la hauteur
    window.addEventListener('load', sendHeight);
    window.addEventListener('resize', sendHeight);

    const observer = new MutationObserver(sendHeight);
    observer.observe(document.body, {
        childList: true,
        subtree: true,
        attributes: true,
        characterData: true
    });
</script>
</body>
</html><?php /**PATH /home/kyukusu/www/app/project/resources/views/pages/register_member/detail.blade.php ENDPATH**/ ?>