<?php $__env->startSection('title', $title ?? 'Liste des Gyms'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h2><?php echo e($title ?? 'Gyms enregistrés'); ?></h2>
            <a href="<?php echo e(route('admin.gyms.create')); ?>" class="btn-add">
                <i class="fas fa-plus"></i> Ajouter un Gym
            </a>
        </div>

        <?php if(session('success')): ?>
            <script>
                Swal.fire({
                    icon: 'success',
                    title: 'Done!',
                    text: '<?php echo e(session('success')); ?>',
                    confirmButtonColor: '#D30402'
                });
            </script>
        <?php endif; ?>

        <?php if($gyms->count() > 0): ?>
            <table>
                <thead>
                <tr>
                    <?php $__currentLoopData = array_keys($gyms->first()->getAttributes()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!in_array($column, ['created_at', 'updated_at'])): ?>
                            <th><?php echo e(ucfirst($column)); ?></th>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th>Actions</th>
                </tr>
                </thead>

                <tbody>
                <?php $__currentLoopData = $gyms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gym): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>

                        <?php $__currentLoopData = $gym->getAttributes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!in_array($key, ['created_at', 'updated_at'])): ?>
                                
                                <?php if($key === 'validate'): ?>
                                    <td>
                                        <?php if($value === 1): ?>
                                            <span class="status-validated">Validé</span>
                                        <?php elseif($value === 0): ?>
                                            <span class="status-refused">Refusé</span>
                                        <?php else: ?>
                                            <span class="status-pending">En attente</span>
                                        <?php endif; ?>
                                    </td>

                                    
                                <?php elseif(in_array($key, ['photo1', 'photo2', 'photo3'])): ?>
                                    <td>
                                        <?php if($value): ?>
                                            <img src="data:image/jpeg;base64,<?php echo e(base64_encode($value)); ?>"
                                                 alt="Image du gym"
                                                 width="80"
                                                 height="80"
                                                 style="object-fit: cover; border-radius: 8px; box-shadow: 0 0 4px rgba(0,0,0,0.2);">
                                        <?php else: ?>
                                            <span>Aucune image</span>
                                        <?php endif; ?>
                                    </td>

                                    
                                <?php else: ?>
                                    <td><?php echo e(Str::limit($value, 50)); ?></td>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            
                            <td class="action-buttons">
                                <!-- Bouton Modifier -->
                                <a href="<?php echo e(route('admin.gyms.edit', $gym->id)); ?>" class="btn-edit" title="Modifier">
                                    <i class="fas fa-edit"></i> Modifier
                                </a>

                                <!-- Boutons Valider/Refuser -->
                                <?php if($gym->validate !== 1): ?>
                                    <a href="<?php echo e(route('admin.gyms.validate', $gym->id)); ?>" class="btn-validate" data-id="<?php echo e($gym->id); ?>">
                                        <i class="fas fa-check"></i> Valider
                                    </a>
                                <?php endif; ?>
                                <?php if($gym->validate !== 0): ?>
                                    <a href="<?php echo e(route('admin.gyms.validate', $gym->id)); ?>" class="btn-refuse" data-id="<?php echo e($gym->id); ?>">
                                        <i class="fas fa-times"></i> Refuser
                                    </a>
                                <?php endif; ?>

                                <!-- Bouton Supprimer -->
                                <a href="<?php echo e(route('admin.gyms.destroy', $gym->id)); ?>" class="btn-delete" onclick="return confirmDelete()" title="Supprimer">
                                    <i class="fas fa-trash"></i> Supprimer
                                </a>
                            </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="no-data">
                <p>Aucun gym trouvé.</p>
                <a href="<?php echo e(route('admin.gyms.create')); ?>" class="btn-add">
                    <i class="fas fa-plus"></i> Ajouter votre premier gym
                </a>
            </div>
        <?php endif; ?>
    </div>

    <style>
        .btn-add {
            background: #D30402;
            color: white;
            padding: 10px 20px;
            border-radius: 6px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            font-weight: 500;
            transition: background 0.3s;
        }

        .btn-add:hover {
            background: #b90302;
            color: white;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            background: #f9f9f9;
            border-radius: 8px;
        }

        .btn-delete {
            background: #dc3545;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 12px;
        }

        .btn-delete:hover {
            background: #c82333;
            color: white;
        }
    </style>

    <script>
        function confirmDelete() {
            return confirm('Êtes-vous sûr de vouloir supprimer ce gym ? Cette action est irréversible.');
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kyukusu/www/app/project/resources/views/admin/register_gym/liste_gyms.blade.php ENDPATH**/ ?>