<!doctype html>
<html lang="fr">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Registered Members</title>
    <style>
        :root {
            --bg: #FBFBFB;
            --muted: #8C8570;
            --brown: #5C3F17;
            --accent: #D30402;
            --card-radius: 14px;
            --gap: 20px;
            --max-width: 1200px;
            --shadow: 0 8px 24px rgba(92,63,23,0.08);
        }

        * { box-sizing: border-box }
        body {
            margin: 0;
            font-family: Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
            background: linear-gradient(180deg, var(--bg) 0%, #F7F6F3 100%);
            color: #222;
            padding: 40px 20px;
        }

        .container { max-width: var(--max-width); margin: 0 auto; }

        header { text-align: center; margin-bottom: 30px; }
        h1 { color: var(--brown); font-size: 26px; margin-bottom: 6px; }
        p.lead { color: var(--muted); }

        /* Styles pour les filtres - Full Width */
        .filters {
            background: white;
            border-radius: var(--card-radius);
            padding: 30px;
            margin: 0 0 30px 0;
            box-shadow: var(--shadow);
            width: 100%;
        }

        .filter-form {
            display: grid;
            grid-template-columns: 1fr 1fr auto;
            gap: 20px;
            align-items: end;
            width: 100%;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
            gap: 8px;
            width: 100%;
        }

        .filter-group label {
            font-size: 14px;
            color: var(--brown);
            font-weight: 500;
        }

        .filter-input,
        .filter-select {
            padding: 12px 16px;
            border: 1px solid rgba(92,63,23,0.2);
            border-radius: 8px;
            font-size: 15px;
            background: white;
            color: #333;
            width: 100%;
            height: 46px;
        }

        .filter-input:focus,
        .filter-select:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(211,4,2,0.1);
        }

        .filter-button {
            padding: 12px 30px;
            background: var(--accent);
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
            height: 46px;
            min-width: 120px;
            font-size: 15px;
        }

        .filter-button:hover {
            background: #b90302;
            transform: translateY(-1px);
        }

        .clear-filters {
            padding: 12px 20px;
            background: transparent;
            color: var(--muted);
            border: 1px solid rgba(92,63,23,0.2);
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            height: 46px;
            transition: all 0.2s;
        }

        .clear-filters:hover {
            background: rgba(92,63,23,0.05);
            border-color: rgba(92,63,23,0.3);
        }

        .button-group {
            display: flex;
            gap: 12px;
            align-items: center;
            height: 46px;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: var(--gap);
        }

        .card {
            background: linear-gradient(180deg, white, #fffaf6);
            border-radius: var(--card-radius);
            padding: 16px;
            box-shadow: var(--shadow);
            border: 1px solid rgba(92,63,23,0.06);
            display: flex;
            flex-direction: column;
            gap: 12px;
            transition: transform 0.3s ease;
        }

        .card .photos {
            display: flex;
            gap: 8px;
        }

        .card .photos img {
            width: 100%;
            height: 300px;
            object-fit: contain;
            border-radius: 8px;
        }

        .card h3 {
            margin: 6px 0 0;
            font-size: 18px;
            color: var(--brown);
        }

        .card p.desc {
            margin: 6px 0 0;
            color: var(--muted);
            font-size: 14px;
            line-height: 1.4;
        }

        .card:hover {
            transform: translateY(-6px);
        }

        .no-results {
            text-align: center;
            padding: 60px;
            color: var(--muted);
            font-size: 16px;
            grid-column: 1 / -1;
            background: white;
            border-radius: var(--card-radius);
            box-shadow: var(--shadow);
        }

        .welcome-message {
            text-align: center;
            padding: 60px;
            color: var(--muted);
            font-size: 16px;
            background: white;
            border-radius: var(--card-radius);
            box-shadow: var(--shadow);
            margin-top: 20px;
        }

        .welcome-message h2 {
            color: var(--brown);
            margin-bottom: 15px;
            font-size: 22px;
        }

        .results-count {
            text-align: center;
            margin-bottom: 20px;
            color: var(--muted);
            font-size: 14px;
            background: rgba(92,63,23,0.05);
            padding: 8px 16px;
            border-radius: 20px;
            display: inline-block;
        }

        .pagination {
            grid-column: 1 / -1;
            text-align: center;
            margin-top: 40px;
        }

        @media (max-width: 768px) {
            .filter-form {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .button-group {
                flex-direction: column;
                height: auto;
                gap: 10px;
            }

            .filter-button,
            .clear-filters {
                width: 100%;
                text-align: center;
            }

            .filters {
                padding: 20px;
            }

            body {
                padding: 20px 15px;
            }
        }

        @media (max-width: 480px) {
            .grid {
                grid-template-columns: 1fr;
            }

            .card .photos img {
                height: 250px;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <header>
        <h1>Our Registered Members</h1>
        <p class="lead">Discover all our Registered Members.</p>
    </header>

    <!-- Section des filtres - Full Width -->
    <div class="filters">
        <form method="GET" action="{{ route('register_member.liste') }}" class="filter-form">
            <div class="filter-group">
                <label for="search">Search Members</label>
                <input type="text"
                       id="search"
                       name="search"
                       class="filter-input"
                       placeholder="Search by name, email, phone or ID..."
                       value="{{ request('search') }}">
            </div>

            <div class="filter-group">
                <label for="role">Filter by Role</label>
                <select id="role" name="role" class="filter-select">
                    <option value="all">All Roles</option>
                    @foreach($roles as $role)
                        <option value="{{ $role }}" {{ request('role') == $role ? 'selected' : '' }}>
                            {{ $role }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="button-group">
                <button type="submit" class="filter-button">
                    Search Members
                </button>

                @if($hasFilter)
                    <a href="{{ route('register_member.liste') }}" class="clear-filters">
                        Clear Filters
                    </a>
                @endif
            </div>
        </form>
    </div>

    <!-- Messages et Résultats -->
    <main>
        @if(!$showResults)
            <!-- Message d'accueil quand aucun filtre n'est appliqué -->
            <div class="welcome-message">
                <h2>🔍 Start Your Search</h2>
                <p>Use the filters above to find registered members.</p>
                <p style="margin-top: 15px; font-size: 14px; opacity: 0.8;">
                    You can search by name, email, phone, ID, or filter by role.
                </p>
            </div>
        @else
            <!-- Résultats après application de filtres -->
            @if($RegisterMembers->count() > 0)
                <!-- Compteur de résultats -->
                <div style="text-align: center; margin-bottom: 20px;">
                    <span class="results-count">
                        {{ $RegisterMembers->total() }} member(s) found
                        @if(request()->has('search') && !empty(request('search')))
                            for "{{ request('search') }}"
                        @endif
                        @if(request()->has('role') && request('role') != 'all')
                            in role "{{ request('role') }}"
                        @endif
                    </span>
                </div>

                <!-- Grille des membres -->
                <div class="grid">
                    @foreach($RegisterMembers as $RegisterMember)
                        <article class="card">
                            <div class="photos">
                                @if($RegisterMember->photo1)
                                    <img src="data:image/jpeg;base64,{{ base64_encode($RegisterMember->photo1) }}" alt="photo gym 1">
                                @endif
                                @if($RegisterMember->photo2)
                                    <img src="data:image/jpeg;base64,{{ base64_encode($RegisterMember->photo2) }}" alt="photo gym 2">
                                @endif
                                @if($RegisterMember->photo3)
                                    <img src="data:image/jpeg;base64,{{ base64_encode($RegisterMember->photo3) }}" alt="photo gym 3">
                                @endif
                            </div>

                            <h3>
                                <a href="{{ route('register_member.profile.show', ['id' => $RegisterMember->id, 'nom' => Str::slug($RegisterMember->nom)]) }}" target="_parent">
                                    {{ $RegisterMember->nom }} {{ $RegisterMember->prenom }}
                                </a>
                            </h3>

                            <p class="desc">
                                <strong>Nationality:</strong> {{ $RegisterMember->nationalite }}<br>
                                <strong>Register Number:</strong> {{ $RegisterMember->matricule }}<br>
                                <strong>Member type:</strong> <span style="color: var(--accent); font-weight: 500;">{{ $RegisterMember->role }}</span>
                            </p>

                            <p style="font-size:13px;color:var(--muted);margin-top:auto;">
                                📍 {{ $RegisterMember->adresse ?? 'Address not specified' }}<br>
                                ☎️ {{ $RegisterMember->tel ?? '-' }}<br>
                                📧 {{ $RegisterMember->email ?? 'N/A' }}
                            </p>
                        </article>
                    @endforeach
                </div>

                <!-- Pagination -->
                @if($RegisterMembers->hasPages())
                    <div class="pagination">
                        {{ $RegisterMembers->links() }}
                    </div>
                @endif

            @else
                <!-- Aucun résultat trouvé -->
                <div class="no-results">
                    <p style="font-size: 18px; margin-bottom: 10px;">No members found matching your criteria.</p>
                    <p style="margin-bottom: 20px;">
                        @if(request()->has('search') && !empty(request('search')))
                            Search: "{{ request('search') }}"
                        @endif
                        @if(request()->has('role') && request('role') != 'all')
                            Role: "{{ request('role') }}"
                        @endif
                    </p>
                    <p style="margin-bottom: 20px;">Try modifying your search or filters.</p>
                    <a href="{{ route('register_member.liste') }}" class="filter-button" style="text-decoration: none; display: inline-block;">
                        Show All Members
                    </a>
                </div>
            @endif
        @endif
    </main>

</div>

<script>
    function sendHeight() {
        const height = document.documentElement.scrollHeight;
        window.parent.postMessage({ type: 'resize', height: height }, '*');
    }

    // Envoyer la hauteur au chargement et à chaque redimensionnement
    window.addEventListener('load', sendHeight);
    window.addEventListener('resize', sendHeight);

    // Observer les changements de contenu
    const observer = new MutationObserver(sendHeight);
    observer.observe(document.body, { childList: true, subtree: true });

    // Auto-submit sur changement de sélection
    document.getElementById('role').addEventListener('change', function() {
        this.form.submit();
    });

    // Soumettre le formulaire en appuyant sur Enter dans la barre de recherche
    document.getElementById('search').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            this.form.submit();
        }
    });

    // Focus sur le champ de recherche au chargement
    document.addEventListener('DOMContentLoaded', function() {
        const searchField = document.getElementById('search');
        if (searchField && !searchField.value) {
            searchField.focus();
        }
    });
</script>
</body>
</html>