<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Formulaire d'inscription</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            background-color: transparent;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .form-container {
            background: white;
            padding: 40px 30px;
            border-radius: 20px;
            box-shadow: 0 6px 20px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 600px;
        }

        .form-container h2 {
            text-align: center;
            color: #5C3F17;
            margin-bottom: 25px;
        }

        form {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group.full-width {
            grid-column: span 2;
        }

        label {
            margin-bottom: 6px;
            font-weight: 500;
            color: #5C3F17;
        }

        input, select {
            padding: 12px;
            border: 1px solid #8C8570;
            border-radius: 8px;
            background-color: #FBFBFB;
            font-size: 14px;
            outline: none;
            transition: border 0.3s;
        }

        input:focus, select:focus {
            border-color: #D30402;
        }

        .file-upload {
            position: relative;
            border: 2px dashed #8C8570;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            border-radius: 10px;
            background-color: #FBFBFB;
            transition: border 0.3s, background 0.3s;
        }

        .file-upload:hover {
            border-color: #D30402;
            background-color: #fff5f5;
        }

        .file-upload input {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            cursor: pointer;
        }

        button {
            grid-column: span 2;
            padding: 14px;
            border: none;
            border-radius: 8px;
            background-color: #D30402;
            color: white;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s;
        }

        button:hover {
            background-color: #b90302;
        }

        .preview {
            margin-top: 10px;
            display: flex;
            justify-content: center;
        }

        .preview img {
            max-width: 200px;
            max-height: 200px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .certificate-preview {
            margin-top: 10px;
            padding: 15px;
            border: 1px solid #8C8570;
            border-radius: 8px;
            background-color: #FBFBFB;
        }

        .certificate-preview p {
            margin: 5px 0;
            color: #5C3F17;
        }

        @media (max-width: 600px) {
            form {
                grid-template-columns: 1fr;
            }
            button {
                grid-column: span 1;
            }
        }
    </style>
</head>
<body>
<div class="form-container">
    <h2>Coach Body Guard </h2>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    @if (session('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Done!',
                text: '{{ session('success') }}',
                confirmButtonColor: '#D30402'
            });
        </script>
    @endif
    <form action="{{ route('register_member.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="form-group full-width">
            <label>Your Photo</label>
            <div class="file-upload">
                <span>📁 Click or drag an image here</span>
                <input type="file" name="photo1" accept="image/*" onchange="previewImage(event, 'preview1')" />
            </div>
            <div class="preview" id="preview1"></div>
        </div>

{{--        <!-- Photo 2 -->--}}
{{--        <div class="form-group full-width">--}}
{{--            <label>Photo 2</label>--}}
{{--            <div class="file-upload">--}}
{{--                <span>📁 Click or drag an image here</span>--}}
{{--                <input type="file" name="photo2" accept="image/*" onchange="previewImage(event, 'preview2')" />--}}
{{--            </div>--}}
{{--            <div class="preview" id="preview2"></div>--}}
{{--        </div>--}}

{{--        <!-- Photo 3 -->--}}
{{--        <div class="form-group full-width">--}}
{{--            <label>Photo 3</label>--}}
{{--            <div class="file-upload">--}}
{{--                <span>📁 Click or drag an image here</span>--}}
{{--                <input type="file" name="photo3" accept="image/*" onchange="previewImage(event, 'preview3')" />--}}
{{--            </div>--}}
{{--            <div class="preview" id="preview3"></div>--}}
{{--        </div>--}}
        <div class="form-group full-width">
            <label for="nom">First Name (*)</label>
            <input type="text" id="nom" name="nom" required />
        </div>

        <div class="form-group full-width">
            <label for="prenom">Last Name (*)</label>
            <input type="text" id="prenom" name="prenom" required />
        </div>

        <div class="form-group full-width">
            <label for="adresse">Adress (*)</label>
            <input type="text" id="adresse" name="adresse" required />
        </div>

        <div class="form-group full-width">
            <label for="tel">Phone (*)</label>
            <input type="tel" id="tel" name="tel" required />
        </div>

        <div class="form-group full-width">
            <label for="email">E-mail</label>
            <input type="email" id="email" name="email" placeholder="exemple@mail.com" />
        </div>

        <div class="form-group full-width">
            <label for="nationalite">Nationality (*)</label>
            <select id="nationalite" name="nationalite" required>
                <option value="">-- Select your country --</option>
                <option value="Afghanistan">🇦🇫 Afghanistan</option>
                <option value="South Africa">🇿🇦 South Africa</option>
                <option value="Albania">🇦🇱 Albania</option>
                <option value="Algeria">🇩🇿 Algeria</option>
                <option value="Germany">🇩🇪 Germany</option>
                <option value="Andorra">🇦🇩 Andorra</option>
                <option value="Angola">🇦🇴 Angola</option>
                <option value="Antigua and Barbuda">🇦🇬 Antigua and Barbuda</option>
                <option value="Saudi Arabia">🇸🇦 Saudi Arabia</option>
                <option value="Argentina">🇦🇷 Argentina</option>
                <option value="Armenia">🇦🇲 Armenia</option>
                <option value="Australia">🇦🇺 Australia</option>
                <option value="Austria">🇦🇹 Austria</option>
                <option value="Azerbaijan">🇦🇿 Azerbaijan</option>
                <option value="Bahamas">🇧🇸 Bahamas</option>
                <option value="Bahrain">🇧🇭 Bahrain</option>
                <option value="Bangladesh">🇧🇩 Bangladesh</option>
                <option value="Barbados">🇧🇧 Barbados</option>
                <option value="Belgium">🇧🇪 Belgium</option>
                <option value="Belize">🇧🇿 Belize</option>
                <option value="Benin">🇧🇯 Benin</option>
                <option value="Bhutan">🇧🇹 Bhutan</option>
                <option value="Belarus">🇧🇾 Belarus</option>
                <option value="Myanmar">🇲🇲 Myanmar</option>
                <option value="Bolivia">🇧🇴 Bolivia</option>
                <option value="Bosnia and Herzegovina">🇧🇦 Bosnia and Herzegovina</option>
                <option value="Botswana">🇧🇼 Botswana</option>
                <option value="Brazil">🇧🇷 Brazil</option>
                <option value="Brunei">🇧🇳 Brunei</option>
                <option value="Bulgaria">🇧🇬 Bulgaria</option>
                <option value="Burkina Faso">🇧🇫 Burkina Faso</option>
                <option value="Burundi">🇧🇮 Burundi</option>
                <option value="Cambodia">🇰🇭 Cambodia</option>
                <option value="Cameroon">🇨🇲 Cameroon</option>
                <option value="Canada">🇨🇦 Canada</option>
                <option value="Cape Verde">🇨🇻 Cape Verde</option>
                <option value="Central African Republic">🇨🇫 Central African Republic</option>
                <option value="Chile">🇨🇱 Chile</option>
                <option value="China">🇨🇳 China</option>
                <option value="Cyprus">🇨🇾 Cyprus</option>
                <option value="Colombia">🇨🇴 Colombia</option>
                <option value="Comoros">🇰🇲 Comoros</option>
                <option value="Congo">🇨🇬 Congo</option>
                <option value="Democratic Republic of Congo">🇨🇩 Democratic Republic of Congo</option>
                <option value="North Korea">🇰🇵 North Korea</option>
                <option value="South Korea">🇰🇷 South Korea</option>
                <option value="Costa Rica">🇨🇷 Costa Rica</option>
                <option value="Ivory Coast">🇨🇮 Ivory Coast</option>
                <option value="Croatia">🇭🇷 Croatia</option>
                <option value="Cuba">🇨🇺 Cuba</option>
                <option value="Denmark">🇩🇰 Denmark</option>
                <option value="Djibouti">🇩🇯 Djibouti</option>
                <option value="Dominica">🇩🇲 Dominica</option>
                <option value="Egypt">🇪🇬 Egypt</option>
                <option value="United Arab Emirates">🇦🇪 United Arab Emirates</option>
                <option value="Ecuador">🇪🇨 Ecuador</option>
                <option value="Eritrea">🇪🇷 Eritrea</option>
                <option value="Spain">🇪🇸 Spain</option>
                <option value="Estonia">🇪🇪 Estonia</option>
                <option value="United States">🇺🇸 United States</option>
                <option value="Ethiopia">🇪🇹 Ethiopia</option>
                <option value="Fiji">🇫🇯 Fiji</option>
                <option value="Finland">🇫🇮 Finland</option>
                <option value="France">🇫🇷 France</option>
                <option value="Gabon">🇬🇦 Gabon</option>
                <option value="Gambia">🇬🇲 Gambia</option>
                <option value="Georgia">🇬🇪 Georgia</option>
                <option value="Ghana">🇬🇭 Ghana</option>
                <option value="Greece">🇬🇷 Greece</option>
                <option value="Grenada">🇬🇩 Grenada</option>
                <option value="Guatemala">🇬🇹 Guatemala</option>
                <option value="Guinea">🇬🇳 Guinea</option>
                <option value="Equatorial Guinea">🇬🇶 Equatorial Guinea</option>
                <option value="Guinea-Bissau">🇬🇼 Guinea-Bissau</option>
                <option value="Guyana">🇬🇾 Guyana</option>
                <option value="Haiti">🇭🇹 Haiti</option>
                <option value="Honduras">🇭🇳 Honduras</option>
                <option value="Hungary">🇭🇺 Hungary</option>
                <option value="India">🇮🇳 India</option>
                <option value="Indonesia">🇮🇩 Indonesia</option>
                <option value="Iraq">🇮🇶 Iraq</option>
                <option value="Iran">🇮🇷 Iran</option>
                <option value="Ireland">🇮🇪 Ireland</option>
                <option value="Iceland">🇮🇸 Iceland</option>
                <option value="Italy">🇮🇹 Italy</option>
                <option value="Jamaica">🇯🇲 Jamaica</option>
                <option value="Japan">🇯🇵 Japan</option>
                <option value="Jordan">🇯🇴 Jordan</option>
                <option value="Kazakhstan">🇰🇿 Kazakhstan</option>
                <option value="Kenya">🇰🇪 Kenya</option>
                <option value="Kyrgyzstan">🇰🇬 Kyrgyzstan</option>
                <option value="Kiribati">🇰🇮 Kiribati</option>
                <option value="Kuwait">🇰🇼 Kuwait</option>
                <option value="Laos">🇱🇦 Laos</option>
                <option value="Lesotho">🇱🇸 Lesotho</option>
                <option value="Latvia">🇱🇻 Latvia</option>
                <option value="Lebanon">🇱🇧 Lebanon</option>
                <option value="Liberia">🇱🇷 Liberia</option>
                <option value="Libya">🇱🇾 Libya</option>
                <option value="Liechtenstein">🇱🇮 Liechtenstein</option>
                <option value="Lithuania">🇱🇹 Lithuania</option>
                <option value="Luxembourg">🇱🇺 Luxembourg</option>
                <option value="North Macedonia">🇲🇰 North Macedonia</option>
                <option value="Madagascar">🇲🇬 Madagascar</option>
                <option value="Malaysia">🇲🇾 Malaysia</option>
                <option value="Malawi">🇲🇼 Malawi</option>
                <option value="Maldives">🇲🇻 Maldives</option>
                <option value="Mali">🇲🇱 Mali</option>
                <option value="Malta">🇲🇹 Malta</option>
                <option value="Morocco">🇲🇦 Morocco</option>
                <option value="Marshall Islands">🇲🇭 Marshall Islands</option>
                <option value="Mauritius">🇲🇺 Mauritius</option>
                <option value="Mauritania">🇲🇷 Mauritania</option>
                <option value="Mexico">🇲🇽 Mexico</option>
                <option value="Micronesia">🇫🇲 Micronesia</option>
                <option value="Moldova">🇲🇩 Moldova</option>
                <option value="Monaco">🇲🇨 Monaco</option>
                <option value="Mongolia">🇲🇳 Mongolia</option>
                <option value="Montenegro">🇲🇪 Montenegro</option>
                <option value="Mozambique">🇲🇿 Mozambique</option>
                <option value="Namibia">🇳🇦 Namibia</option>
                <option value="Nauru">🇳🇷 Nauru</option>
                <option value="Nepal">🇳🇵 Nepal</option>
                <option value="Nicaragua">🇳🇮 Nicaragua</option>
                <option value="Niger">🇳🇪 Niger</option>
                <option value="Nigeria">🇳🇬 Nigeria</option>
                <option value="Norway">🇳🇴 Norway</option>
                <option value="New Zealand">🇳🇿 New Zealand</option>
                <option value="Oman">🇴🇲 Oman</option>
                <option value="Uganda">🇺🇬 Uganda</option>
                <option value="Uzbekistan">🇺🇿 Uzbekistan</option>
                <option value="Pakistan">🇵🇰 Pakistan</option>
                <option value="Palau">🇵🇼 Palau</option>
                <option value="Panama">🇵🇦 Panama</option>
                <option value="Papua New Guinea">🇵🇬 Papua New Guinea</option>
                <option value="Paraguay">🇵🇾 Paraguay</option>
                <option value="Netherlands">🇳🇱 Netherlands</option>
                <option value="Peru">🇵🇪 Peru</option>
                <option value="Philippines">🇵🇭 Philippines</option>
                <option value="Poland">🇵🇱 Poland</option>
                <option value="Portugal">🇵🇹 Portugal</option>
                <option value="Qatar">🇶🇦 Qatar</option>
                <option value="Romania">🇷🇴 Romania</option>
                <option value="United Kingdom">🇬🇧 United Kingdom</option>
                <option value="Russia">🇷🇺 Russia</option>
                <option value="Rwanda">🇷🇼 Rwanda</option>
                <option value="Saint Kitts and Nevis">🇰🇳 Saint Kitts and Nevis</option>
                <option value="San Marino">🇸🇲 San Marino</option>
                <option value="Saint Vincent and the Grenadines">🇻🇨 Saint Vincent and the Grenadines</option>
                <option value="Saint Lucia">🇱🇨 Saint Lucia</option>
                <option value="El Salvador">🇸🇻 El Salvador</option>
                <option value="Samoa">🇼🇸 Samoa</option>
                <option value="Sao Tome and Principe">🇸🇹 Sao Tome and Principe</option>
                <option value="Senegal">🇸🇳 Senegal</option>
                <option value="Serbia">🇷🇸 Serbia</option>
                <option value="Seychelles">🇸🇨 Seychelles</option>
                <option value="Sierra Leone">🇸🇱 Sierra Leone</option>
                <option value="Singapore">🇸🇬 Singapore</option>
                <option value="Slovakia">🇸🇰 Slovakia</option>
                <option value="Slovenia">🇸🇮 Slovenia</option>
                <option value="Somalia">🇸🇴 Somalia</option>
                <option value="Sudan">🇸🇩 Sudan</option>
                <option value="South Sudan">🇸🇸 South Sudan</option>
                <option value="Sri Lanka">🇱🇰 Sri Lanka</option>
                <option value="Sweden">🇸🇪 Sweden</option>
                <option value="Switzerland">🇨🇭 Switzerland</option>
                <option value="Suriname">🇸🇷 Suriname</option>
                <option value="Eswatini">🇸🇿 Eswatini</option>
                <option value="Syria">🇸🇾 Syria</option>
                <option value="Tajikistan">🇹🇯 Tajikistan</option>
                <option value="Tanzania">🇹🇿 Tanzania</option>
                <option value="Chad">🇹🇩 Chad</option>
                <option value="Czech Republic">🇨🇿 Czech Republic</option>
                <option value="Thailand">🇹🇭 Thailand</option>
                <option value="Timor-Leste">🇹🇱 Timor-Leste</option>
                <option value="Togo">🇹🇬 Togo</option>
                <option value="Tonga">🇹🇴 Tonga</option>
                <option value="Trinidad and Tobago">🇹🇹 Trinidad and Tobago</option>
                <option value="Tunisia">🇹🇳 Tunisia</option>
                <option value="Turkmenistan">🇹🇲 Turkmenistan</option>
                <option value="Turkey">🇹🇷 Turkey</option>
                <option value="Tuvalu">🇹🇻 Tuvalu</option>
            </select>

        </div>
        <div class="form-group full-width">
            <label for="nationalite">Registration number (*)</label>
            <input type="text" id="matricule" name="matricule" placeholder="" required />
        </div>
        <div class="form-group full-width">
            <label for="nationalite">Coach level (*)</label>
            <input type="text" id="level" name="level" placeholder="" required />
        </div>
        <div class="form-group full-width">
            <label>Certificate (*)</label>
            <div class="file-upload">
                <span>📁 Click or drag a file here</span>
                <input type="file" name="certificat" accept=".pdf,.jpg,.png" required onchange="previewCertificate(event)" />
            </div>
            <div class="certificate-preview" id="certificatePreview"></div>
        </div>

        <input type="text" id="role" name="role" value="Coach body guard" readonly />
        <button type="submit">Register</button>
    </form>
</div>
<script>
    function previewImage(event, previewId) {
        const input = event.target;
        const previewContainer = document.getElementById(previewId);

        // Vider l'ancien aperçu
        previewContainer.innerHTML = "";

        if (input.files && input.files[0]) {
            const reader = new FileReader();

            reader.onload = function(e) {
                const img = document.createElement("img");
                img.src = e.target.result;
                previewContainer.appendChild(img);
            };

            reader.readAsDataURL(input.files[0]);
        }

        sendHeight();
    }

    function previewCertificate(event) {
        const input = event.target;
        const previewContainer = document.getElementById('certificatePreview');

        // Vider l'ancien aperçu
        previewContainer.innerHTML = "";

        if (input.files && input.files[0]) {
            const file = input.files[0];
            const fileInfo = document.createElement('div');

            // Afficher les informations du fichier
            fileInfo.innerHTML = `
                <p><strong>File Name:</strong> ${file.name}</p>
                <p><strong>File Type:</strong> ${file.type}</p>
                <p><strong>File Size:</strong> ${(file.size / 1024).toFixed(2)} KB</p>
            `;

            previewContainer.appendChild(fileInfo);

            // Si c'est une image, afficher un aperçu
            if (file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement("img");
                    img.src = e.target.result;
                    img.style.maxWidth = '200px';
                    img.style.maxHeight = '200px';
                    img.style.marginTop = '10px';
                    img.style.borderRadius = '8px';
                    previewContainer.appendChild(img);
                };
                reader.readAsDataURL(file);
            }
        }

        sendHeight();
    }
    function sendHeight() {
        const height = document.documentElement.scrollHeight;
        window.parent.postMessage({ type: 'resize', height: height }, '*');
    }

    // Envoyer la hauteur au chargement et à chaque redimensionnement
    window.addEventListener('load', sendHeight);
    window.addEventListener('resize', sendHeight);

    // Observer les changements de contenu
    const observer = new MutationObserver(sendHeight);
    observer.observe(document.body, { childList: true, subtree: true });
</script>
</body>
</html>
