<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion</title>
    <style>
        /* Import d'une belle police */
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            background-color: transparent;
            display: flex;
            justify-content: center;
            align-items: center;
         //   height: 100vh;
        }

        .login-container {
            background-color: white;
            padding: 40px 30px;
            border-radius: 20px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
        }

        .login-container h2 {
            text-align: center;
            margin-bottom: 30px;
            color: #5C3F17;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            color: #5C3F17;
            margin-bottom: 8px;
            font-weight: 500;
        }

        input {
            width: 100%;
            padding: 12px;
            border: 1px solid #8C8570;
            border-radius: 8px;
            outline: none;
            font-size: 14px;
            transition: border 0.3s;
            background-color: #FBFBFB;
        }

        input:focus {
            border-color: #D30402;
        }

        .btn {
            width: 100%;
            background-color: #D30402;
            color: white;
            border: none;
            padding: 14px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: background 0.3s;
        }

        .btn:hover {
            background-color: #b90302;
        }

        .link {
            text-align: center;
            margin-top: 20px;
        }

        .link a {
            color: #5C3F17;
            text-decoration: none;
            font-weight: 500;
        }

        .link a:hover {
            text-decoration: underline;
        }

        @media (max-width: 480px) {
            .login-container {
                padding: 30px 20px;
            }
            h2 {
                font-size: 22px;
            }
        }
    </style>
</head>
<body>

<div class="login-container">
    <h2>Connexion</h2>
    <form action="{{ route('login') }}" method="POST" target="_parent">
        @csrf
        <div class="form-group">
            <label for="email">Login</label>
            <input type="text" id="email" name="email" required>
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" placeholder="*******" required>
        </div>

        <button type="submit" class="btn">Log in</button>

{{--        <div class="link">--}}
{{--            <a href="#">Mot de passe oublié ?</a>--}}
{{--        </div>--}}
    </form>
</div>
<script>
    function sendHeight() {
        const height = document.documentElement.scrollHeight;
        window.parent.postMessage({ type: 'resize', height: height }, '*');
    }

    // Envoyer la hauteur au chargement et à chaque redimensionnement
    window.addEventListener('load', sendHeight);
    window.addEventListener('resize', sendHeight);

    // Observer les changements de contenu
    const observer = new MutationObserver(sendHeight);
    observer.observe(document.body, { childList: true, subtree: true });
</script>
</body>
</html>
