<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Dashboard')</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        :root {
            --dark-brown: #5C3F17;
            --red: #D30402;
            --gray: #8C8570;
            --off-white: #FBFBFB;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { display: flex; min-height: 100vh; background-color: var(--off-white); }

        /* Sidebar */
        .sidebar {
            width: 250px;
            background: var(--dark-brown);
            color: var(--off-white);
            display: flex;
            flex-direction: column;
            transition: all 0.3s ease;
            position: fixed;
            height: 100vh;
        }
        .sidebar h2 { text-align: center; padding: 20px 0; background: var(--red); font-weight: 700; letter-spacing: 1px; }
        .sidebar ul { list-style: none; padding: 20px 0; }
        .sidebar ul li { padding: 15px 20px; cursor: pointer; transition: background 0.3s; }
        .sidebar ul li:hover { background: rgba(255, 255, 255, 0.1); }
        .sidebar ul li a { color: var(--off-white); text-decoration: none; font-size: 15px; display: flex; align-items: center; gap: 10px; }
        .submenu { display: none; list-style: none; padding-left: 20px; }
        .submenu li { padding: 10px 0; }
        .submenu li a { font-size: 14px; }
        .submenu.active { display: block; }

        /* Main content */
        .main-content { margin-left: 250px; flex-grow: 1; background: var(--off-white); transition: margin-left 0.3s ease; }
        .navbar { background: var(--red); color: var(--off-white); padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; }
        .navbar h1 { font-size: 22px; }
        .navbar .menu-toggle { display: none; font-size: 24px; cursor: pointer; }

        /* Content */
        .content { padding: 30px; }
        table { width: 100%; border-collapse: collapse; background: #fff; border-radius: 10px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
        th, td { text-align: left; padding: 15px; }
        th { background: var(--dark-brown); color: var(--off-white); font-weight: 600; font-size: 14px; }
        tr:nth-child(even) { background: #f5f5f5; }
        tr:hover { background: rgba(211, 4, 2, 0.05); }
        td { color: var(--gray); font-size: 14px; }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar { width: 200px; position: absolute; left: -200px; }
            .sidebar.active { left: 0; }
            .main-content { margin-left: 0; }
            .navbar .menu-toggle { display: block; }
            table { font-size: 13px; }
            th, td { padding: 10px; }
        }

        @media (max-width: 480px) { .navbar h1 { font-size: 18px; } }


    </style>
    <style>
        .status-validated {
            color: #28a745;
            font-weight: bold;
        }

        .status-refused {
            color: #dc3545;
            font-weight: bold;
        }

        .status-pending {
            color: #ffc107;
            font-weight: bold;
        }

        .action-buttons {
            display: flex;
            gap: 8px;
            justify-content: center;
        }

        .btn-validate, .btn-refuse {
            border: none;
            border-radius: 4px;
            padding: 8px 12px;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .btn-validate {
            background-color: #28a745;
            color: white;
        }

        .btn-validate:hover {
            background-color: #218838;
            transform: scale(1.1);
        }

        .btn-refuse {
            background-color: #dc3545;
            color: white;
        }

        .btn-refuse:hover {
            background-color: #c82333;
            transform: scale(1.1);
        }

        .btn-validate:disabled, .btn-refuse:disabled {
            background-color: #6c757d;
            cursor: not-allowed;
            transform: none;
        }
    </style>
</head>
<body>
<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <h2>Mon Menu</h2>
    <ul>
{{--        <li><a href="#">🏠 Tableau de bord</a></li>--}}
        <li>
            <a href="javascript:void(0)" onclick="toggleSubMenu('members-submenu')">👥 Registered Members ▼</a>
            <ul id="members-submenu" class="submenu">
                <li><a href="{{ route('admin.members.demande.blackbelt') }}">Black belt degree</a></li>
                <li><a href="{{ route('admin.members.demande.selfdefense') }}">Coach self defense</a></li>
                <li><a href="{{ route('admin.members.demande.bodyguard') }}">Coach body guard</a></li>
            </ul>
        </li>
        <li><a href="{{ route('admin.gyms.index') }}">🏋️‍♀️ Gyms enregistrés</a></li>
        <li>
            <a class="dropdown-item" href="{{ route('logout') }}"
               onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                🚪 Déconnexion
            </a>

            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
            </form>
        </li>
    </ul>
</div>

<!-- Main content -->
<div class="main-content">
    <div class="navbar">
        <span class="menu-toggle" onclick="toggleSidebar()">☰</span>
        <h1>@yield('title')</h1>
        <div class="user-info">👤 Admin</div>
    </div>
    <div class="content">
        @yield('content')
    </div>
</div>

<script>
    function toggleSidebar() { document.getElementById('sidebar').classList.toggle('active'); }
    function toggleSubMenu(id) { document.getElementById(id).classList.toggle('active'); }
</script>
<script>
    function sendHeight() {
        const height = document.documentElement.scrollHeight;
        window.parent.postMessage({ type: 'resize', height: height }, '*');
    }

    // Envoyer la hauteur au chargement et à chaque redimensionnement
    window.addEventListener('load', sendHeight);
    window.addEventListener('resize', sendHeight);

    // Observer les changements de contenu
    const observer = new MutationObserver(sendHeight);
    observer.observe(document.body, { childList: true, subtree: true });
</script>

</body>
</html>
