@extends('layouts.app')

@section('title', $title ?? 'Members List')

@section('content')
    <h2>{{ $title ?? 'Members List' }} Members</h2>

    @if($members->count() > 0)
        <table>
            <thead>
            <tr>
                <th>#</th>
                <th>Nom</th>
                <th>Prénom</th>
                <th>Email</th>
                <th>Matricule</th>
                <th>Téléphone</th>
                <th>Adresse</th>
                <th>Nationalité</th>
                <th>Role</th>
                <th>Certificat</th>
                <th>Validé</th>
                <th>Actions</th>

            </tr>
            </thead>
            <tbody>
            @foreach($members as $member)
                <tr>
                    <td>
                        <img src="data:image/jpeg;base64,{{ base64_encode($member->photo1) }}" style="width: 50px">
                    </td>
                    <td>{{ $member->nom }}</td>
                    <td>{{ $member->prenom }}</td>
                    <td>{{ $member->email }}</td>
                    <td>{{ $member->matricule }}</td>
                    <td>{{ $member->tel }}</td>
                    <td>{{ $member->adresse }}</td>
                    <td>{{ $member->nationalite }}</td>
                    <td>{{ $member->role }}</td>
                    <td>
                        @if($member->certificat)
                            <a href="{{ asset('project/storage/app/public/' . $member->certificat) }}" target="_blank">
                                Ouvrir le certificat
                            </a>
                        @else
                            Aucun certificat
                        @endif
                    </td>
                    <td>
                        @if($member->validate === 1)
                            <span class="status-validated">Validé</span>
                        @elseif($member->validate === 0)
                            <span class="status-refused">Refusé</span>
                        @else
                            <span class="status-pending">En attente</span>
                        @endif
                    </td>

                    <td class="action-buttons">
                        @if(!$member->validate)
                            <a href="{{ route('admin.members.demande.validate', $member->id) }}" class="btn-validate" title="Valider l'inscription">
                                Validate
                            </a>
                        @else
                            <a href="{{ route('admin.members.demande.validate', $member->id) }}" class="btn-refuse" title="Refuser l'inscription">
                                Refuse
                            </a>
                        @endif

                        <a href="{{ route('admin.members.demande.edit', $member->id) }}" class="btn-validate" title="Modifier">
                            Edit
                        </a>

                        <a href="{{ route('admin.members.demande.destroy', $member->id) }}" class="btn-refuse" title="Supprimer l'inscription">
                            Supprimer
                        </a>
                    </td>

                </tr>
            @endforeach
            </tbody>
        </table>
    @else
        <p>Aucun membre trouvé pour ce certificat.</p>
    @endif
@endsection

@section('scripts')

@endsection
