@extends('layouts.app')

@section('title', $title ?? 'Modifier un Gym')

@section('content')
    <div class="content">
        <h2>{{ $title ?? 'Modifier le Gym' }}</h2>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('admin.gyms.update', $gym->id) }}" method="POST" enctype="multipart/form-data" class="gym-form">
            @csrf
            @method('PUT')

            <div class="form-grid">
                <!-- Informations de base -->
                <div class="form-group">
                    <label for="informations">Nom du Gym *</label>
                    <input type="text" id="informations" name="informations" value="{{ old('informations', $gym->informations) }}" required>
                </div>

                <div class="form-group">
                    <label for="specialite">Spécialité</label>
                    <input type="text" id="specialite" name="specialite" value="{{ old('specialite', $gym->specialite) }}" placeholder="Ex: Martial Arts, Fitness, CrossFit...">
                </div>

                <div class="form-group">
                    <label for="nationalite">Nationalité *</label>
                    <input type="text" id="nationalite" name="nationalite" value="{{ old('nationalite', $gym->nationalite) }}" required>
                </div>

                <!-- Contact -->
                <div class="form-group">
                    <label for="adresse">Adresse *</label>
                    <textarea id="adresse" name="adresse" rows="2" required>{{ old('adresse', $gym->adresse) }}</textarea>
                </div>

                <div class="form-group">
                    <label for="tel">Téléphone *</label>
                    <input type="text" id="tel" name="tel" value="{{ old('tel', $gym->tel) }}" required>
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" value="{{ old('email', $gym->email) }}">
                </div>

                <div class="form-group">
                    <label for="website">Site Web</label>
                    <input type="url" id="website" name="website" value="{{ old('website', $gym->website) }}" placeholder="https://...">
                </div>

                <!-- Description -->
                <div class="form-group full-width">
                    <label for="description">Description *</label>
                    <textarea id="description" name="description" rows="5" required>{{ old('description', $gym->description) }}</textarea>
                </div>

                <!-- Images -->
                <div class="form-group">
                    <label for="photo1">Photo 1</label>
                    @if($gym->photo1)
                        <div class="current-image">
                            <img src="data:image/jpeg;base64,{{ base64_encode($gym->photo1) }}" alt="Photo actuelle 1">
                            <label class="checkbox-label">
                                <input type="checkbox" name="remove_photo1" value="1">
                                <span>Supprimer cette image</span>
                            </label>
                        </div>
                    @endif
                    <input type="file" id="photo1" name="photo1" accept="image/*">
                    <small>Format: JPG, PNG, GIF | Max: 2MB</small>
                </div>

                <div class="form-group">
                    <label for="photo2">Photo 2</label>
                    @if($gym->photo2)
                        <div class="current-image">
                            <img src="data:image/jpeg;base64,{{ base64_encode($gym->photo2) }}" alt="Photo actuelle 2">
                            <label class="checkbox-label">
                                <input type="checkbox" name="remove_photo2" value="1">
                                <span>Supprimer cette image</span>
                            </label>
                        </div>
                    @endif
                    <input type="file" id="photo2" name="photo2" accept="image/*">
                    <small>Format: JPG, PNG, GIF | Max: 2MB</small>
                </div>

                <div class="form-group">
                    <label for="photo3">Photo 3</label>
                    @if($gym->photo3)
                        <div class="current-image">
                            <img src="data:image/jpeg;base64,{{ base64_encode($gym->photo3) }}" alt="Photo actuelle 3">
                            <label class="checkbox-label">
                                <input type="checkbox" name="remove_photo3" value="1">
                                <span>Supprimer cette image</span>
                            </label>
                        </div>
                    @endif
                    <input type="file" id="photo3" name="photo3" accept="image/*">
                    <small>Format: JPG, PNG, GIF | Max: 2MB</small>
                </div>

                <!-- Validation -->
                <div class="form-group">
                    <label for="validate" class="checkbox-label">
                        <input type="checkbox" id="validate" name="validate" value="1" {{ old('validate', $gym->validate) ? 'checked' : '' }}>
                        <span>Gym validé (visible sur le site)</span>
                    </label>
                </div>
            </div>

            <!-- Prévisualisation des nouvelles images -->
            <div class="image-preview">
                <div class="preview-container" id="preview1">
                    @if($gym->photo1)
                        <img src="data:image/jpeg;base64,{{ base64_encode($gym->photo1) }}" alt="Photo actuelle 1">
                    @else
                        <span>Aperçu Photo 1</span>
                    @endif
                </div>
                <div class="preview-container" id="preview2">
                    @if($gym->photo2)
                        <img src="data:image/jpeg;base64,{{ base64_encode($gym->photo2) }}" alt="Photo actuelle 2">
                    @else
                        <span>Aperçu Photo 2</span>
                    @endif
                </div>
                <div class="preview-container" id="preview3">
                    @if($gym->photo3)
                        <img src="data:image/jpeg;base64,{{ base64_encode($gym->photo3) }}" alt="Photo actuelle 3">
                    @else
                        <span>Aperçu Photo 3</span>
                    @endif
                </div>
            </div>

            <!-- Boutons -->
            <div class="form-actions">
                <button type="submit" class="btn-submit">
                    <i class="fas fa-save"></i> Enregistrer les modifications
                </button>
                <a href="{{ route('admin.gyms.index') }}" class="btn-cancel">
                    <i class="fas fa-times"></i> Annuler
                </a>
            </div>
        </form>
    </div>

    <style>
        .gym-form {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 16px rgba(0,0,0,0.08);
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group.full-width {
            grid-column: 1 / -1;
        }

        .form-group label {
            margin-bottom: 8px;
            font-weight: 500;
            color: #333;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: #D30402;
            box-shadow: 0 0 0 2px rgba(211,4,2,0.1);
        }

        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-group small {
            font-size: 12px;
            color: #666;
            margin-top: 4px;
        }

        .current-image {
            margin-bottom: 10px;
        }

        .current-image img {
            max-width: 100%;
            max-height: 150px;
            object-fit: cover;
            border-radius: 6px;
            margin-bottom: 8px;
            border: 2px solid #eee;
        }

        .checkbox-label {
            display: flex;
            align-items: center;
            cursor: pointer;
            margin-top: 5px;
        }

        .checkbox-label input {
            margin-right: 10px;
            width: 18px;
            height: 18px;
        }

        .image-preview {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin: 30px 0;
        }

        .preview-container {
            border: 2px dashed #ddd;
            border-radius: 8px;
            min-height: 150px;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            background: #f9f9f9;
        }

        .preview-container img {
            max-width: 100%;
            max-height: 150px;
            object-fit: cover;
        }

        .preview-container span {
            color: #999;
            font-size: 14px;
        }

        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }

        .btn-submit {
            background: #D30402;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 6px;
            font-weight: 500;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: background 0.3s;
        }

        .btn-submit:hover {
            background: #b90302;
        }

        .btn-cancel {
            background: #f0f0f0;
            color: #333;
            padding: 12px 30px;
            border-radius: 6px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: background 0.3s;
        }

        .btn-cancel:hover {
            background: #e0e0e0;
        }

        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr;
            }

            .image-preview {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <script>
        // Prévisualisation des nouvelles images
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.innerHTML = `<img src="${e.target.result}" alt="Aperçu">`;
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        // Écouteurs pour les inputs de fichiers
        document.getElementById('photo1')?.addEventListener('change', function() {
            previewImage(this, 'preview1');
        });

        document.getElementById('photo2')?.addEventListener('change', function() {
            previewImage(this, 'preview2');
        });

        document.getElementById('photo3')?.addEventListener('change', function() {
            previewImage(this, 'preview3');
        });

        // Gérer les cases à cocher pour la suppression
        document.querySelectorAll('input[name^="remove_photo"]').forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const photoNumber = this.name.replace('remove_photo', '');
                const fileInput = document.getElementById('photo' + photoNumber);
                const preview = document.getElementById('preview' + photoNumber);

                if (this.checked) {
                    fileInput.disabled = true;
                    fileInput.value = '';
                    preview.innerHTML = '<span>Image sera supprimée</span>';
                } else {
                    fileInput.disabled = false;
                    preview.innerHTML = '<span>Aperçu Photo ' + photoNumber + '</span>';
                }
            });
        });
    </script>
@endsection