<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RegisterMember extends Model
{
    use HasFactory;
    protected $fillable = [
        'photo1',
        'photo2',
        'photo3',
        'nom',
        'prenom',
        'adresse',
        'tel',
        'email',
        'nationalite',
        'matricule',
        'degree',
        'level',
        'role',
        'certificat',
        'validate',
        'country_code',

    ];
    public function getCountryCodeAttribute($value)
    {
        // Si déjà défini en DB, on le retourne
        if ($value) {
            return strtolower($value);
        }

        // Sinon on cherche selon nationalité
        $countries = [
            // Afrique du Nord
            'Tunisia' => 'tn', 'Tunisie' => 'tn',
            'Morocco' => 'ma', 'Maroc' => 'ma',
            'Algeria' => 'dz', 'Algérie' => 'dz',
            'Libya' => 'ly', 'Libye' => 'ly',
            'Egypt' => 'eg', 'Égypte' => 'eg',
            'Sudan' => 'sd', 'Soudan' => 'sd',

            // Moyen-Orient
            'Saudi Arabia' => 'sa', 'Arabie Saoudite' => 'sa',
            'United Arab Emirates' => 'ae', 'Émirats Arabes Unis' => 'ae',
            'Qatar' => 'qa', 'Kuwait' => 'kw', 'Bahrain' => 'bh', 'Oman' => 'om',
            'Jordan' => 'jo', 'Lebanon' => 'lb', 'Syria' => 'sy', 'Iraq' => 'iq',
            'Palestine' => 'ps',  'Yemen' => 'ye',

            // Europe
            'France' => 'fr', 'Germany' => 'de', 'Italie' => 'it', 'Italy' => 'it',
            'Spain' => 'es', 'Espagne' => 'es', 'Portugal' => 'pt',
            'United Kingdom' => 'gb', 'Angleterre' => 'gb', 'UK' => 'gb',
            'Belgium' => 'be', 'Belgique' => 'be', 'Switzerland' => 'ch', 'Suisse' => 'ch',
            'Netherlands' => 'nl', 'Pays-Bas' => 'nl', 'Austria' => 'at', 'Greece' => 'gr',
            'Sweden' => 'se', 'Norway' => 'no', 'Denmark' => 'dk', 'Finland' => 'fi',
            'Ireland' => 'ie', 'Poland' => 'pl', 'Romania' => 'ro', 'Czech Republic' => 'cz',

            // Amérique du Nord / Sud
            'USA' => 'us', 'United States' => 'us', 'États-Unis' => 'us',
            'Canada' => 'ca', 'Mexico' => 'mx', 'Brazil' => 'br', 'Brésil' => 'br',
            'Argentina' => 'ar', 'Chile' => 'cl', 'Colombia' => 'co', 'Venezuela' => 've',

            // Afrique subsaharienne
            'Senegal' => 'sn', 'Sénégal' => 'sn', 'Mali' => 'ml', 'Niger' => 'ne',
            'Ivory Coast' => 'ci', 'Côte d’Ivoire' => 'ci', 'Burkina Faso' => 'bf',
            'Cameroon' => 'cm', 'Cameroun' => 'cm', 'Nigeria' => 'ng', 'Ghana' => 'gh',
            'Kenya' => 'ke', 'Tanzania' => 'tz', 'Ethiopia' => 'et', 'South Africa' => 'za',

            // Asie
            'China' => 'cn', 'Chine' => 'cn', 'Japan' => 'jp', 'Japon' => 'jp',
            'South Korea' => 'kr', 'Corée du Sud' => 'kr', 'India' => 'in', 'Inde' => 'in',
            'Pakistan' => 'pk', 'Bangladesh' => 'bd', 'Indonesia' => 'id', 'Malaysia' => 'my',
            'Singapore' => 'sg', 'Thailand' => 'th', 'Philippines' => 'ph', 'Vietnam' => 'vn',

            // Océanie
            'Australia' => 'au', 'Australie' => 'au', 'New Zealand' => 'nz', 'Nouvelle-Zélande' => 'nz',
        ];

        return $countries[$this->attributes['nationalite']] ?? null;
    }
}
